/*
 * Decompiled with CFR 0.152.
 */
package juvoo.killsmultiplyhealth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class KillsMultiplyHealth
extends JavaPlugin
implements Listener {
    public HashMap<UUID, Integer> kills;
    private ArrayList<UUID> players;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.kills = new HashMap();
        this.players = new ArrayList();
    }

    @EventHandler
    public void onDeath(EntityDamageByEntityEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            if (event.getEntity().isDead() && event.getDamager() instanceof Player && this.players.contains(event.getDamager().getUniqueId())) {
                Player p = (Player)event.getDamager();
                UUID uuid = p.getUniqueId();
                if (this.kills != null) {
                    if (this.kills.containsKey(uuid)) {
                        Integer count = this.kills.get(uuid);
                        this.kills.remove(uuid);
                        count = count + 1;
                        this.kills.put(uuid, count);
                        if (this.kills.get(uuid) % 5 == 0) {
                            Double max = p.getMaxHealth();
                            p.setMaxHealth(max * 2.0);
                            p.sendMessage(ChatColor.GREEN + "Your max health has been increased to " + ChatColor.GOLD + ChatColor.BOLD + max + ChatColor.RESET + ChatColor.GREEN + " hearts!");
                        }
                    } else {
                        this.kills.put(uuid, 1);
                    }
                }
            }
        }, 1L);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player && args.length == 1 || args.length == 2 && label.equalsIgnoreCase("killsmultiplyhealth:health") || label.equalsIgnoreCase("health")) {
            Player player = (Player)sender;
            if (args[0].equalsIgnoreCase("reset")) {
                player.resetMaxHealth();
                sender.sendMessage(ChatColor.GREEN + "Your max health has been reset!");
            } else if (args[0].equalsIgnoreCase("set") && args[1] != null) {
                if (Integer.valueOf(args[1]) != null) {
                    int health = Integer.valueOf(args[1]);
                    player.setMaxHealth((double)health);
                    sender.sendMessage(ChatColor.GREEN + "Your max health has been set to " + ChatColor.GOLD + ChatColor.BOLD + (double)health / 2.0 + ChatColor.RESET + ChatColor.GREEN + " hearts!");
                } else {
                    sender.sendMessage(ChatColor.RED + "Number invalid.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Invalid Usage. Please try:");
                sender.sendMessage(ChatColor.GREEN + "/health set <num>");
                sender.sendMessage(ChatColor.GREEN + "/health reset");
            }
        } else if (args.length != 1 && args.length != 2) {
            sender.sendMessage(ChatColor.RED + "Invalid Usage. Please try:");
            sender.sendMessage(ChatColor.GREEN + "/health set <num>");
            sender.sendMessage(ChatColor.GREEN + "/health reset");
        }
        if (args.length == 2 && (label.equals("kmh") || label.equals("killsmultiplyhealth:kmh"))) {
            Player p = Bukkit.getPlayer((String)args[1]);
            if (p != null) {
                if (args[0].equalsIgnoreCase("add")) {
                    if (!this.players.contains(p.getUniqueId())) {
                        this.players.add(p.getUniqueId());
                        sender.sendMessage(ChatColor.GREEN + "Challenge activated for " + ChatColor.RESET + ChatColor.GOLD + ChatColor.BOLD + p.getName());
                    } else {
                        sender.sendMessage(ChatColor.RED + "Challenge already activated for " + ChatColor.RESET + ChatColor.GOLD + ChatColor.BOLD + p.getName());
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (this.players.contains(p.getUniqueId())) {
                        this.players.remove(p.getUniqueId());
                        sender.sendMessage(ChatColor.GREEN + "Challenge deactivated for " + ChatColor.RESET + ChatColor.GOLD + ChatColor.BOLD + p.getName());
                    } else {
                        sender.sendMessage(ChatColor.RED + "Challenge not activated for " + ChatColor.RESET + ChatColor.GOLD + ChatColor.BOLD + p.getName());
                    }
                } else if (!args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove")) {
                    sender.sendMessage(ChatColor.RED + "Invalid Usage. Please try:");
                    sender.sendMessage(ChatColor.GREEN + "/kmh add <player>");
                    sender.sendMessage(ChatColor.GREEN + "/kmh remove <player>");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Invalid player!");
            }
        } else if (args.length != 2) {
            sender.sendMessage(ChatColor.RED + "Invalid Usage. Please try:");
            sender.sendMessage(ChatColor.GREEN + "/kmh add <player>");
            sender.sendMessage(ChatColor.GREEN + "/kmh remove <player>");
        }
        return true;
    }
}

