/*
 * Decompiled with CFR 0.152.
 */
package me.otrek2002.JoinLeaveManager;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigUtil
extends YamlConfiguration {
    private final Plugin plugin;
    private final File configFile;

    public ConfigUtil(String name, Plugin plugin) throws IOException, InvalidConfigurationException {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), name.endsWith(".yml") ? name : String.valueOf(name) + ".yml");
        this.loadConfig();
    }

    public void save() {
        try {
            this.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "There was an error while saving the " + this.configFile.getName() + " configuration!", e);
        }
    }

    public void reload() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "There was an error while creating the " + this.configFile.getName() + " configuration file!", e);
        }
        catch (InvalidConfigurationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "The configuration \"" + this.configFile.getName() + "\" is invalid!", e);
        }
    }

    private void loadConfig() throws IOException, InvalidConfigurationException {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!this.configFile.exists()) {
            try {
                this.plugin.saveResource(this.configFile.getName(), false);
            }
            catch (IllegalArgumentException e) {
                this.configFile.createNewFile();
            }
        }
        this.load(this.configFile);
    }

    public String getString(String path, boolean translateColors) {
        return this.getString(path, null, translateColors);
    }

    public String getString(String path, String defaultValue, boolean translateColors) {
        String value = this.getString(path, defaultValue);
        return value != null && translateColors ? ChatColor.translateAlternateColorCodes((char)'&', (String)value) : value;
    }
}

