/*
 * Decompiled with CFR 0.152.
 */
package sh.ome.itemex.functions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import sh.ome.itemex.Itemex;
import sh.ome.itemex.RAM.TopOrders;
import sh.ome.itemex.commands.ItemexCommand;
import sh.ome.itemex.files.CategoryFile;

public class sqliteDb {
    private static int MAX_BUFFER = 10000000;
    private String uuid;
    private String itemid;
    private String ordertype;
    private int amount;
    private double price;
    private long timestamp;

    public sqliteDb(ItemexCommand.Order sellorder) {
        this.uuid = sellorder.uuid;
        this.itemid = sellorder.itemid.toUpperCase();
        this.ordertype = sellorder.ordertype;
        this.amount = sellorder.amount;
        this.price = sellorder.price;
        this.timestamp = Instant.now().getEpochSecond();
    }

    public boolean createSellOrder() {
        return this.insertIntoDB("SELLORDERS");
    }

    public boolean createBuyOrder() {
        return this.insertIntoDB("BUYORDERS");
    }

    public static void createDBifNotExists() {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS SELLORDERS (id INTEGER PRIMARY KEY AUTOINCREMENT     , player_uuid      TEXT    ,  itemid           TEXT    ,  ordertype        TEXT    ,  amount           TEXT     ,  price            REAL     ,  timestamp        TEXT    )";
            String sql2 = "CREATE TABLE IF NOT EXISTS BUYORDERS (id INTEGER PRIMARY KEY AUTOINCREMENT     , player_uuid      TEXT    ,  itemid           TEXT    ,  ordertype        TEXT    ,  amount           TEXT     ,  price            REAL     ,  timestamp        TEXT    )";
            String sql3 = "CREATE TABLE IF NOT EXISTS FULFILLEDORDERS (id INTEGER PRIMARY KEY AUTOINCREMENT     , seller_uuid      TEXT    ,  buyer_uuid       TEXT    ,  itemid           TEXT    ,  amount           TEXT     ,  price            TEXT     ,  timestamp        TEXT    )";
            String sql4 = "CREATE TABLE IF NOT EXISTS PAYOUTS (id INTEGER PRIMARY KEY AUTOINCREMENT     , player_uuid      TEXT    ,  itemid           TEXT    ,  amount           TEXT     ,  timestamp        TEXT    )";
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql2);
            stmt.executeUpdate(sql3);
            stmt.executeUpdate(sql4);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
    }

    private boolean insertIntoDB(String table_name) {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "INSERT INTO " + table_name + " (player_uuid, itemid, ordertype, amount, price, timestamp) VALUES ('" + this.uuid + "', '" + this.itemid + "', '" + this.ordertype + "', '" + this.amount + "','" + this.price + "',  '" + this.timestamp + "' );";
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        sqliteDb.loadBestOrdersToRam(this.itemid, true);
        return true;
    }

    public static boolean insertFullfilledOrders(String seller_uuid, String buyer_uuid, String itemid, int amount, double price) {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "INSERT INTO FULFILLEDORDERS (seller_uuid, buyer_uuid, itemid, amount, price, timestamp) VALUES ('" + seller_uuid + "', '" + buyer_uuid + "', '" + itemid + "', '" + amount + "','" + price + "',  '" + Instant.now().getEpochSecond() + "' );";
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        return true;
    }

    public static boolean insertPayout(String player_uuid, String itemid, int amount) {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "INSERT INTO PAYOUTS (player_uuid,  itemid, amount, timestamp) VALUES ('" + player_uuid + "', '" + itemid + "', '" + amount + "', '" + Instant.now().getEpochSecond() + "' );";
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        return true;
    }

    public static boolean updatePayout(String player_uuid, String id, String itemid, int amount) {
        Connection c = null;
        Statement stmt = null;
        if (amount == 0) {
            try {
                Class.forName("org.sqlite.JDBC");
                c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
                stmt = c.createStatement();
                String sql = "DELETE FROM PAYOUTS WHERE id = " + id;
                stmt.executeUpdate(sql);
                stmt.close();
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                System.exit(0);
                return false;
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "UPDATE PAYOUTS SET amount = " + amount + " WHERE id = " + id;
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        return true;
    }

    public static Payout[] getPayout(String player_uuid) {
        Payout[] buffer = new Payout[MAX_BUFFER];
        int row_counter = 0;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "SELECT * FROM PAYOUTS WHERE player_uuid = '" + player_uuid + "' ORDER by timestamp";
            stmt.executeUpdate(sql);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                buffer[row_counter] = new Payout(rs.getString("id"), rs.getString("itemid"), rs.getInt("amount"));
                ++row_counter;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.out.println("ERROR at getPayou()");
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
        return buffer;
    }

    public static OrderBuffer[] getOrdersOfPlayer(String player_uuid, String itemid, boolean buy_or_sell, int page) {
        OrderBuffer[] buffer = new OrderBuffer[MAX_BUFFER];
        Connection c = null;
        Statement stmt = null;
        int row_counter = 0;
        String itemid_string = "";
        if (!itemid.equals("*")) {
            itemid_string = "AND itemid = '" + itemid + "'";
        }
        String sql = buy_or_sell ? "SELECT * FROM BUYORDERS WHERE player_uuid = '" + player_uuid + "' " + itemid_string + " ORDER by timestamp ASC" : "SELECT * FROM SELLORDERS WHERE player_uuid = '" + player_uuid + "' " + itemid_string + " ORDER by timestamp ASC";
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                buffer[row_counter] = new OrderBuffer(rs.getInt("id"), rs.getString("player_uuid"), rs.getString("itemid"), rs.getString("ordertype"), rs.getInt("amount"), rs.getDouble("price"), rs.getLong("timestamp"));
                ++row_counter;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.err.println("at getOrdersOfPlayer: " + e);
            System.exit(0);
        }
        return buffer;
    }

    public static void loadAllBestOrdersToRam(boolean update) {
        int amount = 0;
        for (String cat : CategoryFile.get().getStringList("categories.CATEGORY_NAMES")) {
            String[] category = cat.split(":", 0);
            for (String itemid : CategoryFile.get().getStringList("categories." + category[0])) {
                sqliteDb.loadBestOrdersToRam(itemid, update);
                ++amount;
            }
        }
        Bukkit.getLogger().info("\u001b[32m" + amount + " items loaded into RAM!\u001b[37m == (" + amount * 8 + " orders)");
    }

    public static void loadBestOrdersToRam(String item, boolean update) {
        ResultSet rs;
        String sql;
        double[] top_buy_price = new double[4];
        double[] top_sell_price = new double[4];
        int[] top_buy_amount = new int[4];
        int[] top_sell_amount = new int[4];
        int row_counter = 0;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            sql = "SELECT * FROM SELLORDERS WHERE itemid = '" + item + "' ORDER by price ASC LIMIT 4";
            stmt.executeUpdate(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                top_sell_price[row_counter] = rs.getDouble("price");
                top_sell_amount[row_counter] = rs.getInt("amount");
                ++row_counter;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
        row_counter = 0;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            sql = "SELECT * FROM BUYORDERS WHERE itemid = '" + item + "' ORDER by price DESC LIMIT 4";
            stmt.executeUpdate(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                top_buy_price[row_counter] = rs.getDouble("price");
                top_buy_amount[row_counter] = rs.getInt("amount");
                ++row_counter;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
        if (top_buy_price != null) {
            TopOrders topo = new TopOrders(top_buy_price, top_sell_price, top_buy_amount, top_sell_amount);
            Itemex.getPlugin().mtop.put(item, topo);
            boolean match = topo.find_order_match();
            if (match && update) {
                System.out.println("# DEBUG - at load best order to ram: item: " + item);
                sqliteDb.fulfillOrder(item);
            }
        }
    }

    public static OrderBuffer[] getBestOrders(String item) {
        ResultSet rs;
        String sql;
        OrderBuffer[] buffer = new OrderBuffer[8];
        OrderBuffer[] temp = new OrderBuffer[4];
        int row_counter = 0;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            sql = "SELECT * FROM SELLORDERS WHERE itemid = '" + item + "' ORDER by price ASC LIMIT 4";
            stmt.executeUpdate(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                buffer[row_counter] = new OrderBuffer(rs.getInt("id"), rs.getString("player_uuid"), rs.getString("itemid"), rs.getString("ordertype"), rs.getInt("amount"), rs.getDouble("price"), rs.getLong("timestamp"));
                ++row_counter;
            }
            for (int x = 0; x <= 3; ++x) {
                temp[x] = buffer[x];
            }
            int y = 0;
            for (int x = row_counter - 1; x >= 0; --x) {
                buffer[y] = temp[x];
                ++y;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            sql = "SELECT * FROM BUYORDERS WHERE itemid = '" + item + "' ORDER by price DESC LIMIT 4";
            stmt.executeUpdate(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                buffer[row_counter] = new OrderBuffer(rs.getInt("id"), rs.getString("player_uuid"), rs.getString("itemid"), rs.getString("ordertype"), rs.getInt("amount"), rs.getDouble("price"), rs.getLong("timestamp"));
                ++row_counter;
            }
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
        }
        return buffer;
    }

    private static Connection connect() {
        String url = "jdbc:sqlite:./plugins/Itemex/itemex.db";
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    public static OrderBuffer[] selectAllold(String table) {
        OrderBuffer[] buffer = new OrderBuffer[MAX_BUFFER];
        String sql = null;
        if (table.equals("SELLORDERS")) {
            sql = "SELECT * FROM SELLORDERS ORDER by itemid ASC, price";
        } else if (table.equals("BUYORDERS")) {
            sql = "SELECT * FROM BUYORDERS ORDER by itemid ASC, price DESC";
        }
        try (Connection conn = sqliteDb.connect();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            int row_counter = 0;
            while (rs.next()) {
                buffer[row_counter] = new OrderBuffer(rs.getInt("id"), rs.getString("player_uuid"), rs.getString("itemid"), rs.getString("ordertype"), rs.getInt("amount"), rs.getDouble("price"), rs.getLong("timestamp"));
                ++row_counter;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return buffer;
    }

    public static ArrayList<OrderBuffer> selectAll(String table, String itemid) {
        ArrayList<OrderBuffer> buffer = new ArrayList<OrderBuffer>();
        String sql = null;
        if (table.equals("SELLORDERS")) {
            sql = "SELECT * FROM SELLORDERS WHERE itemid = '" + itemid + "' ORDER by price ASC";
        } else if (table.equals("BUYORDERS")) {
            sql = "SELECT * FROM BUYORDERS WHERE itemid = '" + itemid + "' ORDER by price DESC";
        }
        try (Connection conn = sqliteDb.connect();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                buffer.add(new OrderBuffer(rs.getInt("id"), rs.getString("player_uuid"), rs.getString("itemid"), rs.getString("ordertype"), rs.getInt("amount"), rs.getDouble("price"), rs.getLong("timestamp")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return buffer;
    }

    public static boolean updateOrder(String table_name, int ID, int amount, double price, String ordertype, String itemid) {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "UPDATE " + table_name + " SET ordertype = '" + ordertype + "',  amount = " + amount + ", price = " + price + " WHERE id = " + ID;
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        sqliteDb.loadBestOrdersToRam(itemid, false);
        return true;
    }

    public static boolean fulfillOrder(String itemid) {
        ArrayList<OrderBuffer> sellorders = sqliteDb.selectAll("SELLORDERS", itemid);
        ArrayList<OrderBuffer> buyorders = sqliteDb.selectAll("BUYORDERS", itemid);
        for (OrderBuffer se : sellorders) {
            for (OrderBuffer be : buyorders) {
                if (!(be.price >= se.price) || be.amount == 0 || se.amount == 0) continue;
                System.out.println("MATCH AT: be: " + be.id + " [" + be.amount + "] + se: " + se.id + "[" + se.amount + "]");
                String[] buy_limit_or_market = be.ordertype.split(":", 2);
                String[] sell_limit_or_market = se.ordertype.split(":", 2);
                if (sell_limit_or_market[1].equals("market")) {
                    se.price = be.price;
                }
                if (buy_limit_or_market[1].equals("market")) {
                    be.price = se.price;
                }
                if (Itemex.admin_function && (sell_limit_or_market[1].equals("admin") || buy_limit_or_market[1].equals("admin"))) {
                    if (sell_limit_or_market[1].equals("admin")) {
                        System.out.println("Sellorder = admin" + se.id + " " + se.amount + " " + se.price);
                    }
                    if (!buy_limit_or_market[1].equals("admin")) continue;
                    System.out.println("Buyorder = admin" + be.id + " " + be.amount + " " + be.price);
                    continue;
                }
                if (!(se.price <= be.price) || se.amount == 0 || be.amount == 0) continue;
                if (se.amount < be.amount) {
                    if (sqliteDb.withdraw(se.uuid, be.uuid, se.itemid, se.amount, se.price)) {
                        be.amount -= se.amount;
                        if (be.ordertype.equals("buy:market")) {
                            sqliteDb.updateOrder("BUYORDERS", be.id, be.amount, Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0], be.ordertype, itemid);
                        } else {
                            sqliteDb.updateOrder("BUYORDERS", be.id, be.amount, be.price, be.ordertype, itemid);
                        }
                        se.amount = 0;
                        sqliteDb.closeOrder("SELLORDERS", se.id, itemid);
                        continue;
                    }
                    be.amount = 0;
                    sqliteDb.closeOrder("BUYORDERS", be.id, itemid);
                    continue;
                }
                if (se.amount > be.amount) {
                    if (sqliteDb.withdraw(se.uuid, be.uuid, se.itemid, be.amount, se.price)) {
                        se.amount -= be.amount;
                        if (be.ordertype.equals("sell:market")) {
                            sqliteDb.updateOrder("SELLORDERS", se.id, se.amount, Itemex.getPlugin().mtop.get(itemid).get_top_buyorder_prices()[3], se.ordertype, itemid);
                        } else {
                            sqliteDb.updateOrder("SELLORDERS", se.id, se.amount, se.price, se.ordertype, itemid);
                        }
                        be.amount = 0;
                        sqliteDb.closeOrder("BUYORDERS", be.id, itemid);
                        continue;
                    }
                    be.amount = 0;
                    sqliteDb.closeOrder("BUYORDERS", be.id, itemid);
                    continue;
                }
                if (se.amount != be.amount) continue;
                if (sqliteDb.withdraw(se.uuid, be.uuid, se.itemid, be.amount, se.price)) {
                    be.amount = 0;
                    sqliteDb.closeOrder("BUYORDERS", be.id, itemid);
                    se.amount = 0;
                    sqliteDb.closeOrder("SELLORDERS", se.id, itemid);
                    continue;
                }
                be.amount = 0;
                sqliteDb.closeOrder("BUYORDERS", be.id, itemid);
            }
        }
        return false;
    }

    public static boolean withdraw(String seller_uuid, String buyer_uuid, String itemid, int amount, double price) {
        System.out.println("# DEBUG: AT WITHDRAW");
        OfflinePlayer o_seller = Bukkit.getOfflinePlayer((UUID)UUID.fromString(seller_uuid));
        OfflinePlayer o_buyer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(buyer_uuid));
        Player seller = Bukkit.getPlayer((UUID)UUID.fromString(seller_uuid));
        Player buyer = Bukkit.getPlayer((UUID)UUID.fromString(buyer_uuid));
        double sub_total = price * (double)amount;
        double buyer_total = sub_total + sub_total / 100.0 * Itemex.broker_fee_buyer;
        double seller_total = sub_total - sub_total / 100.0 * Itemex.broker_fee_seller;
        double buyer_balance = Itemex.econ.getBalance(o_buyer);
        if (buyer_total < buyer_balance) {
            Itemex.econ.withdrawPlayer(o_buyer, buyer_total);
            Itemex.econ.depositPlayer(o_seller, seller_total);
            String seller_total_string = String.format("%.02f", seller_total);
            String buyer_total_string = String.format("%.02f", buyer_total);
            sqliteDb.insertFullfilledOrders(seller_uuid, buyer_uuid, itemid, amount, price);
            if (seller_uuid.equals(buyer_uuid)) {
                if (seller != null) {
                    seller.sendMessage("SELLORDER CLOSED SUCESSFULLY");
                    TextComponent message = new TextComponent("\n.\n.\n.\n.\n.\n.\n.\n" + ChatColor.BLUE + ChatColor.MAGIC + "X" + ChatColor.BLUE + "-> (" + ChatColor.GOLD + "CLICK HERE" + ChatColor.BLUE + ") You can withdraw with: /ix withdraw " + itemid + " " + amount);
                    message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ix withdraw " + itemid + " " + amount));
                    buyer.spigot().sendMessage((BaseComponent)message);
                }
                sqliteDb.insertPayout(seller_uuid, itemid, amount);
                return true;
            }
            if (seller == null) {
                System.out.println("--DEBUG: SELLER IS OFFLINE!");
                sqliteDb.insertPayout(seller_uuid, itemid, amount);
            } else {
                seller.sendMessage("SELL ORDER" + ChatColor.GREEN + " FULFILLED!" + ChatColor.WHITE + " You sold [" + amount + "] " + itemid + " for" + ChatColor.GREEN + " " + ItemexCommand.format_price(seller_total));
            }
            if (buyer == null) {
                System.out.println("--DEBUG: BUYER IS OFFLINE!");
                sqliteDb.insertPayout(buyer_uuid, itemid, amount);
            } else {
                sqliteDb.insertPayout(buyer_uuid, itemid, amount);
                buyer.sendMessage("BUY ORDER" + ChatColor.GREEN + " FULFILLED!" + ChatColor.WHITE + " You got [" + amount + "] " + itemid + " for" + ChatColor.RED + " " + ItemexCommand.format_price(buyer_total));
                TextComponent message = new TextComponent("\n.\n.\n.\n.\n.\n.\n.\n" + ChatColor.BLUE + ChatColor.MAGIC + "X" + ChatColor.BLUE + "-> (" + ChatColor.GOLD + "CLICK HERE" + ChatColor.BLUE + ") You can withdraw with: /ix withdraw " + itemid + " " + amount);
                message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ix withdraw " + itemid + " " + amount));
                buyer.spigot().sendMessage((BaseComponent)message);
            }
            return true;
        }
        buyer.sendMessage(ChatColor.RED + "NOT ENOUGH MONEY!" + ChatColor.WHITE + " You got need " + ChatColor.GREEN + ItemexCommand.format_price(buyer_total) + ChatColor.WHITE + " but you only have " + ChatColor.RED + " " + ItemexCommand.format_price(buyer_balance));
        return false;
    }

    public static boolean closeOrder(String table_name, int ID, String itemid) {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            String sql = "DELETE FROM " + table_name + " WHERE id = " + ID;
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        sqliteDb.loadBestOrdersToRam(itemid, false);
        return true;
    }

    public static boolean PlayercloseOrder(String player_uuid, String table_name, int ID) {
        String sql;
        Connection c = null;
        Statement stmt = null;
        int row_affected = 0;
        int refund_amount = 0;
        String refund_item_id = "";
        double refund_price = 0.0;
        String itemid = "";
        if (table_name.equals("SELLORDERS")) {
            try {
                Class.forName("org.sqlite.JDBC");
                c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
                stmt = c.createStatement();
                sql = "SELECT * FROM SELLORDERS WHERE id = '" + ID + "'";
                stmt.executeUpdate(sql);
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    refund_amount = rs.getInt("amount");
                    refund_item_id = rs.getString("itemid");
                    refund_price = rs.getDouble("price");
                    itemid = rs.getString("itemid");
                }
                System.out.println("REFUND AMOUNT: " + refund_amount);
                stmt.close();
            }
            catch (Exception e) {
                System.out.println("ERROR at getPayou()");
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                System.exit(0);
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:./plugins/Itemex/itemex.db");
            stmt = c.createStatement();
            sql = "DELETE FROM " + table_name + " WHERE id = " + ID + " AND player_uuid = '" + player_uuid + "'";
            row_affected = stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            System.exit(0);
            return false;
        }
        sqliteDb.loadBestOrdersToRam(itemid, true);
        if (row_affected == 1) {
            if (table_name.equals("SELLORDERS")) {
                if (refund_amount != 0) {
                    return sqliteDb.withdraw(player_uuid, player_uuid, refund_item_id, refund_amount, refund_price);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static class Payout {
        public String id;
        public int amount;
        public String itemid;

        Payout(String id, String itemid, int amount) {
            this.id = id;
            this.amount = amount;
            this.itemid = itemid;
        }
    }

    public static class OrderBuffer {
        public int id;
        public String uuid;
        public String itemid;
        public String ordertype;
        public int amount;
        public double price;
        public long timestamp;

        public OrderBuffer(int id, String uuid, String itemid, String ordertype, int amount, double price, long timestamp) {
            this.id = id;
            this.uuid = uuid;
            this.itemid = itemid;
            this.ordertype = ordertype;
            this.amount = amount;
            this.price = price;
            this.timestamp = timestamp;
        }
    }
}

