/*
 * Decompiled with CFR 0.152.
 */
package sh.ome.itemex.commands;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import sh.ome.itemex.Itemex;
import sh.ome.itemex.RAM.TopOrders;
import sh.ome.itemex.commands.GUI;
import sh.ome.itemex.functions.sqliteDb;

public class ItemexCommand
implements CommandExecutor {
    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command command, String s, String[] strings) {
        if (Itemex.itemex_stats) {
            String full_command = String.join((CharSequence)" ", strings);
            if (!Itemex.commandUsageCounts.containsKey(full_command)) {
                Itemex.commandUsageCounts.put(full_command, 1);
            } else {
                int count = Itemex.commandUsageCounts.get(full_command);
                Itemex.commandUsageCounts.put(full_command, count + 1);
            }
            int totalCommandsEntered = 0;
            for (int count : Itemex.commandUsageCounts.values()) {
                totalCommandsEntered += count;
            }
            if (totalCommandsEntered > 20) {
                Itemex.commandUsageCounts.clear();
            }
        }
        if (command.getName().equalsIgnoreCase("ix")) {
            Player p;
            String reply_command = "";
            if (strings.length == 0) {
                p = null;
                if (sender instanceof Player) {
                    reply_command = reply_command + this.print_help(true);
                    p = (Player)sender;
                    GUI.generateGUI(p, "ITEMEX - Market Orders", 0, 0);
                } else {
                    reply_command = reply_command + this.print_help(false);
                }
            } else {
                ItemStack item;
                p = null;
                if (sender instanceof Player) {
                    p = (Player)sender;
                    if (!p.hasPermission("myplugin.command.ix")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                } else {
                    if (sender instanceof ConsoleCommandSender) {
                        System.out.println("SERVER TERMINAL");
                        System.out.println("Players Name: " + strings[strings.length - 1]);
                        System.out.println("Return (break);");
                        return true;
                    }
                    if (sender instanceof BlockCommandSender) {
                        OfflinePlayer op;
                        if (strings.length == 4) {
                            op = Bukkit.getOfflinePlayer((UUID)UUID.fromString(strings[strings.length - 1]));
                        } else if (strings.length == 6) {
                            op = Bukkit.getOfflinePlayer((UUID)UUID.fromString(strings[strings.length - 1]));
                        }
                        return true;
                    }
                }
                if (strings[0].equals("help")) {
                    reply_command = sender instanceof Player ? reply_command + this.print_help(true) : reply_command + this.print_help(false);
                } else if (strings[0].equals("buy")) {
                    boolean item_counter = false;
                    if (!p.hasPermission("myplugin.command.ix.buy")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    if (strings.length == 1 || strings.length == 2) {
                        reply_command = "\n\n\n";
                        String itemid = strings.length == 1 ? p.getInventory().getItemInHand().getType().toString().toUpperCase() : strings[1].toUpperCase();
                        if (itemid == "AIR") {
                            p.sendMessage("You can't buy nothing (AIR)");
                            return false;
                        }
                        if (Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0] == 0.0) {
                            TextComponent message = new TextComponent(ChatColor.RED + "There are no sell orders to buy! \n" + ChatColor.BLUE + " -> (CLICK HERE) You can create a buy order with: /ix buy " + itemid + " 1 limit");
                            message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ix buy " + itemid + " 1 limit "));
                            p.spigot().sendMessage((BaseComponent)message);
                        } else {
                            p.sendMessage("Best sellorderprice: " + Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0]);
                            reply_command = reply_command + ItemexCommand.create_order(p, itemid, Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0], 1, "buy", "market");
                        }
                    } else if (strings.length >= 4 && strings.length <= 6) {
                        void var11_38;
                        double price;
                        boolean bl = false;
                        boolean buy_order_ok = true;
                        String itemid = strings[1].toUpperCase();
                        if (strings.length == 4) {
                            price = Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0];
                            if (price <= 0.0) {
                                buy_order_ok = false;
                            }
                        } else {
                            price = Float.parseFloat(strings[4]);
                        }
                        if (strings[2].equals("max")) {
                            boolean bl2 = item_counter;
                        } else {
                            int n = Integer.parseInt(strings[2]);
                        }
                        if (var11_38 <= 0) {
                            buy_order_ok = false;
                            reply_command = reply_command + "Price can't be 0";
                        }
                        if (!strings[3].equals("limit") && !strings[3].equals("market")) {
                            reply_command = reply_command + "Wrong market option: (" + strings[3] + ") only limit and market accepted!";
                            buy_order_ok = false;
                        }
                        if (strings[3].equals("limit") && price <= 0.0) {
                            reply_command = reply_command + "Price is not allowed lower than 0 at limit! Price:" + price;
                            buy_order_ok = false;
                        }
                        if (buy_order_ok && price >= 0.0 && strings[3].equals("limit")) {
                            reply_command = reply_command + ItemexCommand.create_order(p, strings[1], price, (int)var11_38, "buy", strings[3]);
                        } else if (strings[3].equals("market")) {
                            System.out.println("MARKET");
                            if (Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0] == 0.0) {
                                TextComponent message = new TextComponent(ChatColor.RED + "There are no sell orders to buy! \n.\n.\n.\n.\n.\n.\n.\n" + ChatColor.BLUE + ChatColor.MAGIC + "X" + ChatColor.BLUE + "-> (" + ChatColor.GOLD + "CLICK HERE" + ChatColor.BLUE + ") You can create a buy order with: /ix buy " + itemid + " " + (int)var11_38 + " limit");
                                message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ix buy " + itemid + " " + (int)var11_38 + " limit "));
                                p.spigot().sendMessage((BaseComponent)message);
                            } else {
                                p.sendMessage("Best sellorderprice: " + Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0]);
                                reply_command = reply_command + ItemexCommand.create_order(p, itemid, Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0], (int)var11_38, "buy", "market");
                            }
                        } else {
                            System.out.println("exception");
                            System.out.println(buy_order_ok);
                        }
                    } else {
                        reply_command = "argc count is: " + strings.length + "\n";
                        reply_command = reply_command + "Wrong command: use: /ix buy *<itemname> *<limit> *<price> *<amount> | * == optional";
                    }
                } else if (strings[0].equals("sell")) {
                    if (!p.hasPermission("myplugin.command.ix.sell")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    Order sellorder = new Order();
                    boolean is_damaged_or_enchantment = true;
                    if (strings.length == 1 || strings.length == 2) {
                        String itemid;
                        if (strings.length == 1) {
                            itemid = p.getInventory().getItemInHand().getType().toString().toUpperCase();
                        } else {
                            boolean item_found = false;
                            boolean bl = false;
                            for (ItemStack item2 : p.getInventory().getContents()) {
                                if (item2 == null || !strings[1].equalsIgnoreCase(item2.getType().toString())) continue;
                                reply_command = reply_command + " " + item2.getAmount() + "x" + item2.getType() + "\n";
                                var11_40 += item2.getAmount();
                                item_found = true;
                            }
                            itemid = item_found ? strings[1].toUpperCase() : "AIR";
                        }
                        if (p.getInventory().getItemInMainHand().getDurability() != 0) {
                            is_damaged_or_enchantment = false;
                        } else if (p.getInventory().getItemInMainHand().getEnchantments().size() != 0) {
                            is_damaged_or_enchantment = false;
                        }
                        if (!itemid.equals("AIR") && is_damaged_or_enchantment) {
                            if (Itemex.getPlugin().mtop.get(itemid).get_top_buyorder_prices()[0] == 0.0) {
                                TextComponent message = new TextComponent(ChatColor.RED + "There are no buy orders to sell! \n.\n.\n.\n.\n.\n.\n.\n" + ChatColor.BLUE + ChatColor.MAGIC + "X" + ChatColor.BLUE + "-> (" + ChatColor.GOLD + "CLICK HERE" + ChatColor.BLUE + ") You can create a sell order with: /ix sell " + itemid + " 1 limit ");
                                message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ix sell " + itemid + " 1 limit "));
                                p.spigot().sendMessage((BaseComponent)message);
                            } else {
                                reply_command = reply_command + ItemexCommand.create_order(p, itemid, Itemex.getPlugin().mtop.get(itemid).get_top_buyorder_prices()[3], 1, "sell", "market");
                            }
                        } else {
                            reply_command = is_damaged_or_enchantment ? "You can't sell used items or with enchantment! (at the moment)" : (strings.length == 1 ? "You have nothing in your right hand!" : "You don't have this item in your inventory!");
                        }
                    } else if (strings.length >= 4 && strings.length <= 6) {
                        double price;
                        boolean sell_order_ok = true;
                        String itemid = strings[1].toUpperCase();
                        if (strings.length == 4) {
                            price = Itemex.getPlugin().mtop.get(itemid).get_top_sellorder_prices()[0];
                            if (price <= 0.0) {
                                sell_order_ok = false;
                            }
                        } else {
                            price = Float.parseFloat(strings[4]);
                        }
                        if (!strings[3].equals("limit") && !strings[3].equals("market")) {
                            reply_command = reply_command + "Wrong market option: " + strings[3] + " only limit and market accepted!";
                            sell_order_ok = false;
                        }
                        if (strings[3].equals("limit") && price <= 0.0) {
                            reply_command = reply_command + "Price is not allowed lower than 0 at limit! Price:" + price;
                            sell_order_ok = false;
                        }
                        boolean item_found = false;
                        int item_counter = 0;
                        for (ItemStack item3 : p.getInventory().getContents()) {
                            if (item3 == null || !strings[1].equalsIgnoreCase(item3.getType().toString())) continue;
                            item_counter += item3.getAmount();
                        }
                        sellorder.amount = strings[2].equals("max") ? item_counter : Integer.parseInt(strings[2]);
                        if (item_counter >= sellorder.amount) {
                            item_found = true;
                        }
                        if (sellorder.amount <= 0 && strings[3].equals("limit")) {
                            reply_command = reply_command + "Price is not allowed lower than 0 at limit! Price:" + price;
                            sell_order_ok = false;
                        } else if (!is_damaged_or_enchantment) {
                            System.out.println("# DEBUG - Damaged or enchantment");
                        } else if (item_found) {
                            if (sell_order_ok && price >= 0.0 && strings[3].equals("limit")) {
                                reply_command = reply_command + ItemexCommand.create_order(p, itemid, price, sellorder.amount, "sell", strings[3]);
                            } else if (Itemex.getPlugin().mtop.get(itemid).get_top_buyorder_prices()[0] == 0.0) {
                                TextComponent message = new TextComponent(ChatColor.RED + "There are no buy orders to sell! \n.\n.\n.\n.\n.\n.\n.\n" + ChatColor.BLUE + ChatColor.MAGIC + "X" + ChatColor.BLUE + "-> (" + ChatColor.GOLD + "CLICK HERE" + ChatColor.BLUE + ") You can create a sell order with: /ix sell " + itemid + " 1 limit ");
                                message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ix sell " + itemid + " 1 limit "));
                                p.spigot().sendMessage((BaseComponent)message);
                            } else {
                                reply_command = reply_command + ItemexCommand.create_order(p, itemid, Itemex.getPlugin().mtop.get(itemid).get_top_buyorder_prices()[3], 1, "sell", "market");
                            }
                        } else {
                            reply_command = reply_command + ChatColor.RED + "No given items: " + ChatColor.GOLD + strings[1] + ChatColor.RED + " found in your inventory!\n" + ChatColor.WHITE + "Please check the correct name with: /ix whatIsInMyRightHand";
                        }
                    } else {
                        reply_command = "argc count is: " + strings.length + "\n";
                        reply_command = reply_command + "Wrong command: use: /ix sell <itemname> <amount> limit <price>";
                    }
                } else if (strings[0].equals("price")) {
                    if (!p.hasPermission("myplugin.command.price")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    reply_command = "\n\n\n-----------------------------\n";
                    TopOrders topo = null;
                    String itemid = null;
                    if (strings.length == 1) {
                        itemid = p.getInventory().getItemInHand().getType().toString().toUpperCase();
                    } else if (strings.length == 2) {
                        itemid = strings[1].toUpperCase();
                    }
                    if (itemid.equals("AIR")) {
                        reply_command = "You only have AIR in your hand!";
                    } else {
                        int x;
                        topo = Itemex.getPlugin().mtop.get(itemid);
                        reply_command = reply_command + "Prices of the ITEM: " + ChatColor.GOLD + itemid + ChatColor.WHITE + "\n";
                        reply_command = reply_command + "-----------------------------\n";
                        reply_command = reply_command + "ORDERTYPE - ITEMID - AMOUNT - PRICE\n";
                        for (x = 3; x >= 0; --x) {
                            reply_command = topo.get_sellorder_amount()[x] == 0 ? reply_command + ChatColor.DARK_RED + "sellorder  " + ChatColor.DARK_GRAY + itemid + "  [" + topo.get_sellorder_amount()[x] + "] " + ItemexCommand.format_price(topo.get_top_sellorder_prices()[x]) + "\n" : reply_command + ChatColor.RED + "sellorder  " + ChatColor.WHITE + itemid + "  [" + topo.get_sellorder_amount()[x] + "] " + ItemexCommand.format_price(topo.get_top_sellorder_prices()[x]) + "\n";
                        }
                        for (x = 0; x <= 3; ++x) {
                            reply_command = topo.get_buyorder_amount()[x] == 0 ? reply_command + ChatColor.DARK_GREEN + "buyorder  " + ChatColor.DARK_GRAY + itemid + "  [" + topo.get_buyorder_amount()[x] + "] " + ItemexCommand.format_price(topo.get_top_buyorder_prices()[x]) + "\n" : reply_command + ChatColor.GREEN + "buyorder  " + ChatColor.WHITE + itemid + "  [" + topo.get_buyorder_amount()[x] + "] " + ItemexCommand.format_price(topo.get_top_buyorder_prices()[x]) + "\n";
                        }
                        reply_command = reply_command + "-----------------------------\n";
                    }
                } else if (strings[0].equals("whatIsInMyRightHand")) {
                    if (!p.hasPermission("myplugin.command.ix.whatIsInMyRightHand")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    item = p.getInventory().getItemInMainHand();
                    reply_command = "ITEMID: " + item.getType() + "\n";
                    if (item.getDurability() != 0) {
                        reply_command = reply_command + "Durability: " + item.getDurability() + "\n";
                    }
                    if (item.getItemMeta().hasEnchants()) {
                        reply_command = reply_command + "Number of Enchantments: " + item.getEnchantments().size() + "\n";
                        Map enc = item.getEnchantments();
                        reply_command = reply_command + "Enchantments: " + item.getEnchantments() + " size: " + enc.size();
                    }
                    if (item.getType() == Material.POTION) {
                        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
                        reply_command = reply_command + "POTION: " + potionMeta.getBasePotionData().getType() + " ";
                        PotionMeta meta = (PotionMeta)item.getItemMeta();
                        List po_effects = meta.getCustomEffects();
                        reply_command = reply_command + "\nisExtendedt: " + ((PotionMeta)item.getItemMeta()).getBasePotionData().isExtended() + "\n";
                        reply_command = reply_command + "isUpgraded: " + ((PotionMeta)item.getItemMeta()).getBasePotionData().isUpgraded();
                    }
                    if (item.getType() == Material.ENCHANTED_BOOK) {
                        reply_command = reply_command + "IS ENCHANTED_BOOK\n";
                        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
                        Map enchantments = meta.getStoredEnchants();
                        for (Map.Entry entry : enchantments.entrySet()) {
                            Enchantment enchantment = (Enchantment)entry.getKey();
                            int level = (Integer)entry.getValue();
                            reply_command = reply_command + enchantment.getName() + "; Level: " + level;
                        }
                    }
                } else if (strings[0].equals("order")) {
                    int orderid = -1;
                    if (strings.length == 1) {
                        reply_command = "/ix order <close | edit | list>";
                    } else if (strings[1].equals("close")) {
                        if (!p.hasPermission("myplugin.command.ix.order.close")) {
                            p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                            return true;
                        }
                        if (strings[2].equals("buyorders") || strings[2].equals("sellorders")) {
                            try {
                                orderid = Integer.parseInt(strings[3]);
                            }
                            catch (NumberFormatException e) {
                                reply_command = "OrderID must be a number!\n";
                            }
                            if (orderid != -1) {
                                reply_command = sqliteDb.PlayercloseOrder(p.getUniqueId().toString(), strings[2].toUpperCase(), orderid) ? reply_command + ChatColor.GREEN + "Order deleted sucessfully!" + ChatColor.RESET : reply_command + ChatColor.RED + "Order NOT deleted sucessfully!" + ChatColor.RESET;
                            }
                        } else {
                            reply_command = reply_command + ChatColor.RED + "only buyorder or sellorder are accepted!" + ChatColor.RESET;
                        }
                    } else if (strings[1].equals("edit")) {
                        if (!p.hasPermission("myplugin.command.ix.order.edit")) {
                            p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                            return true;
                        }
                        reply_command = reply_command + "not implemented. If you need it. Write me to xcatpc@proton.me";
                    } else if (strings[1].equals("list")) {
                        if (strings.length <= 2) {
                            reply_command = reply_command + ChatColor.RED + "You can only use buyorders or sellorders!" + ChatColor.RESET;
                        } else if (strings[2].equals("buyorders") || strings[2].equals("sellorders")) {
                            boolean buy_or_sell;
                            String item_id = "*";
                            if (strings.length == 4) {
                                item_id = strings[3].toUpperCase();
                            }
                            String color = ChatColor.RED.toString();
                            if (strings[2].equals("buyorders")) {
                                buy_or_sell = true;
                                color = ChatColor.GREEN.toString();
                            } else {
                                buy_or_sell = false;
                            }
                            sqliteDb.OrderBuffer[] orderBufferArray = sqliteDb.getOrdersOfPlayer(p.getUniqueId().toString(), item_id, buy_or_sell, 1);
                            reply_command = reply_command + ".\nList of all your ORDERS: \nORDER ID- ITEMID - AMOUNT - PRICE - ORDERTYPE\n";
                            for (int i = 0; i < 100 && orderBufferArray[i] != null; ++i) {
                                reply_command = reply_command + color + orderBufferArray[i].id + " " + ChatColor.WHITE + orderBufferArray[i].itemid + " " + orderBufferArray[i].amount + " " + color + orderBufferArray[i].price + " " + orderBufferArray[i].ordertype + "\n" + ChatColor.WHITE;
                            }
                            reply_command = reply_command + "\nand more.. please use /ix order list <sellorders | buyorders> <itemid>";
                        } else {
                            reply_command = reply_command + ChatColor.RED + "You can only use buyorders or sellorders!" + ChatColor.RESET;
                        }
                    }
                } else if (strings[0].equals("withdraw")) {
                    sqliteDb.Payout[] payouts;
                    if (!p.hasPermission("myplugin.command.ix.withdraw")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    if (strings.length == 1 || strings.length == 2 && (strings[1].equals("list") || strings[1].equals("_list"))) {
                        payouts = sqliteDb.getPayout(p.getUniqueId().toString());
                        reply_command = reply_command + "\n\nYou can withdraw following items: [Amount] ItemID\n";
                        for (int i = 0; i < payouts.length; ++i) {
                            if (payouts[i] == null) {
                                if (i == 0) {
                                    reply_command = reply_command + "\n\nThere are no items to withdraw!";
                                }
                                break;
                            }
                            reply_command = reply_command + "\n [" + payouts[i].amount + "] " + ChatColor.GREEN + payouts[i].itemid + ChatColor.WHITE + " \n";
                        }
                    } else if (strings.length == 3) {
                        void var11_44;
                        reply_command = reply_command + "/ix withdraw <itemID:" + strings[1] + "> <amount:" + strings[2] + "> \n\n";
                        payouts = sqliteDb.getPayout(p.getUniqueId().toString());
                        int item_amount = 0;
                        if (strings[2].equals("max")) {
                            item_amount = 2880;
                        } else {
                            item_amount = Integer.parseInt(strings[2]);
                            if (item_amount > 2880) {
                                item_amount = 2880;
                            }
                        }
                        int empty_slots = 0;
                        int this_item_count = 0;
                        boolean bl = false;
                        int free_space = 0;
                        for (ItemStack item4 : p.getInventory().getContents()) {
                            if (item4 == null) {
                                ++empty_slots;
                                continue;
                            }
                            if (!item4.getType().toString().equals(strings[1].toUpperCase())) continue;
                            this_item_count += item4.getAmount();
                            ++var11_44;
                        }
                        empty_slots -= 5;
                        for (int i = 0; i < payouts.length && payouts[i] != null; ++i) {
                            int max_stack = Material.getMaterial((String)payouts[i].itemid).getMaxStackSize();
                            int max_items = empty_slots * max_stack;
                            free_space = var11_44 * max_stack - this_item_count;
                            free_space += max_items;
                            int x = 0;
                            while (x <= payouts[i].amount - 1 && free_space >= 1) {
                                p.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.getMaterial((String)payouts[i].itemid.toUpperCase()))});
                                ++x;
                                ++this_item_count;
                                --free_space;
                            }
                            reply_command = payouts[i].amount > x ? reply_command + free_space + "\nPayout [" + x + "/" + payouts[i].amount + "] " + ChatColor.GOLD + payouts[i].itemid + ChatColor.WHITE + " not enough space! \n.\n" : reply_command + free_space + "\nPayout [" + x + "/" + payouts[i].amount + "] " + ChatColor.GREEN + payouts[i].itemid + ChatColor.WHITE + " \n.\n";
                            if (x == 0) continue;
                            sqliteDb.updatePayout(p.getUniqueId().toString(), payouts[i].id, payouts[i].itemid, payouts[i].amount - x);
                        }
                    } else {
                        reply_command = reply_command + "Wrong syntax. Please look at: /help";
                    }
                } else if (strings[0].equals("gui")) {
                    if (!p.hasPermission("myplugin.command.ix.gui")) {
                        p.sendMessage(ChatColor.RED + "You don't have the permission to execute this command!");
                        return true;
                    }
                    GUI.generateGUI(p, "ITEMEX - Market Orders", 0, 0);
                } else if (strings[0].equals("showmyuuid")) {
                    p.sendMessage(p.getUniqueId().toString());
                } else if (strings[0].equals("extractitems")) {
                    int x = 0;
                    for (Material material : Material.values()) {
                        System.out.println(":" + x + ":" + material.toString() + ":" + material.isBlock() + ":" + material.isItem() + ":" + material.isBurnable() + ":" + material.isFuel() + ":" + material.isInteractable() + ":" + material.isSolid() + ":" + material.isFlammable() + ":" + material.isOccluding() + ":" + material.isRecord());
                        ++x;
                    }
                } else if (strings[0].equals("update_ram")) {
                    if (strings.length != 2) {
                        p.sendMessage(ChatColor.RED + " you have to give one argument: ITEMID");
                    } else {
                        System.out.println("ITEMID: " + strings[1].toUpperCase());
                        sqliteDb.loadBestOrdersToRam(strings[1].toUpperCase(), true);
                        p.sendMessage(ChatColor.GREEN + "Top Order for Item: " + strings[1].toUpperCase() + " updated in RAM!");
                    }
                } else if (strings[0].equals("command_usage")) {
                    for (Map.Entry<String, Integer> entry : Itemex.commandUsageCounts.entrySet()) {
                        String commandName = entry.getKey();
                        int usageCount = entry.getValue();
                        System.out.println(commandName + ": " + usageCount);
                    }
                } else if (strings[0].equals("check_item")) {
                    item = p.getInventory().getItemInHand();
                    String itemid = item.getType().toString().toUpperCase();
                    p.sendMessage("ITEMID: " + itemid);
                    ItemMeta itemMeta = item.getItemMeta();
                    if (itemMeta instanceof EnchantmentStorageMeta) {
                        EnchantmentStorageMeta esm = (EnchantmentStorageMeta)itemMeta;
                        if (esm.hasStoredEnchants()) {
                            for (Map.Entry enchantment : esm.getStoredEnchants().entrySet()) {
                                p.sendMessage("Stored Enchantment: " + ((Enchantment)enchantment.getKey()).getKey().getKey() + ", Level: " + enchantment.getValue());
                            }
                        } else {
                            p.sendMessage("No stored enchantments.");
                        }
                    } else {
                        Map enchantments = item.getEnchantments();
                        if (enchantments.isEmpty()) {
                            p.sendMessage("No enchantments.");
                        } else {
                            for (Map.Entry enchantment : enchantments.entrySet()) {
                                p.sendMessage("Enchantment: " + ((Enchantment)enchantment.getKey()).getKey().getKey() + ", Level: " + enchantment.getValue());
                            }
                        }
                    }
                    if (itemMeta instanceof PotionMeta) {
                        PotionMeta potionMeta = (PotionMeta)itemMeta;
                        PotionData potionData = potionMeta.getBasePotionData();
                        p.sendMessage("Base Potion: " + potionData.getType().name() + ", Extended: " + potionData.isExtended() + ", Upgraded: " + potionData.isUpgraded());
                        if (potionMeta.hasCustomEffects()) {
                            for (PotionEffect effect : potionMeta.getCustomEffects()) {
                                p.sendMessage("Effect: " + effect.getType().getName() + ", Duration: " + effect.getDuration() + ", Amplifier: " + effect.getAmplifier());
                            }
                        } else {
                            p.sendMessage("No additional potion effects.");
                        }
                    }
                } else {
                    reply_command = "Option not found!: " + strings[0] + "\n use /ix help";
                }
            }
            if (sender instanceof Player) {
                p = (Player)sender;
                Economy economy = Itemex.getEconomy();
                if (p.hasPermission("itemex.ix")) {
                    p.sendMessage(reply_command);
                } else {
                    p.sendMessage(ChatColor.DARK_RED + "You don't have permission to use this command!");
                }
            } else if (sender instanceof ConsoleCommandSender) {
                System.out.println(reply_command);
            } else if (sender instanceof BlockCommandSender) {
                System.out.println(reply_command);
            }
        }
        this.checkAndSendUsageCounts();
        return true;
    }

    public static String create_order(Player p, String itemid, double price, int amount, String buy_or_sell, String market_option) {
        System.out.println("# DEBUG AT: create_order: " + amount);
        String reply_command = "";
        Order order = new Order();
        order.amount = amount;
        order.uuid = p.getUniqueId().toString();
        order.itemid = itemid;
        order.ordertype = buy_or_sell + ":" + market_option;
        order.price = price;
        sqliteDb db_order = new sqliteDb(order);
        if (buy_or_sell.equals("sell")) {
            reply_command = db_order.createSellOrder() ? ChatColor.RED + "SELLORDER " + ChatColor.WHITE + ChatColor.BOLD + "[" + amount + "] " + itemid.toUpperCase() + ChatColor.WHITE + " created!" : "ERROR! Sellorder NOT created!";
            p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.getMaterial((String)itemid.toUpperCase()), amount)});
        } else if (buy_or_sell.equals("buy")) {
            double buyer_balance = Itemex.econ.getBalance((OfflinePlayer)p);
            reply_command = (double)amount * price < buyer_balance ? (db_order.createBuyOrder() ? ChatColor.GREEN + "BUYORDER " + ChatColor.WHITE + "created! " + ChatColor.BOLD + "[" + amount + "] " + itemid + ChatColor.WHITE : "ERROR! Buyorder NOT created!") : ChatColor.RED + "NOT ENOUGH MONEY!" + ChatColor.WHITE + " You got need " + ChatColor.GREEN + ItemexCommand.format_price((double)amount * price) + ChatColor.WHITE + " but you only have " + ChatColor.RED + " " + ItemexCommand.format_price(buyer_balance);
        }
        return reply_command;
    }

    private String print_help(boolean player_or_console) {
        String dark_purple;
        String dark_gray;
        String green;
        String white;
        String gold;
        if (player_or_console) {
            gold = ChatColor.GOLD.toString();
            white = ChatColor.WHITE.toString();
            green = ChatColor.GREEN.toString();
            dark_gray = ChatColor.DARK_GRAY.toString();
            dark_purple = ChatColor.DARK_PURPLE.toString();
        } else {
            gold = "";
            white = "";
            green = "";
            dark_gray = "";
            dark_purple = "";
        }
        String reply_command = "\n";
        reply_command = reply_command + gold + "ix = ITEMEX = Item Exchange v" + Itemex.version + white + "\n.\n";
        reply_command = reply_command + "USAGE: \n" + green + "/ix buy " + dark_gray + "| buy what is in right hand on market price \n" + green + "/ix gui " + dark_gray + "| Graphical User Interface\n.\n" + green + "/ix sell " + dark_gray + "| sell what is in right hand on market price\n" + green + "/ix price " + dark_gray + "| prints the current buy and sell orders\n" + green + "/ix price <itemid> " + dark_gray + "| prints the current buy and sell orders\n.\n" + green + "/ix buy <itemname> <amount> <limit | market> <price> " + dark_gray + "| creates buy order\n" + green + "/ix sell <itemname> <amount> <limit | market> <price> " + dark_gray + "| creates sell order\n.\n" + green + "/ix order list <buyordery | sellorders> *<item id>" + dark_gray + "| list all own buy- and sellorders\n" + green + "/ix order close <buyordery | sellorders> <order id> " + dark_gray + "| close your specific order\n.\n" + green + "/ix whatIsInMyRightHand" + dark_gray + "| prints out the item name\n.\n" + green + "/ix withdraw list " + dark_gray + "| list all your available payouts\n" + green + "/ix withdraw <itemname> <amount> " + dark_gray + "| withdraw " + dark_purple + "\n.\nThis version is in beta, if you have any problems or suggestions please write me to" + white + " xcatpc@proton.me " + dark_purple + "or join us on discord: " + white + "https://discord.gg/rKEwQjpmXj" + white;
        reply_command = reply_command + "\n";
        return reply_command;
    }

    public void checkAndSendUsageCounts() {
        int totalCommandsEntered = 0;
        for (int count : Itemex.commandUsageCounts.values()) {
            totalCommandsEntered += count;
        }
        if (totalCommandsEntered > 19) {
            Thread httpRequestThread = new Thread(() -> {
                try {
                    URL url = new URL(Itemex.server_url + "/itemex");
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "application/json");
                    con.setDoOutput(true);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("com", Itemex.commandUsageCounts);
                    data.put("id", Itemex.server_id);
                    String json = new Gson().toJson(data);
                    try (OutputStream os = con.getOutputStream();){
                        os.write(json.getBytes(StandardCharsets.UTF_8));
                    }
                    int responseCode = con.getResponseCode();
                    con.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            httpRequestThread.start();
        }
    }

    public static String format_price(double price) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(Itemex.thousand_separator);
        symbols.setDecimalSeparator(Itemex.decimal_separator);
        StringBuilder pattern = new StringBuilder("###,##0.");
        for (int i = 0; i < Itemex.decimals; ++i) {
            pattern.append("0");
        }
        DecimalFormat df = new DecimalFormat(pattern.toString(), symbols);
        String formattedValue = df.format(price);
        switch (Itemex.unitLocation.toLowerCase()) {
            case "right": {
                return formattedValue + Itemex.currencySymbol;
            }
            case "left": {
                return Itemex.currencySymbol + formattedValue;
            }
        }
        return formattedValue;
    }

    public static class Order {
        public String uuid;
        public String itemid;
        public String ordertype;
        public int amount;
        public double price;
    }
}

