/*
 * Decompiled with CFR 0.152.
 */
package sh.ome.itemex;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import sh.ome.itemex.Listeners.PlayerJoin;
import sh.ome.itemex.RAM.TopOrders;
import sh.ome.itemex.commands.ItemexCommand;
import sh.ome.itemex.events.ClickGUI;
import sh.ome.itemex.events.SignShop;
import sh.ome.itemex.files.CategoryFile;
import sh.ome.itemex.functions.commandAutoComplete;
import sh.ome.itemex.functions.sqliteDb;
import sh.ome.itemex.shedule.Metrics;
import sh.ome.itemex.shedule.UpdateItemex;

public final class Itemex
extends JavaPlugin
implements Listener {
    FileConfiguration config = this.getConfig();
    private static Itemex plugin;
    public static Economy econ;
    public static String version;
    public static boolean admin_function;
    public static double admin_function_percentage;
    public static String currencySymbol;
    public static int decimals;
    public static char decimal_separator;
    public static char thousand_separator;
    public static String unitLocation;
    public static double broker_fee_buyer;
    public static double broker_fee_seller;
    public static boolean bstats;
    public static String server_id;
    public static boolean itemex_stats;
    public static String server_url;
    public Map<String, TopOrders> mtop = new HashMap<String, TopOrders>();
    public static HashMap<String, Integer> commandUsageCounts;

    public void onEnable() {
        Metrics metrics = new Metrics(this, 17928);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
        String ANSI_RESET = "\u001b[0m";
        String ANSI_BLACK = "\u001b[30m";
        String ANSI_RED = "\u001b[31m";
        String ANSI_GREEN = "\u001b[32m";
        String ANSI_YELLOW = "\u001b[33m";
        String ANSI_BLUE = "\u001b[34m";
        String ANSI_PURPLE = "\u001b[35m";
        String ANSI_CYAN = "\u001b[36m";
        String ANSI_WHITE = "\u001b[37m";
        this.getLogger().info("\n\n");
        this.getLogger().info(ANSI_CYAN + "  88" + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    ,d" + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    88" + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88  MM88MMM  ,adPPYba,  88,dPYba,,adPYba,  " + ANSI_BLUE + "  ,adPPYba,  8b,     ,d8" + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    88    a8P_____88  88P'   '88'    '8a " + ANSI_BLUE + " a8P_____88   `Y8, ,8P'" + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    88    8PP\"\"\"\"\"\"\"  88      88      88 " + ANSI_BLUE + " 8PP\"\"\"\"\"\"\"     )888(   " + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    88,   '8b,   ,aa  88      88      88  " + ANSI_BLUE + "\"8b,   ,aa   ,d8\" \"8b, " + ANSI_RESET);
        this.getLogger().info(ANSI_CYAN + "  88    \"Y888  `\"Ybbd8\"'  88      88      88 " + ANSI_BLUE + "  `\"Ybbd8\"'  8P'     `Y8  " + ANSI_RESET);
        this.getLogger().info("");
        this.getLogger().info(ANSI_YELLOW + "ITEMEX v" + version + " - Free Market Item Exchange Plugin loaded. Usage: /ix help" + ANSI_RESET);
        this.getLogger().info("\n\n");
        this.getCommand("ix").setExecutor((CommandExecutor)new ItemexCommand());
        this.getCommand("ix").setTabCompleter((TabCompleter)new commandAutoComplete());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickGUI(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SignShop(), (Plugin)this);
        if (!this.setupEconomy()) {
            this.getLogger().info("Disabled due to no Vault dependency found!");
            return;
        }
        this.config.options().copyDefaults(true);
        this.config.addDefault("id", (Object)Itemex.getAlphaNumericString(15));
        this.saveConfig();
        admin_function = this.config.getBoolean("admin_function");
        admin_function_percentage = this.config.getDouble("admin_function_percentage");
        broker_fee_buyer = this.config.getDouble("broker_fee_buyer");
        broker_fee_seller = this.config.getDouble("broker_fee_seller");
        bstats = this.config.getBoolean("bstats");
        server_id = this.config.getString("id");
        itemex_stats = this.config.getBoolean("itemex_stats");
        currencySymbol = this.config.getString("currencySymbol");
        decimals = this.config.getInt("decimals");
        decimal_separator = this.config.getString("decimal_separator").charAt(0);
        thousand_separator = this.config.getString("thousand_separator").charAt(0);
        unitLocation = this.config.getString("unitLocation");
        CategoryFile.setup();
        CategoryFile.init();
        CategoryFile.get().options().copyDefaults(true);
        CategoryFile.save();
        sqliteDb.createDBifNotExists();
        if (admin_function) {
            // empty if block
        }
        plugin = this;
        this.getLogger().info("Loading all BestOrders into RAM...");
        sqliteDb.loadAllBestOrdersToRam(false);
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
            try {
                new UpdateItemex(version);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.getLogger().info("Problem with Update Itemex Scheduler");
        }, 0L, 288000L);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("VAULT not found");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("VAULT rsp = null");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void onDisable() {
        if (itemex_stats) {
            this.checkAndSendUsageCounts();
        }
        this.getLogger().info("ITEMEX - Free Market Item Exchange Plugin unloaded");
    }

    public static Itemex getPlugin() {
        return plugin;
    }

    public void checkAndSendUsageCounts() {
        int totalCommandsEntered = 0;
        for (int count : commandUsageCounts.values()) {
            totalCommandsEntered += count;
        }
        Thread httpRequestThread = new Thread(() -> {
            try {
                URL url = new URL(server_url + "/itemex");
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("com", commandUsageCounts);
                data.put("id", server_id);
                String json = new Gson().toJson(data);
                try (OutputStream os = con.getOutputStream();){
                    os.write(json.getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = con.getResponseCode();
                con.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        httpRequestThread.start();
    }

    static String getAlphaNumericString(int n) {
        String AlphaNumericString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvxyz";
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int index = (int)((double)AlphaNumericString.length() * Math.random());
            sb.append(AlphaNumericString.charAt(index));
        }
        return sb.toString();
    }

    static {
        econ = null;
        version = "0.19.2";
        server_url = "https://ome.sh";
        commandUsageCounts = new HashMap();
    }
}

