/*
 * Decompiled with CFR 0.152.
 */
package me.clcondorcet.itemSorter.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.clcondorcet.itemSorter.Main;
import me.clcondorcet.itemSorter.config.Config;
import me.clcondorcet.itemSorter.config.Messages;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private HashMap<String, FileConfiguration> configs = new HashMap();
    public Config config;
    public Messages messages;

    public void loadConfigs() {
        this.configs.clear();
        Plugin plug = Main.getInstance();
        this.load(plug.getDataFolder(), "config.yml");
        this.config = new Config(this.getConfig("config.yml"), this.loadDirect(new File(Main.getInstance().getDataFolder(), "temp.yml"), "config.yml"));
        List<String> msgFiles = Arrays.asList("EN", "FR", "DE");
        boolean isOther = true;
        for (String st : msgFiles) {
            if (this.config.language.equalsIgnoreCase(st)) {
                isOther = false;
                this.loadMessage(new File(Main.getInstance().getDataFolder(), "translations"), "messages_" + st + ".yml", true);
                this.messages = new Messages(this.getConfig("messages_" + st + ".yml"), this.loadDirect(new File(Main.getInstance().getDataFolder(), "temp.yml"), "translations/messages_" + st + ".yml"));
                continue;
            }
            this.replace(new File(Main.getInstance().getDataFolder(), "translations"), "messages_" + st + ".yml", "translations/messages_" + st + ".yml");
        }
        if (isOther) {
            this.loadMessage(new File(Main.getInstance().getDataFolder(), "translations"), "messages_" + this.config.language.toUpperCase() + ".yml", false);
            this.messages = new Messages(this.getConfig("messages_" + this.config.language.toUpperCase() + ".yml"), this.loadDirect(new File(Main.getInstance().getDataFolder(), "temp.yml"), "translations/messages_EN.yml"));
            Main.log.info("Loading messages files from a non register language. If the file doesn't exist it will be copy from messages_EN.yml");
        }
        this.load(plug.getDataFolder(), "data.yml");
    }

    public void load(File parent, String fileName) {
        Plugin plug = Main.getInstance();
        try {
            File file;
            if (!plug.getDataFolder().exists()) {
                plug.getDataFolder().mkdir();
            }
            if (!(file = new File(parent, fileName)).exists()) {
                int len;
                InputStream in = plug.getResource(fileName);
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            this.configs.put(fileName, (FileConfiguration)config);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Main.getInstance().getLogger().severe("Disable due to configuration error ! check config.yml or delete the file.");
            plug.getPluginLoader().disablePlugin(plug);
        }
    }

    public FileConfiguration loadDirect(File file, String fileName) {
        Plugin plug = Main.getInstance();
        try {
            file.delete();
            if (!file.exists()) {
                int len;
                InputStream in = plug.getResource(fileName);
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            file.delete();
            return config;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void loadMessage(File parent, String fileName, boolean inRessource) {
        Plugin plug = Main.getInstance();
        try {
            File file;
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!(file = new File(parent, fileName)).exists()) {
                int len;
                InputStream in = null;
                in = inRessource ? plug.getResource("translations/" + fileName) : plug.getResource("translations/messages_EN.yml");
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            this.configs.put(fileName, (FileConfiguration)config);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Main.getInstance().getLogger().severe("Disable due to configuration error ! check config.yml or delete the file.");
            plug.getPluginLoader().disablePlugin(plug);
        }
    }

    public void replace(File parent, String fileName, String ressource) {
        try {
            int len;
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = new File(parent, fileName);
            file.delete();
            InputStream in = Main.getInstance().getResource(ressource);
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FileConfiguration getConfig(String conf) {
        if (this.configs.containsKey(conf)) {
            return this.configs.get(conf);
        }
        this.load(Main.getInstance().getDataFolder(), conf);
        return this.configs.get(conf);
    }

    public void saveConfig(String config, File parent) {
        File file = new File(parent, config);
        try {
            this.getConfig(config).save(file);
        }
        catch (Exception e) {
            Main.getInstance().getLogger().severe("Error saving file");
            e.printStackTrace();
        }
    }

    public void createConfig(String config, File parent) {
        File file = new File(parent, config);
        YamlConfiguration config2 = YamlConfiguration.loadConfiguration((File)file);
        this.configs.put(config, (FileConfiguration)config2);
    }
}

