/*
 * Decompiled with CFR 0.152.
 */
package me.clcondorcet.itemSorter.Objects;

import java.util.ArrayList;
import java.util.HashMap;
import me.clcondorcet.itemSorter.Events.Event;
import me.clcondorcet.itemSorter.Main;
import me.clcondorcet.itemSorter.Objects.Deposit;
import me.clcondorcet.itemSorter.Objects.Filter;
import me.clcondorcet.itemSorter.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class System {
    public String name;
    public Location baseLoc;
    public Location sign;
    public String owner;
    public ArrayList<String> trusts;
    public ArrayList<Filter> filters;
    public ArrayList<Deposit> deposits;

    public System(String name, String baseLoc, String signLoc, String owner, ArrayList<String> trusts, ArrayList<Filter> filters, ArrayList<Deposit> deposits) {
        this.name = name;
        this.baseLoc = System.getLoc(baseLoc);
        this.sign = System.getLoc(signLoc);
        this.owner = owner;
        this.trusts = trusts;
        this.filters = filters;
        this.deposits = deposits;
    }

    public static Location getLoc(String st) {
        String[] sts = st.split(":");
        return new Location(Bukkit.getWorld((String)sts[0]), Double.parseDouble(sts[1]), Double.parseDouble(sts[2]), Double.parseDouble(sts[3]));
    }

    public static String getLoc(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    public void save() {
        FileConfiguration config = Main.configManager.getConfig("data.yml");
        config.set("data." + this.name, null);
        config.set("data." + this.name + ".baseLoc", (Object)System.getLoc(this.baseLoc));
        config.set("data." + this.name + ".sign", (Object)System.getLoc(this.sign));
        config.set("data." + this.name + ".owner", (Object)this.owner);
        config.set("data." + this.name + ".trusts", this.trusts);
        int i = 0;
        for (Filter filter : this.filters) {
            config.set("data." + this.name + ".filters." + String.valueOf(i) + ".isTrash", (Object)filter.isTrash);
            config.set("data." + this.name + ".filters." + String.valueOf(i) + ".TrashPriority", (Object)filter.trashPriority);
            config.set("data." + this.name + ".filters." + String.valueOf(i) + ".loc", (Object)System.getLoc(filter.loc));
            config.set("data." + this.name + ".filters." + String.valueOf(i) + ".sign", (Object)System.getLoc(filter.sign));
            ArrayList<String> sts = new ArrayList<String>();
            for (Material mat : filter.materials.keySet()) {
                sts.add(mat.toString() + ":" + filter.materials.get(mat));
            }
            config.set("data." + this.name + ".filters." + String.valueOf(i) + ".materials", sts);
            ++i;
        }
        i = 0;
        for (Deposit deposit : this.deposits) {
            config.set("data." + this.name + ".deposits." + String.valueOf(i) + ".loc", (Object)System.getLoc(deposit.loc));
            config.set("data." + this.name + ".deposits." + String.valueOf(i) + ".sign", (Object)System.getLoc(deposit.sign));
            ++i;
        }
        Main.configManager.saveConfig("data.yml", Main.getInstance().getDataFolder());
    }

    public void delete() {
        for (Filter filter : this.filters) {
            filter.delete();
        }
        for (Deposit deposit : this.deposits) {
            deposit.delete();
        }
        for (Player p : Event.autodeposits.keySet()) {
            if (!Event.autodeposits.get(p).equals(this)) continue;
            Event.autodeposits.remove(p);
        }
        for (Player p : Event.autofilters.keySet()) {
            if (!Event.autofilters.get(p).equals(this)) continue;
            Event.autofilters.remove(p);
        }
        FileConfiguration config = Main.configManager.getConfig("data.yml");
        config.set("data." + this.name, null);
        Main.configManager.saveConfig("data.yml", Main.getInstance().getDataFolder());
    }

    public boolean isTrust(Player p) {
        if (p.hasPermission("itemsorter.admin") || this.owner.equals(p.getName())) {
            return true;
        }
        for (String st : this.trusts) {
            if (!st.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public static int getNewPriority(ArrayList<Filter> filters, Material mat) {
        int max = 0;
        ArrayList<Integer> il = new ArrayList<Integer>();
        for (Filter filter : filters) {
            int x = filter.materials.getOrDefault(mat, 0);
            if (x > max) {
                max = x;
            }
            if (x == 0) continue;
            il.add(x);
        }
        int i = 0;
        if (max != 0) {
            for (i = 1; i <= max; ++i) {
                if (il.contains(i)) continue;
                return i;
            }
            return i;
        }
        return i + 1;
    }

    public static int getNewPriority(ArrayList<Filter> filters) {
        int max = 0;
        ArrayList<Integer> il = new ArrayList<Integer>();
        for (Filter filter : filters) {
            if (filter.isActive && filter.isTrash && filter.trashPriority > max) {
                max = filter.trashPriority;
            }
            if (!filter.isTrash || filter.trashPriority == 0) continue;
            il.add(filter.trashPriority);
        }
        int i = 0;
        if (max != 0) {
            for (i = 1; i <= max; ++i) {
                if (il.contains(i)) continue;
                return i;
            }
            return i;
        }
        return i + 1;
    }

    public ArrayList<ItemStack> addItems(ArrayList<ItemStack> items) {
        HashMap<Material, HashMap> cache = new HashMap<Material, HashMap>();
        HashMap<Object, Object> cacheTrash = new HashMap();
        boolean cacheSetup = false;
        ArrayList<ItemStack> returned = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            Filter fil;
            HashMap result;
            ArrayList resultcache;
            Material mat;
            ArrayList<Object> enter = new ArrayList<Object>();
            enter.add(item);
            HashMap filterMat = new HashMap();
            if (!cache.containsKey(item.getType())) {
                filterMat = this.getfilters(this, item.getType());
                cache.put(item.getType(), filterMat);
            } else {
                filterMat = (HashMap)cache.get(item.getType());
            }
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer i : filterMat.keySet()) {
                mat = ((Filter)filterMat.get((Object)i)).loc.getBlock().getType();
                if (Utilities.isDF(mat) && Utilities.isSign(((Filter)filterMat.get((Object)i)).sign.getBlock())) {
                    resultcache = new ArrayList();
                    for (ItemStack itemStack : enter) {
                        result = ((InventoryHolder)((Filter)filterMat.get((Object)i)).loc.getBlock().getState()).getInventory().addItem(new ItemStack[]{itemStack});
                        resultcache.addAll(result.values());
                    }
                    enter.clear();
                    enter.addAll(resultcache);
                    continue;
                }
                toRemove.add(i);
            }
            if (!toRemove.isEmpty()) {
                for (Integer i : toRemove) {
                    fil = (Filter)filterMat.get(i);
                    this.filters.remove(fil);
                    filterMat.remove(i);
                    fil.delete();
                }
                this.save();
            }
            toRemove.clear();
            if (enter.size() == 0) continue;
            if (!cacheSetup) {
                cacheTrash = this.getfilters(this);
                cacheSetup = true;
            }
            for (Integer i : cacheTrash.keySet()) {
                mat = ((Filter)cacheTrash.get((Object)i)).loc.getBlock().getType();
                if (Utilities.isDF(mat) && Utilities.isSign(((Filter)cacheTrash.get((Object)i)).sign.getBlock())) {
                    resultcache = new ArrayList();
                    for (ItemStack itemStack : enter) {
                        result = ((InventoryHolder)((Filter)cacheTrash.get((Object)i)).loc.getBlock().getState()).getInventory().addItem(new ItemStack[]{itemStack});
                        resultcache.addAll(result.values());
                    }
                    enter.clear();
                    enter.addAll(resultcache);
                    continue;
                }
                toRemove.add(i);
            }
            if (!toRemove.isEmpty()) {
                for (Integer i : toRemove) {
                    fil = (Filter)cacheTrash.get(i);
                    this.filters.remove(fil);
                    cacheTrash.remove(i);
                    fil.delete();
                }
                this.save();
            }
            toRemove.clear();
            if (enter.isEmpty()) continue;
            returned.addAll(enter);
        }
        return returned;
    }

    public HashMap<Integer, Filter> getfilters(System sys, Material mat) {
        HashMap<Integer, Filter> filters = new HashMap<Integer, Filter>();
        for (Filter filter : sys.filters) {
            if (!filter.materials.containsKey(mat)) continue;
            filters.put(filter.materials.get(mat), filter);
        }
        return filters;
    }

    public HashMap<Integer, Filter> getfilters(System sys) {
        HashMap<Integer, Filter> filters = new HashMap<Integer, Filter>();
        for (Filter filter : sys.filters) {
            if (!filter.isTrash) continue;
            filters.put(filter.trashPriority, filter);
        }
        return filters;
    }

    public Filter getFilterWithBlock(Block block) {
        for (Filter fil : this.filters) {
            if (!fil.loc.equals((Object)block.getLocation()) && !fil.sign.equals((Object)block.getLocation())) continue;
            return fil;
        }
        return null;
    }

    public Deposit getDepositWithBlock(Block block) {
        for (Deposit deposit : this.deposits) {
            if (!deposit.loc.equals((Object)block.getLocation()) && !deposit.sign.equals((Object)block.getLocation())) continue;
            return deposit;
        }
        return null;
    }
}

