/*
 * Decompiled with CFR 0.152.
 */
package me.clcondorcet.itemSorter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import me.clcondorcet.itemSorter.Commands.Commands;
import me.clcondorcet.itemSorter.Events.Event;
import me.clcondorcet.itemSorter.Events.GuiEvent;
import me.clcondorcet.itemSorter.Objects.CachedItems;
import me.clcondorcet.itemSorter.Objects.Deposit;
import me.clcondorcet.itemSorter.Objects.Filter;
import me.clcondorcet.itemSorter.Objects.System;
import me.clcondorcet.itemSorter.Utilities;
import me.clcondorcet.itemSorter.VersionChecker;
import me.clcondorcet.itemSorter.VersionHandler;
import me.clcondorcet.itemSorter.config.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Plugin plugin;
    public static Logger log;
    public static String prefix;
    public static ArrayList<System> bases;
    public static HashMap<String, ArrayList<String>> notLoadedBases;
    public static String version;
    public static VersionHandler versionHandler;
    public static VersionChecker versionChecker;
    public static CachedItems cachedItems;
    public static ConfigManager configManager;
    public static HashMap<Player, Object[]> inFilter;
    public static HashMap<Player, Object[]> inSystem;

    public static Plugin getInstance() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        log = this.getLogger();
        versionHandler = new VersionHandler();
        versionChecker = new VersionChecker();
        configManager = new ConfigManager();
        configManager.loadConfigs();
        prefix = Main.configManager.messages.msg_prefix.replaceAll("&", "\u00a7");
        this.loadEvents();
        this.loadCommands();
        Main.loadConfigs(null);
        cachedItems = new CachedItems();
    }

    public static void loadConfigs(CommandSender s) {
        bases.clear();
        FileConfiguration config = configManager.getConfig("data.yml");
        ArrayList<String> systems = new ArrayList<String>();
        try {
            for (String st : config.getConfigurationSection("data").getKeys(false)) {
                systems.add(st);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<System> toDelete = new ArrayList<System>();
        for (String st : systems) {
            try {
                System sys = Main.loadSysFromFile(config, st);
                if (sys.baseLoc.getBlock().getType() != Material.ENDER_CHEST || !versionHandler.isWallSign(sys.sign.getBlock())) {
                    toDelete.add(sys);
                    continue;
                }
                bases.add(sys);
            }
            catch (NullPointerException ex) {
                if (s != null) {
                    s.sendMessage(prefix + "\u00a74Error when loading the storage system \u00a76\"" + st + "\" \u00a74Please check the console !");
                    log.severe("Error when loading the storage system named " + st + " from data.yml !");
                    log.severe("Did you modify the data.yml file ? Or did you change the world name ?");
                    log.severe("The storage system will not be loaded but will not be removed from the file data.yml in order to fix it if you can.");
                    log.severe("Loading the next one now ...");
                    continue;
                }
                String worldName = config.getString("data." + st + ".baseLoc").split(":")[0];
                if (!notLoadedBases.containsKey(worldName)) {
                    notLoadedBases.put(worldName, new ArrayList());
                }
                notLoadedBases.get(worldName).add(st);
                log.warning("The system storage system named " + st + " gets an error when loading. We will wait until the world gets loaded...");
            }
            catch (Exception ex) {
                log.severe("This error may not occur please contact clcondorcet and sho him the this message and the error below:");
                ex.printStackTrace();
                Main.getInstance().getPluginLoader().disablePlugin(Main.getInstance());
                return;
            }
        }
        for (System sys : toDelete) {
            log.info("The base " + sys.name + " will be deleted because the base is not longer at the same location.");
            sys.delete();
        }
    }

    public static System loadSysFromFile(FileConfiguration config, String st) {
        String baseLoc = config.getString("data." + st + ".baseLoc");
        String sign = config.getString("data." + st + ".sign");
        String owner = config.getString("data." + st + ".owner");
        ArrayList<String> trusts = new ArrayList<String>();
        for (Object trust : config.getStringList("data." + st + ".trusts")) {
            trusts.add((String)trust);
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        try {
            for (String key : config.getConfigurationSection("data." + st + ".filters").getKeys(false)) {
                try {
                    Location containerLoc = System.getLoc(config.getString("data." + st + ".filters." + key + ".loc"));
                    Location signLoc = System.getLoc(config.getString("data." + st + ".filters." + key + ".sign"));
                    if (!Utilities.isDF(containerLoc.getBlock().getType()) || !Utilities.isSign(signLoc.getBlock())) continue;
                    if (config.getBoolean("data." + st + ".filters." + key + ".isTrash")) {
                        filters.add(new Filter(containerLoc, signLoc, config.getInt("data." + st + ".filters." + key + ".TrashPriority")));
                        continue;
                    }
                    filters.add(new Filter(containerLoc, signLoc, config.getStringList("data." + st + ".filters." + key + ".materials")));
                }
                catch (Exception containerLoc) {}
            }
        }
        catch (Exception trust) {
            // empty catch block
        }
        ArrayList<Deposit> deposits = new ArrayList<Deposit>();
        try {
            for (String key : config.getConfigurationSection("data." + st + ".deposits").getKeys(false)) {
                try {
                    Location containerLoc = System.getLoc(config.getString("data." + st + ".deposits." + key + ".loc"));
                    Location signLoc = System.getLoc(config.getString("data." + st + ".deposits." + key + ".sign"));
                    if (!Utilities.isDF(containerLoc.getBlock().getType()) || !Utilities.isSign(signLoc.getBlock())) continue;
                    deposits.add(new Deposit(containerLoc, signLoc));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new System(st, baseLoc, sign, owner, trusts, filters, deposits);
    }

    public void loadEvents() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new Event(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new GuiEvent(), (Plugin)this);
        versionHandler.newEvent((Plugin)this);
    }

    public void loadCommands() {
        PluginCommand command = this.getCommand("ItemSorter");
        command.setExecutor((CommandExecutor)new Commands());
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("iso");
        command.setAliases(aliases);
        command.setTabCompleter((TabCompleter)new Commands());
    }

    static {
        prefix = "\u00a76IS> ";
        bases = new ArrayList();
        notLoadedBases = new HashMap();
        inFilter = new HashMap();
        inSystem = new HashMap();
    }
}

