/*
 * Decompiled with CFR 0.152.
 */
package org.shelk.utils;

import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.shelk.ItemParticles;
import org.shelk.ParticleEffect;
import org.shelk.utils.XParticle;

public class MathParticles {
    public static void playCircle(Player p, Location loc, ParticleEffect pe, double radius, float rgb1, float rgb2, float rgb3) {
        int i = 0;
        while (i < 50) {
            double angle = Math.PI * 2 * (double)i / 50.0;
            Location point = loc.clone().add(radius * Math.sin(angle), 0.0, radius * Math.cos(angle));
            MathParticles.spawnParticle(p.getWorld(), pe, point, rgb1, rgb2, rgb3, p);
            ++i;
        }
    }

    public static float getRGB(int whichrgb, ParticleEffect pe) {
        float rgb;
        if (pe.getColor() == null) {
            return 0.0f;
        }
        int color = 0;
        if (whichrgb == 1) {
            color = pe.getColor().getRed();
        }
        if (whichrgb == 2) {
            color = pe.getColor().getGreen();
        }
        if (whichrgb == 3) {
            color = pe.getColor().getBlue();
        }
        if ((rgb = (float)((double)((float)color / 1000.0f) * 3.92)) == 0.0f && whichrgb == 1) {
            rgb = (float)((double)rgb + 0.001);
        }
        return rgb;
    }

    public static void spawnParticle(World world, ParticleEffect pe, Location point, float rgb1, float rgb2, float rgb3, Player p) {
        if (Bukkit.getVersion().contains("1.15") || Bukkit.getVersion().contains("1.14") || Bukkit.getVersion().contains("1.13")) {
            Color color = Color.RED;
            if (pe.getColor() != null) {
                color = pe.getColor();
            }
            Particle.DustOptions dustOptions = null;
            if (pe.getParticle() == XParticle.REDSTONE) {
                dustOptions = new Particle.DustOptions(color, 1.0f);
            }
            world.spawnParticle(Particle.valueOf((String)pe.getParticle().name()), point.getX(), point.getY(), point.getZ(), 0, 0.0, 0.0, 0.0, 1.0, (Object)dustOptions);
        } else if (!Bukkit.getVersion().contains("1.8") && !Bukkit.getVersion().contains("1.7")) {
            world.spawnParticle(Particle.valueOf((String)pe.getParticle().name()), point.getX(), point.getY(), point.getZ(), 0, (double)rgb1, (double)rgb2, (double)rgb3, 1.0);
        } else {
            if (pe.getParticle() == XParticle.REDSTONE) {
                org.inventivetalent.particle.ParticleEffect.valueOf((String)pe.getParticle().name()).sendColor(Bukkit.getOnlinePlayers(), point, pe.getColor());
                return;
            }
            org.inventivetalent.particle.ParticleEffect.valueOf((String)pe.getParticle().name()).send(Bukkit.getOnlinePlayers(), point.getX(), point.getY(), point.getZ(), 0.0, 0.0, 0.0, 0.01, 1);
        }
    }

    public static void spawnTornado(final Location loc, final ParticleEffect pe, final float rgb1, final float rgb2, final float rgb3, final Player p) {
        new BukkitRunnable(){
            int angle = 1;

            public void run() {
                int max_height = 3;
                double max_radius = 1.5;
                int lines = 4;
                double height_increasement = 0.2;
                double radius_increasement = max_radius / (double)max_height;
                int l = 0;
                while (l < lines) {
                    double y = 0.0;
                    while (y < (double)max_height) {
                        double radius = y * radius_increasement;
                        double x = Math.cos(Math.toRadians((double)(360 / lines * l) + y * 25.0 - (double)this.angle)) * radius;
                        double z = Math.sin(Math.toRadians((double)(360 / lines * l) + y * 25.0 - (double)this.angle)) * radius;
                        int i = 0;
                        while (i < 2) {
                            MathParticles.spawnParticle(loc.getWorld(), pe, loc.clone().add(x, y, z), rgb1, rgb2, rgb3, p);
                            ++i;
                        }
                        y += height_increasement;
                    }
                    ++l;
                }
                ++this.angle;
                if (this.angle == 10) {
                    this.cancel();
                }
            }
        }.runTaskTimer(ItemParticles.pl, 0L, 1L);
    }
}

