/*
 * Decompiled with CFR 0.152.
 */
package org.shelk.customsrunnables;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.shelk.ItemParticles;
import org.shelk.ParticleEffect;
import org.shelk.utils.MathParticles;

public class OtherParticlesRunnable
extends BukkitRunnable {
    public void run() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (ItemParticles.getParticleEffectItem(p) == null || ItemParticles.getParticleEffectItem(p).size() == 0) continue;
            for (ParticleEffect pe : ItemParticles.getParticleEffectItem(p)) {
                Location loc;
                float rgb1 = MathParticles.getRGB(1, pe);
                float rgb2 = MathParticles.getRGB(2, pe);
                float rgb3 = MathParticles.getRGB(3, pe);
                World world = p.getWorld();
                if (pe.getShape().equals("circle")) {
                    MathParticles.playCircle(p, p.getLocation(), pe, 2.0, rgb1, rgb2, rgb3);
                }
                if (pe.getShape().equals("sphere")) {
                    Location location = p.getLocation().add(0.0, 3.5, 0.0);
                    double i = 0.0;
                    while (i <= Math.PI) {
                        double radius = Math.sin(i);
                        double y = Math.cos(i);
                        double a = 0.0;
                        while (a < Math.PI * 2) {
                            double x = Math.cos(a) * radius;
                            double z = Math.sin(a) * radius;
                            location.add(x, y, z);
                            MathParticles.spawnParticle(world, pe, location, rgb1, rgb2, rgb3, p);
                            location.subtract(x, y, z);
                            a += 0.3141592653589793;
                        }
                        i += 0.5235987755982988;
                    }
                }
                if (pe.getShape().equals("disk")) {
                    double radius = 0.25;
                    int i = 0;
                    while (i < 8) {
                        MathParticles.playCircle(p, p.getLocation(), pe, radius, rgb1, rgb2, rgb3);
                        radius += 0.25;
                        ++i;
                    }
                }
                if (pe.getShape().equals("star")) {
                    loc = p.getLocation();
                    int iteration = 0;
                    while (iteration < 5) {
                        double angle = 72.0 * (double)iteration;
                        double nextAngle = 72.0 * (double)(iteration + 2);
                        angle = Math.toRadians(angle);
                        nextAngle = Math.toRadians(nextAngle);
                        double x = Math.cos(angle) * 3.5;
                        double z = Math.sin(angle) * 3.5;
                        double x2 = Math.cos(nextAngle) * 3.5;
                        double z2 = Math.sin(nextAngle) * 3.5;
                        double deltaX = x2 - x;
                        double deltaZ = z2 - z;
                        double distance = Math.sqrt((deltaX - x) * (deltaX - x) + (deltaZ - z) * (deltaZ - z)) * 0.11;
                        double d = 0.0;
                        while (d < distance - 0.1) {
                            loc.add(x + deltaX * d, 0.0, z + deltaZ * d);
                            MathParticles.spawnParticle(p.getWorld(), pe, loc, rgb1, rgb2, rgb3, p);
                            loc.subtract(x + deltaX * d, 0.0, z + deltaZ * d);
                            d += 0.02;
                        }
                        ++iteration;
                    }
                }
                if (pe.getShape().equals("star2")) {
                    double d;
                    double distance;
                    double deltaZ;
                    double deltaX;
                    double z2;
                    double x2;
                    double z;
                    double x;
                    double nextAngle;
                    double angle;
                    loc = p.getLocation();
                    int points = 3;
                    int iteration = 0;
                    while (iteration < points) {
                        angle = 360.0 / (double)points * (double)iteration;
                        nextAngle = 360.0 / (double)points * (double)(iteration + 1);
                        angle = Math.toRadians(angle);
                        nextAngle = Math.toRadians(nextAngle);
                        x = Math.cos(angle) * 3.0;
                        z = Math.sin(angle) * 3.0;
                        x2 = Math.cos(nextAngle) * 3.0;
                        z2 = Math.sin(nextAngle) * 3.0;
                        deltaX = x2 - x;
                        deltaZ = z2 - z;
                        distance = 1.15;
                        d = 0.0;
                        while (d < distance - 0.1) {
                            loc.add(x + deltaX * d, 0.1, z + deltaZ * d);
                            MathParticles.spawnParticle(p.getWorld(), pe, loc, rgb1, rgb2, rgb3, p);
                            loc.subtract(x + deltaX * d, 0.1, z + deltaZ * d);
                            d += 0.05;
                        }
                        ++iteration;
                    }
                    iteration = 0;
                    while (iteration < points) {
                        angle = 360.0 / (double)points * (double)iteration + 180.0;
                        nextAngle = 360.0 / (double)points * (double)(iteration + 1) + 180.0;
                        angle = Math.toRadians(angle);
                        nextAngle = Math.toRadians(nextAngle);
                        x = Math.cos(angle) * 3.0;
                        z = Math.sin(angle) * 3.0;
                        x2 = Math.cos(nextAngle) * 3.0;
                        z2 = Math.sin(nextAngle) * 3.0;
                        deltaX = x2 - x;
                        deltaZ = z2 - z;
                        distance = 1.15;
                        d = 0.0;
                        while (d < distance - 0.1) {
                            loc.add(x + deltaX * d, 0.1, z + deltaZ * d);
                            MathParticles.spawnParticle(p.getWorld(), pe, loc, rgb1, rgb2, rgb3, p);
                            loc.subtract(x + deltaX * d, 0.1, z + deltaZ * d);
                            d += 0.05;
                        }
                        ++iteration;
                    }
                }
                if (pe.getShape().equals("star3")) {
                    loc = p.getLocation();
                    int iteration = 0;
                    while (iteration < 8) {
                        double angle = 45.0 * (double)iteration;
                        angle = Math.toRadians(angle);
                        double x = Math.cos(angle) * 2.7;
                        double z = Math.sin(angle) * 2.7;
                        double deltaX = 0.0 - x;
                        double deltaZ = 0.0 - z;
                        double distance = 1.0;
                        double d = 0.0;
                        while (d < distance - 0.1) {
                            loc.add(x + deltaX * d, 0.0, z + deltaZ * d);
                            MathParticles.spawnParticle(p.getWorld(), pe, loc, rgb1, rgb2, rgb3, p);
                            loc.subtract(x + deltaX * d, 0.0, z + deltaZ * d);
                            d += 0.05;
                        }
                        ++iteration;
                    }
                }
                if (!pe.getShape().equals("tornado")) continue;
                MathParticles.spawnTornado(p.getLocation(), pe, rgb1, rgb2, rgb3, p);
            }
        }
    }
}

