/*
 * Decompiled with CFR 0.152.
 */
package org.shelk.commandhandler;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.shelk.ItemParticles;
import org.shelk.ParticleEffect;
import org.shelk.utils.XMaterial;

public class ItemParticlesHandler
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String arg2, String[] args) {
        if (cmd.getName().equalsIgnoreCase("itemparticles")) {
            Player p = (Player)sender;
            if (!p.hasPermission("itemparticles.modify")) {
                p.sendMessage("\u00a7cYou don't have the permission to do this command.");
                return false;
            }
            if (sender instanceof Player) {
                if (args.length == 0) {
                    ItemParticlesHandler.openPrincipalGui(p, 1);
                } else if (args.length == 1) {
                    if (args[0].equals("modifyamount")) {
                        p.sendMessage("\u00a7cIf you want to modify the amount of your particles, use the command \u00a7b/itemparticles modifyamount <id> <amountofparticles>\u00a7c.");
                        return false;
                    }
                    ItemStack getitem = Bukkit.getVersion().contains("1.8") || Bukkit.getVersion().contains("1.7") ? p.getItemInHand() : p.getInventory().getItemInMainHand();
                    if (getitem.getType() == XMaterial.AIR.parseMaterial()) {
                        p.sendMessage("\u00a7cYou must have an item in hand !");
                        return false;
                    }
                    for (ParticleEffect pe : ItemParticles.listparticleeffect) {
                        if (!pe.getId().equals(args[0])) continue;
                        p.sendMessage("\u00a7cId already taken !");
                        return false;
                    }
                    String name = null;
                    List lore = null;
                    Material type = getitem.getType();
                    if (getitem.hasItemMeta() && getitem.getItemMeta().getDisplayName() != null) {
                        name = getitem.getItemMeta().getDisplayName();
                    }
                    if (getitem.hasItemMeta() && getitem.getItemMeta().getLore() != null) {
                        lore = getitem.getItemMeta().getLore();
                    }
                    ParticleEffect pe = new ParticleEffect(name, lore, type, args[0], null, null, 0, null, null, null);
                    ItemParticles.listparticleeffect.add(pe);
                    p.sendMessage("\u00a7aYou created a new item particle !");
                    ItemParticlesHandler.openPrincipalGui(p, 1);
                } else if (args[0].equals("modifyamount")) {
                    for (ParticleEffect pe : ItemParticles.listparticleeffect) {
                        if (!pe.getId().equals(args[1])) continue;
                        try {
                            int lore = Integer.parseInt(args[2]);
                        }
                        catch (NullPointerException | NumberFormatException nfe) {
                            p.sendMessage("\u00a7cWrong arguments ! Are you sure that the amount of particles you wrote is a number ?");
                            return false;
                        }
                        pe.setAmount(Integer.parseInt(args[2]));
                        p.sendMessage("\u00a7cThe amount of particles has been set on \u00a7b" + args[2] + ".");
                        return false;
                    }
                    p.sendMessage("\u00a7cNo item particle found with this id !");
                } else if (args[0].equals("modifypermission")) {
                    for (ParticleEffect pe : ItemParticles.listparticleeffect) {
                        if (!pe.getId().equals(args[1])) continue;
                        pe.setPermission(args[2]);
                        p.sendMessage("\u00a7cThe permission of the effect \u00a7d" + pe.getId() + " \u00a7chas been set on \u00a7b" + args[2] + ".");
                        return false;
                    }
                    p.sendMessage("\u00a7cNo item particle found with this id !");
                } else {
                    p.sendMessage("\u00a7cWrong arguments !");
                }
            }
        }
        return false;
    }

    public static ItemStack getItemStack(String name, List<String> lore, Material type) {
        ItemStack is = new ItemStack(type);
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(name);
        im.setLore(lore);
        is.setItemMeta(im);
        return is;
    }

    public static void openPrincipalGui(Player p, int page) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_BLUE + "ItemParticles"));
        int i = 1;
        if (page != 1) {
            i = 0;
        }
        int numberinthelist = 0;
        if (page == 1) {
            inv.setItem(0, ItemParticlesHandler.getItemStack("\u00a7aCreate a new item particle", null, XMaterial.BLAZE_ROD.parseMaterial()));
        }
        for (ParticleEffect pe : ItemParticles.listparticleeffect) {
            if (page != 1 && numberinthelist < 52 * (page - 1)) {
                ++numberinthelist;
                continue;
            }
            ItemStack is = new ItemStack(XMaterial.MAGMA_CREAM.parseMaterial());
            ItemMeta im = is.getItemMeta();
            if (pe.getId() != null) {
                im.setDisplayName("\u00a7d\u00a7l" + pe.getId());
            }
            String name = "none";
            String type = "none";
            String lore = "none";
            if (pe.getName() != null) {
                name = pe.getName();
            }
            if (pe.getItem() != null) {
                type = pe.getItem().toString();
            }
            if (pe.getLore() != null) {
                lore = "set";
            }
            im.setLore(Arrays.asList("\u00a7b\u00a7lItem's name: " + name, "\u00a7b\u00a7lItem type: " + type, "\u00a7b\u00a7lItem's lore: " + lore, "" + numberinthelist));
            is.setItemMeta(im);
            inv.setItem(i, is);
            if (i == 52) {
                ItemStack nextpage = new ItemStack(XMaterial.PAPER.parseItem());
                ItemMeta pagemeta = nextpage.getItemMeta();
                pagemeta.setDisplayName("\u00a7c>Page " + (page + 1));
                nextpage.setItemMeta(pagemeta);
                inv.setItem(53, nextpage);
                break;
            }
            ++i;
            ++numberinthelist;
        }
        p.openInventory(inv);
        p.updateInventory();
    }
}

