/*
 * Decompiled with CFR 0.152.
 */
package org.shelk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.shelk.ParticleEffect;
import org.shelk.bStats.MetricsLite;
import org.shelk.commandhandler.ItemParticlesHandler;
import org.shelk.customsrunnables.AuraRunnable;
import org.shelk.customsrunnables.OtherParticlesRunnable;
import org.shelk.customsrunnables.PulseRunnable;
import org.shelk.customsrunnables.WingsRunnable;
import org.shelk.listener.InventoryClickListener;
import org.shelk.listener.ParticleMoveEvent;
import org.shelk.utils.XMaterial;

public class ItemParticles
extends JavaPlugin {
    public static ArrayList<ParticleEffect> listparticleeffect = new ArrayList();
    private final String fileName = "savedata.yml";
    private File file = new File(this.getDataFolder(), "savedata.yml");
    public static Plugin pl;

    public void onEnable() {
        pl = this;
        if (!Bukkit.getVersion().contains("1.7")) {
            MetricsLite metricsLite = new MetricsLite((Plugin)this);
        }
        ConfigurationSerialization.registerClass(ParticleEffect.class, (String)"ItemParticle");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)this.file);
        ArrayList deserialization = (ArrayList)conf.get("arraylist");
        listparticleeffect = deserialization != null && deserialization.size() > 0 ? deserialization : new ArrayList();
        this.getCommand("itemparticles").setExecutor((CommandExecutor)new ItemParticlesHandler());
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ParticleMoveEvent(), (Plugin)this);
        new OtherParticlesRunnable().runTaskTimer((Plugin)this, 0L, 20L);
        new AuraRunnable().runTaskTimer((Plugin)this, 0L, 4L);
        new PulseRunnable().runTaskTimer((Plugin)this, 0L, 4L);
        new WingsRunnable().runTaskTimer((Plugin)this, 0L, 20L);
    }

    public void onDisable() {
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)this.file);
        conf.set("arraylist", listparticleeffect);
        try {
            conf.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack getHands(int choice, ParticleEffect pe, Player p) {
        if (Bukkit.getVersion().contains("1.8") || Bukkit.getVersion().contains("1.7")) {
            return p.getItemInHand();
        }
        ItemStack mainhand = p.getInventory().getItemInMainHand();
        ItemStack secondhand = p.getInventory().getItemInOffHand();
        if (pe.getHands() != null && pe.getHands().equals("lefthand")) {
            mainhand = p.getInventory().getItemInOffHand();
        }
        if (pe.getHands() == null || !pe.getHands().equals("both")) {
            secondhand = mainhand.clone();
        }
        if (choice == 1) {
            return mainhand;
        }
        if (choice == 2) {
            return secondhand;
        }
        return null;
    }

    public static ArrayList<ParticleEffect> getParticleEffectItem(Player p) {
        if (p.hasPermission("itemparticles.display")) {
            ArrayList<ParticleEffect> al = new ArrayList<ParticleEffect>();
            if (listparticleeffect != null && listparticleeffect.size() > 0) {
                for (ParticleEffect pe : listparticleeffect) {
                    ItemStack[] armor;
                    if (pe == null || pe.getPermission() != null && !p.hasPermission(pe.getPermission())) continue;
                    ItemStack gethand = ItemParticles.getHands(1, pe, p);
                    ItemStack otherhand = ItemParticles.getHands(2, pe, p);
                    ItemStack[] itemStackArray = armor = p.getInventory().getArmorContents();
                    int n = armor.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemStack armoritem = itemStackArray[n2];
                        if (armoritem != null && ItemParticles.isSameItem(pe, armoritem, XMaterial.AIR.parseItem())) {
                            al.add(pe);
                        }
                        ++n2;
                    }
                    if (!ItemParticles.isSameItem(pe, gethand, otherhand)) continue;
                    al.add(pe);
                }
            }
            if (al != null && al.size() > 0) {
                return al;
            }
        }
        return null;
    }

    private static boolean isSameItem(ParticleEffect pe, ItemStack gethand, ItemStack otherhand) {
        if (pe.getItem() == null || gethand == null && otherhand == null) {
            return false;
        }
        if (gethand.getType() != null && gethand.getType() != pe.getItem() && otherhand.getType() != pe.getItem()) {
            return false;
        }
        if (pe.getName() != null && !ItemParticles.isSameName(pe, gethand) && !ItemParticles.isSameName(pe, otherhand)) {
            return false;
        }
        if (pe.getLore() != null && !ItemParticles.isSameLore(pe, gethand) && !ItemParticles.isSameLore(pe, otherhand)) {
            return false;
        }
        if (pe.getParticle() == null) {
            return false;
        }
        return pe.getShape() != null;
    }

    private static boolean isSameLore(ParticleEffect particleEffect, ItemStack compareItem) {
        if (compareItem == null) {
            return false;
        }
        if (!compareItem.hasItemMeta()) {
            return false;
        }
        if (!compareItem.getItemMeta().hasLore()) {
            return false;
        }
        return compareItem.getItemMeta().getLore().equals(particleEffect.getLore());
    }

    private static boolean isSameName(ParticleEffect particleEffect, ItemStack compareItem) {
        if (compareItem == null) {
            return false;
        }
        if (!compareItem.hasItemMeta()) {
            return false;
        }
        if (!compareItem.getItemMeta().hasDisplayName()) {
            return false;
        }
        return compareItem.getItemMeta().getDisplayName().equals(particleEffect.getName());
    }
}

