/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.utils;

import dev.hexedhero.invisibleitemframes.InvisibleItemFrames;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GlowHelper {
    private static final String SCOREBOARD_TEAM_NAME = "itf_glow_%color_char%";
    private static final Scoreboard SCOREBOARD = Bukkit.getScoreboardManager().getMainScoreboard();

    private GlowHelper() {
    }

    public static void setGlowing(ItemFrame itemFrame, ChatColor chatColor) {
        String scoreboardTeamNameReplaced = SCOREBOARD_TEAM_NAME.replace("%color_char%", String.valueOf(chatColor.getChar()));
        Team entityTeam = SCOREBOARD.getTeam(scoreboardTeamNameReplaced);
        if (entityTeam == null) {
            entityTeam = SCOREBOARD.registerNewTeam(scoreboardTeamNameReplaced);
        }
        if (!itemFrame.isGlowing()) {
            itemFrame.setGlowing(true);
        }
        if (!entityTeam.getEntries().contains(itemFrame.getUniqueId().toString())) {
            entityTeam.addEntry(itemFrame.getUniqueId().toString());
        }
        entityTeam.setColor(chatColor);
    }

    public static void removeGlow(ItemFrame itemFrame) {
        if (itemFrame.isGlowing()) {
            itemFrame.setGlowing(false);
        }
        Bukkit.getScheduler().runTask((Plugin)InvisibleItemFrames.getInstance(), () -> {
            Team entityTeam = SCOREBOARD.getEntityTeam((Entity)itemFrame);
            if (entityTeam != null) {
                entityTeam.removeEntry(itemFrame.getUniqueId().toString());
            }
        });
    }
}

