/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.utils;

import dev.hexedhero.invisibleitemframes.InvisibleItemFrames;
import dev.hexedhero.invisibleitemframes.utils.ColorHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Common {
    private static final DecimalFormat NUMBER_FORMAT_NANO = new DecimalFormat("0.00");

    private Common() {
    }

    public static void tell(CommandSender sender, String ... messages) {
        for (String message : messages) {
            if (sender instanceof Player) {
                sender.sendMessage(ColorHelper.colorize(message));
                continue;
            }
            Common.tellConsole(message);
        }
    }

    public static void tellConsole(String ... messages) {
        for (String message : messages) {
            Bukkit.getConsoleSender().sendMessage("[InvisibleItemFrames] " + ColorHelper.colorize(message));
        }
    }

    public static String nanosToMillis(long nanoseconds) {
        return NUMBER_FORMAT_NANO.format((double)nanoseconds / 1000000.0);
    }

    public static String getLanguage(String path, boolean usePrefix) {
        return (usePrefix ? Common.getLanguagePrefix() : "") + InvisibleItemFrames.getInstance().getConfig().getString("Language." + path);
    }

    public static List<String> getLanguageList(String path, boolean usePrefix) {
        if (!usePrefix) {
            return InvisibleItemFrames.getInstance().getConfig().getStringList("Language." + path);
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String string : InvisibleItemFrames.getInstance().getConfig().getStringList("Language." + path)) {
            newList.add(Common.getLanguagePrefix() + string);
        }
        return newList;
    }

    public static String getLanguagePrefix(CommandSender sender) {
        return sender instanceof Player ? Common.getLanguagePrefix() : "";
    }

    public static String getLanguagePrefix() {
        return InvisibleItemFrames.getInstance().getConfig().getString("Language.Prefix");
    }
}

