/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.utils;

import dev.hexedhero.invisibleitemframes.utils.VersionHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorHelper {
    private static final List<Pattern> HEX_PATTERNS = Arrays.asList(Pattern.compile("<#([A-Fa-f0-9]){6}>"), Pattern.compile("\\[#([A-Fa-f0-9]){6}\\]"), Pattern.compile("\\{#([A-Fa-f0-9]){6}\\}"), Pattern.compile("\\(#([A-Fa-f0-9]){6}\\)"), Pattern.compile("&#([A-Fa-f0-9]){6}"), Pattern.compile("#([A-Fa-f0-9]){6}"));

    private ColorHelper() {
    }

    public static String colorize(String message) {
        for (Pattern hexPattern : HEX_PATTERNS) {
            Matcher matcher = hexPattern.matcher(message);
            while (matcher.find()) {
                ChatColor color = ColorHelper.getHexColorOrClosestLegacyColor(ColorHelper.cleanHex(matcher.group()));
                String before = message.substring(0, matcher.start());
                String after = message.substring(matcher.end());
                message = before + color + after;
                matcher = hexPattern.matcher(message);
            }
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static List<String> colorize(List<String> messages) {
        ArrayList<String> colorizedList = new ArrayList<String>();
        for (String message : messages) {
            colorizedList.add(ColorHelper.colorize(message));
        }
        return colorizedList;
    }

    private static ChatColor getHexColorOrClosestLegacyColor(String hexColor) {
        if (VersionHelper.getMajorVersionNumber() >= 16) {
            return ChatColor.of((String)hexColor);
        }
        int minDist = Integer.MAX_VALUE;
        ChatColor legacy = ChatColor.WHITE;
        Color color = Color.decode(hexColor);
        for (ChatColorToHexMappings mapping : ChatColorToHexMappings.values()) {
            int b;
            int g;
            int r = mapping.getRed() - color.getRed();
            int dist = r * r + (g = mapping.getGreen() - color.getGreen()) * g + (b = mapping.getBlue() - color.getBlue()) * b;
            if (dist >= minDist) continue;
            minDist = dist;
            legacy = mapping.getChatColor();
        }
        return legacy;
    }

    private static String cleanHex(String hexColor) {
        return hexColor.replaceAll("[<>\\[\\]\\{\\}\\(\\)&]", "");
    }

    private static enum ChatColorToHexMappings {
        BLACK(ChatColor.BLACK, 0),
        DARK_BLUE(ChatColor.DARK_BLUE, 170),
        DARK_GREEN(ChatColor.DARK_GREEN, 43520),
        DARK_AQUA(ChatColor.DARK_AQUA, 43690),
        DARK_RED(ChatColor.DARK_RED, 0xAA0000),
        DARK_PURPLE(ChatColor.DARK_PURPLE, 0xAA00AA),
        GOLD(ChatColor.GOLD, 0xFFAA00),
        GRAY(ChatColor.GRAY, 0xAAAAAA),
        DARK_GRAY(ChatColor.DARK_GRAY, 0x555555),
        BLUE(ChatColor.BLUE, 0x5555FF),
        GREEN(ChatColor.GREEN, 0x55FF55),
        AQUA(ChatColor.AQUA, 0x55FFFF),
        RED(ChatColor.RED, 0xFF5555),
        LIGHT_PURPLE(ChatColor.LIGHT_PURPLE, 0xFF55FF),
        YELLOW(ChatColor.YELLOW, 0xFFFF55),
        WHITE(ChatColor.WHITE, 0xFFFFFF);

        private final ChatColor chatColor;
        private final int red;
        private final int green;
        private final int blue;

        private ChatColorToHexMappings(ChatColor chatColor, int hex) {
            this.chatColor = chatColor;
            this.red = hex >> 16 & 0xFF;
            this.green = hex >> 8 & 0xFF;
            this.blue = hex & 0xFF;
        }

        public ChatColor getChatColor() {
            return this.chatColor;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

