/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.managers;

import dev.hexedhero.invisibleitemframes.enums.EToggleType;
import dev.hexedhero.invisibleitemframes.utils.Common;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class MemoryDataManager {
    private final Map<UUID, Map.Entry<EToggleType, ChatColor>> playersInToggleMode = new HashMap<UUID, Map.Entry<EToggleType, ChatColor>>();
    private static MemoryDataManager instance;

    public static MemoryDataManager getInstance() {
        if (instance == null) {
            instance = new MemoryDataManager();
        }
        return instance;
    }

    private MemoryDataManager() {
        Common.tellConsole("MemoryDataManager initialized!");
    }

    public void addPlayerToToggleMode(Player player, EToggleType toggleType, @Nullable ChatColor chatColor) {
        this.playersInToggleMode.put(player.getUniqueId(), new AbstractMap.SimpleEntry<EToggleType, ChatColor>(toggleType, chatColor));
    }

    public void removePlayerFromToggleMode(Player player) {
        this.playersInToggleMode.remove(player.getUniqueId());
    }

    @Nullable
    public Map.Entry<EToggleType, ChatColor> getPlayerToggleMode(Player player) {
        return this.playersInToggleMode.get(player.getUniqueId());
    }
}

