/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.managers;

import dev.hexedhero.invisibleitemframes.implementations.IServerImplementation;
import dev.hexedhero.invisibleitemframes.implementations.PaperImplementation;
import dev.hexedhero.invisibleitemframes.implementations.SpigotImplementation;
import dev.hexedhero.invisibleitemframes.utils.Common;
import dev.hexedhero.invisibleitemframes.utils.VersionHelper;

public class ImplementationManager {
    private final IServerImplementation serverImplementation = this.setupImplementation();
    private static ImplementationManager instance;

    public static ImplementationManager getInstance() {
        if (instance == null) {
            instance = new ImplementationManager();
        }
        return instance;
    }

    private ImplementationManager() {
        Common.tellConsole("ImplementationManager initialized!");
    }

    public IServerImplementation getServerImplementation() {
        return this.serverImplementation;
    }

    private IServerImplementation setupImplementation() {
        IServerImplementation serverImplementation;
        if (VersionHelper.isPaper()) {
            serverImplementation = new PaperImplementation();
            Common.tellConsole("&aUsing Paper Implementation!");
        } else {
            serverImplementation = new SpigotImplementation();
            Common.tellConsole("&cUsing Spigot/Bukkit Implementation!");
        }
        return serverImplementation;
    }
}

