/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.listeners;

import dev.hexedhero.invisibleitemframes.InvisibleItemFrames;
import dev.hexedhero.invisibleitemframes.enums.EToggleType;
import dev.hexedhero.invisibleitemframes.events.FakePlayerInteractEntityEvent;
import dev.hexedhero.invisibleitemframes.managers.MemoryDataManager;
import dev.hexedhero.invisibleitemframes.utils.Common;
import dev.hexedhero.invisibleitemframes.utils.GlowHelper;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void a(PlayerInteractEntityEvent event) {
        if (event instanceof FakePlayerInteractEntityEvent) {
            return;
        }
        EquipmentSlot hand = event.getHand();
        if (hand.equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        Player player = event.getPlayer();
        ItemFrame itemFrame = (ItemFrame)entity;
        this.handleInteractMode(event, player, itemFrame);
        this.handleContainerPassthrough(event, player, itemFrame);
        this.handleAutomaticToggling(event, player, itemFrame);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void b(EntityDamageByEntityEvent event) {
        boolean wasEmpty;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        if (InvisibleItemFrames.getInstance().getConfig().getBoolean("Automatic Toggling") && !(wasEmpty = itemFrame.getItem().getType().isAir())) {
            Bukkit.getScheduler().runTask((Plugin)InvisibleItemFrames.getInstance(), () -> {
                boolean isStillEmpty = itemFrame.getItem().getType().isAir();
                if (isStillEmpty) {
                    itemFrame.setVisible(true);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void c(PlayerQuitEvent event) {
        MemoryDataManager.getInstance().removePlayerFromToggleMode(event.getPlayer());
    }

    private void handleInteractMode(PlayerInteractEntityEvent event, Player player, ItemFrame itemFrame) {
        Map.Entry<EToggleType, ChatColor> toggleType = MemoryDataManager.getInstance().getPlayerToggleMode(player);
        if (toggleType != null) {
            event.setCancelled(true);
            if (toggleType.getKey().equals((Object)EToggleType.VISIBILITY)) {
                itemFrame.setVisible(!itemFrame.isVisible());
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Visibility", true).replace("%status%", itemFrame.isVisible() ? Common.getLanguage("Toggle Visibility On", false) : Common.getLanguage("Toggle Visibility Off", false)));
            } else if (toggleType.getKey().equals((Object)EToggleType.GLOW)) {
                if (itemFrame.isGlowing()) {
                    GlowHelper.removeGlow(itemFrame);
                } else {
                    GlowHelper.setGlowing(itemFrame, toggleType.getValue());
                }
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Glow", true).replace("%status%", itemFrame.isGlowing() ? Common.getLanguage("Toggle Glow On", false) : Common.getLanguage("Toggle Glow Off", false)));
            }
            return;
        }
    }

    private void handleContainerPassthrough(PlayerInteractEntityEvent event, Player player, ItemFrame itemFrame) {
        if (InvisibleItemFrames.getInstance().getConfig().getBoolean("Container Passthrough.Enabled")) {
            String type = InvisibleItemFrames.getInstance().getConfig().getString("Container Passthrough.Type");
            if (type.equalsIgnoreCase("VISIBLE") && !itemFrame.isVisible() || type.equalsIgnoreCase("INVISIBLE") && itemFrame.isVisible()) {
                return;
            }
            String mode = InvisibleItemFrames.getInstance().getConfig().getString("Container Passthrough.Mode");
            if (mode.equalsIgnoreCase("SHIFTING") && !player.isSneaking() || mode.equalsIgnoreCase("STANDING") && player.isSneaking()) {
                return;
            }
            Block attachedBlock = itemFrame.getLocation().getBlock().getRelative(itemFrame.getAttachedFace());
            BlockState blockState = attachedBlock.getState();
            if (blockState instanceof Container) {
                event.setCancelled(true);
                Container container = (Container)blockState;
                player.openInventory(container.getInventory());
            }
        }
    }

    private void handleAutomaticToggling(PlayerInteractEntityEvent event, Player player, ItemFrame itemFrame) {
        boolean wasEmpty;
        if (InvisibleItemFrames.getInstance().getConfig().getBoolean("Automatic Toggling") && (wasEmpty = itemFrame.getItem().getType().isAir())) {
            Bukkit.getScheduler().runTask((Plugin)InvisibleItemFrames.getInstance(), () -> {
                boolean isStillEmpty = itemFrame.getItem().getType().isAir();
                if (!isStillEmpty) {
                    itemFrame.setVisible(false);
                }
            });
        }
    }
}

