/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes.commands;

import dev.hexedhero.invisibleitemframes.InvisibleItemFrames;
import dev.hexedhero.invisibleitemframes.enums.EToggleType;
import dev.hexedhero.invisibleitemframes.events.FakePlayerInteractEntityEvent;
import dev.hexedhero.invisibleitemframes.managers.ImplementationManager;
import dev.hexedhero.invisibleitemframes.managers.MemoryDataManager;
import dev.hexedhero.invisibleitemframes.utils.Common;
import dev.hexedhero.invisibleitemframes.utils.GlowHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MainCommand
extends Command {
    public MainCommand() {
        super("invisibleitemframes");
        this.setAliases(Arrays.asList("itf"));
        this.setDescription("Plugin's main command");
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (args.length < 1 || !args[0].equalsIgnoreCase("toggle") && !args[0].equalsIgnoreCase("togglemode") && !args[0].equalsIgnoreCase("scan") && !args[0].equalsIgnoreCase("reload")) {
            this.sendDefaultMessage(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            if (!(sender instanceof Player)) {
                Common.tell(sender, Common.getLanguage("Only Players", sender instanceof Player));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("invisibleitemframes.command.toggle.visibility") && !player.hasPermission("invisibleitemframes.command.toggle.glow")) {
                Common.tell(sender, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            Entity entity = ImplementationManager.getInstance().getServerImplementation().getLookingAtEntity(player);
            if (!(entity instanceof ItemFrame)) {
                Common.tell(sender, Common.getLanguage("Not Looking", sender instanceof Player));
                return true;
            }
            ItemFrame itemFrame = (ItemFrame)entity;
            FakePlayerInteractEntityEvent fakePlayerInteractEntityEvent = new FakePlayerInteractEntityEvent(player, (Entity)itemFrame, EquipmentSlot.HAND);
            if (!fakePlayerInteractEntityEvent.callEvent()) {
                return true;
            }
            if (args.length < 2) {
                Common.tell((CommandSender)player, Common.getLanguage("Toggle No Type", sender instanceof Player));
                return true;
            }
            EToggleType toggleType = null;
            try {
                toggleType = EToggleType.valueOf(args[1].toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Invalid Type", sender instanceof Player));
                return true;
            }
            if (toggleType.equals((Object)EToggleType.VISIBILITY) && !player.hasPermission("invisibleitemframes.command.toggle.visibility") || toggleType.equals((Object)EToggleType.GLOW) && !player.hasPermission("invisibleitemframes.command.toggle.glow")) {
                Common.tell((CommandSender)player, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            ChatColor chatColor = null;
            if (toggleType.equals((Object)EToggleType.GLOW) && !itemFrame.isGlowing()) {
                if (args.length < 3) {
                    Common.tell((CommandSender)player, Common.getLanguage("Toggle No Glow Color", sender instanceof Player));
                    return true;
                }
                try {
                    chatColor = ChatColor.valueOf((String)args[2].toUpperCase());
                    if (!chatColor.isColor()) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (IllegalArgumentException exception) {
                    Common.tell((CommandSender)player, Common.getLanguage("Toggle Invalid Glow Color", sender instanceof Player));
                    return true;
                }
            }
            if (toggleType.equals((Object)EToggleType.VISIBILITY)) {
                itemFrame.setVisible(!itemFrame.isVisible());
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Visibility", sender instanceof Player).replace("%status%", itemFrame.isVisible() ? Common.getLanguage("Toggle Visibility On", false) : Common.getLanguage("Toggle Visibility Off", false)));
                return true;
            }
            if (toggleType.equals((Object)EToggleType.GLOW)) {
                if (itemFrame.isGlowing()) {
                    GlowHelper.removeGlow(itemFrame);
                } else {
                    GlowHelper.setGlowing(itemFrame, chatColor);
                }
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Glow", sender instanceof Player).replace("%status%", itemFrame.isGlowing() ? Common.getLanguage("Toggle Glow On", false) : Common.getLanguage("Toggle Glow Off", false)));
                return true;
            }
        } else if (args[0].equalsIgnoreCase("togglemode")) {
            boolean wasInMode;
            if (!(sender instanceof Player)) {
                Common.tell(sender, Common.getLanguage("Only Players", sender instanceof Player));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("invisibleitemframes.command.togglemode.visibility") && !player.hasPermission("invisibleitemframes.command.togglemode.glow")) {
                Common.tell((CommandSender)player, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            if (args.length < 2) {
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Mode No Type", sender instanceof Player));
                return true;
            }
            EToggleType toggleType = null;
            try {
                toggleType = EToggleType.valueOf(args[1].toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                Common.tell((CommandSender)player, Common.getLanguage("Toggle Mode Invalid Type", sender instanceof Player));
                return true;
            }
            if (toggleType.equals((Object)EToggleType.VISIBILITY) && !player.hasPermission("invisibleitemframes.command.togglemode.visibility") || toggleType.equals((Object)EToggleType.GLOW) && !player.hasPermission("invisibleitemframes.command.togglemode.glow")) {
                Common.tell((CommandSender)player, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            boolean bl = wasInMode = MemoryDataManager.getInstance().getPlayerToggleMode(player) != null;
            if (wasInMode) {
                MemoryDataManager.getInstance().removePlayerFromToggleMode(player);
            }
            ChatColor chatColor = null;
            if (!wasInMode && toggleType.equals((Object)EToggleType.GLOW)) {
                if (args.length < 3) {
                    Common.tell((CommandSender)player, Common.getLanguage("Toggle Mode No Glow Color", sender instanceof Player));
                    return true;
                }
                try {
                    chatColor = ChatColor.valueOf((String)args[2].toUpperCase());
                    if (!chatColor.isColor()) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (IllegalArgumentException exception) {
                    Common.tell((CommandSender)player, Common.getLanguage("Toggle Mode Invalid Glow Color", sender instanceof Player));
                    return true;
                }
            }
            if (!wasInMode) {
                MemoryDataManager.getInstance().addPlayerToToggleMode(player, toggleType, chatColor);
            }
            Common.tell((CommandSender)player, Common.getLanguage("Toggle Mode", sender instanceof Player).replace("%status%", !wasInMode ? Common.getLanguage("Toggle Mode On", false) : Common.getLanguage("Toggle Mode Off", false)).replace("%type%", toggleType.equals((Object)EToggleType.VISIBILITY) ? Common.getLanguage("Toggle Mode Visibility", false) : Common.getLanguage("Toggle Mode Glow", false)));
        } else if (args[0].equalsIgnoreCase("scan")) {
            byte radius;
            if (!(sender instanceof Player)) {
                Common.tell(sender, Common.getLanguage("Only Players", sender instanceof Player));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("invisibleitemframes.command.scan")) {
                Common.tell((CommandSender)player, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            if (args.length < 2) {
                Common.tell((CommandSender)player, Common.getLanguage("Scan No Number", sender instanceof Player));
                return true;
            }
            try {
                radius = Byte.parseByte(args[1]);
            }
            catch (NumberFormatException exception) {
                Common.tell((CommandSender)player, Common.getLanguage("Non Number", sender instanceof Player).replace("%value%", args[1]));
                return true;
            }
            if (radius <= 0 || radius >= 128) {
                Common.tell((CommandSender)player, Common.getLanguage("Non Number", sender instanceof Player).replace("%value%", Byte.toString(radius)));
                return true;
            }
            final Collection<ItemFrame> itemFrames = ImplementationManager.getInstance().getServerImplementation().getNearbyItemFrames(player.getLocation(), radius);
            new BukkitRunnable(){
                int ticks = 0;

                public void run() {
                    if (this.ticks++ >= 12) {
                        this.cancel();
                    }
                    for (ItemFrame itemFrame : itemFrames) {
                        itemFrame.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, itemFrame.getLocation().getBlock().getLocation().add(0.5, 0.5, 0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }.runTaskTimer((Plugin)InvisibleItemFrames.getInstance(), 0L, 10L);
            Common.tell((CommandSender)player, Common.getLanguage("Scan", sender instanceof Player).replace("%count%", Integer.toString(itemFrames.size())));
        } else if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("invisibleitemframes.command.reload")) {
                Common.tell(sender, Common.getLanguage("No Permission", sender instanceof Player));
                return true;
            }
            InvisibleItemFrames.getInstance().reloadPlugin(sender);
            return true;
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list;
        block4: {
            block5: {
                block6: {
                    block3: {
                        list = new ArrayList<String>();
                        if (args.length != 1) break block3;
                        list.add("toggle");
                        list.add("togglemode");
                        list.add("scan");
                        list.add("reload");
                        break block4;
                    }
                    if (args.length != 2) break block5;
                    if (!args[0].equalsIgnoreCase("scan")) break block6;
                    list.add("16");
                    list.add("32");
                    list.add("48");
                    list.add("64");
                    break block4;
                }
                if (!args[0].equalsIgnoreCase("toggle") && !args[0].equalsIgnoreCase("togglemode")) break block4;
                for (EToggleType toggleType : EToggleType.values()) {
                    list.add(toggleType.toString().toLowerCase());
                }
                break block4;
            }
            if (args.length == 3 && args[1].equalsIgnoreCase(EToggleType.GLOW.toString()) && (args[0].equalsIgnoreCase("toggle") || args[0].equalsIgnoreCase("togglemode"))) {
                for (ChatColor chatColor : ChatColor.values()) {
                    if (!chatColor.isColor()) continue;
                    list.add(chatColor.name().toLowerCase());
                }
            }
        }
        return args[args.length - 1].isEmpty() ? list : list.stream().filter(string -> string.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }

    private void sendDefaultMessage(CommandSender sender) {
        for (String message : Common.getLanguageList("Command Usage", sender instanceof Player)) {
            Common.tell(sender, message);
        }
    }
}

