/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.invisibleitemframes;

import dev.hexedhero.invisibleitemframes.commands.MainCommand;
import dev.hexedhero.invisibleitemframes.listeners.PlayerListener;
import dev.hexedhero.invisibleitemframes.managers.ImplementationManager;
import dev.hexedhero.invisibleitemframes.managers.MemoryDataManager;
import dev.hexedhero.invisibleitemframes.shaded.bstats.bukkit.Metrics;
import dev.hexedhero.invisibleitemframes.shaded.bstats.charts.SimplePie;
import dev.hexedhero.invisibleitemframes.utils.Common;
import dev.hexedhero.invisibleitemframes.utils.RegistrationHelper;
import dev.hexedhero.invisibleitemframes.utils.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InvisibleItemFrames
extends JavaPlugin {
    private static InvisibleItemFrames instance;

    public static InvisibleItemFrames getInstance() {
        return instance;
    }

    public InvisibleItemFrames() {
        instance = this;
    }

    public void onEnable() {
        long enableStartTime = System.nanoTime();
        if (VersionHelper.getMajorVersionNumber() < 16) {
            Common.tellConsole("&cTHIS PLUGIN IS ONLY FOR MINECRAFT 1.16+");
            Bukkit.getPluginManager().disablePlugin((Plugin)InvisibleItemFrames.getInstance());
            return;
        }
        Common.tellConsole("Initializing managers...");
        MemoryDataManager.getInstance();
        ImplementationManager.getInstance();
        Common.tellConsole("Registering commands...");
        RegistrationHelper.registerCommands(new MainCommand());
        Common.tellConsole("Registering listeners...");
        RegistrationHelper.registerListeners(new PlayerListener());
        Common.tellConsole("Loading data...");
        this.saveDefaultConfig();
        Common.tellConsole("Starting metrics...");
        Metrics metrics = new Metrics(InvisibleItemFrames.getInstance(), 9179);
        metrics.addCustomChart(new SimplePie("container_passthrough", () -> Boolean.toString(this.getConfig().getBoolean("Container Passthrough.Enabled"))));
        metrics.addCustomChart(new SimplePie("automatic_toggling", () -> Boolean.toString(this.getConfig().getBoolean("Automatic Toggling"))));
        Common.tellConsole("&aDone and enabled in %time%ms".replace("%time%", Common.nanosToMillis(System.nanoTime() - enableStartTime)));
    }

    public void onDisable() {
        Common.tellConsole("&aDone and disabled!", "&aIf you liked the plugin, don't forget to give a &e\u2605\u2605\u2605\u2605\u2605 &arating!", "&aThank you and have a great day!");
    }

    public void reloadPlugin(CommandSender sender) {
        Common.tell(sender, Common.getLanguagePrefix(sender) + "&aReloading &a&lInvisibleItemFrames&a:");
        Common.tell(sender, Common.getLanguagePrefix(sender) + "&fReloading config...");
        this.reloadConfig();
        Common.tell(sender, Common.getLanguagePrefix(sender) + "&aReloaded &a&lInvisibleItemFrames %version%&a successfully!".replace("%version%", "v" + InvisibleItemFrames.getInstance().getDescription().getVersion()));
    }
}

