/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.libraryaddict.inventory.AnvilInventory;
import me.libraryaddict.inventory.ClickInventory;
import me.libraryaddict.inventory.NamedInventory;
import me.libraryaddict.inventory.PageInventory;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryApi
extends JavaPlugin
implements Listener {
    private static ArrayList<ClickInventory> inventories = new ArrayList();

    public static ItemStack[] generateEmptyPage(int itemsSize) {
        itemsSize = (int)Math.ceil((double)itemsSize / 9.0) * 9;
        return new ItemStack[Math.min(54, itemsSize)];
    }

    public static String getHiddenString(ItemStack item) {
        StringBuilder builder = new StringBuilder();
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        char[] chars = item.getItemMeta().getDisplayName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00a7') continue;
            if (i + 1 < chars.length) {
                if (chars[i + 1] == '\u00a7' && i > 1 && chars[i - 1] == '\u00a7') {
                    builder.append(c);
                    continue;
                }
                if (builder.length() <= 0) continue;
                builder = new StringBuilder();
                continue;
            }
            if (i <= 0 || chars[i - 1] != '\u00a7') continue;
            builder.append(c);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    public static NamedInventory[] getNamedInventories(Player p) {
        if (!p.hasMetadata("NamedInventory")) {
            return new NamedInventory[2];
        }
        return (NamedInventory[])((NamedInventory[])((MetadataValue)p.getMetadata("NamedInventory").get(0)).value()).clone();
    }

    public static NamedInventory getNamedInventory(Player p) {
        NamedInventory[] invs = InventoryApi.getNamedInventories(p);
        return invs[0];
    }

    public static AnvilInventory getAnvilInventory(Player p) {
        if (!p.hasMetadata("AnvilInventory")) {
            return null;
        }
        return ((AnvilInventory[])((MetadataValue)p.getMetadata("AnvilInventory").get(0)).value())[0];
    }

    public static PageInventory[] getPageInventories(Player p) {
        if (!p.hasMetadata("PageInventory")) {
            return new PageInventory[2];
        }
        return (PageInventory[])((PageInventory[])((MetadataValue)p.getMetadata("PageInventory").get(0)).value()).clone();
    }

    public static PageInventory getPageInventory(Player p) {
        PageInventory[] invs = InventoryApi.getPageInventories(p);
        return invs[0];
    }

    public static boolean hasHiddenString(ItemStack item) {
        return InventoryApi.getHiddenString(item) != null;
    }

    public static void registerInventory(ClickInventory inv) {
        inventories.add(inv);
    }

    public static ItemStack setHiddenString(ItemStack itemToName, String name) {
        String itemName = ChatColor.WHITE + InventoryApi.toReadable(itemToName.getType().name());
        ItemMeta meta = itemToName.getItemMeta();
        if (meta.hasDisplayName()) {
            itemName = meta.getDisplayName();
        }
        for (int i = 0; i < name.length(); ++i) {
            itemName = itemName + '\u00a7' + name.substring(i, i + 1);
        }
        meta.setDisplayName(itemName);
        itemToName.setItemMeta(meta);
        return itemToName;
    }

    @Deprecated
    public static ItemStack setNameAndLore(ItemStack item, String name, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            if (ChatColor.stripColor((String)name).equals(name)) {
                name = ChatColor.WHITE + name;
            }
            meta.setDisplayName(name);
        }
        if (lore != null && lore.size() > 0) {
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    @Deprecated
    public static ItemStack setNameAndLore(ItemStack item, String name, String ... lore) {
        return InventoryApi.setNameAndLore(item, name, Arrays.asList(lore));
    }

    public static ItemStack setUniqueItem(ItemStack item) {
        return InventoryApi.setHiddenString(item, System.currentTimeMillis() + "");
    }

    private static String toReadable(String string) {
        Object[] names = string.split("_");
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((String)names[i]).substring(0, 1) + ((String)names[i]).substring(1).toLowerCase();
        }
        return StringUtils.join((Object[])names, (String)" ");
    }

    protected static void unregisterInventory(ClickInventory inv) {
        inventories.remove(inv);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        int found = 0;
        for (ClickInventory inv : new ArrayList<ClickInventory>(inventories)) {
            if (inv.getPlayer() != event.getPlayer()) continue;
            if (inv.isInventoryInUse()) {
                inv.closeInventory(false);
            }
            if (found++ != 1) continue;
            break;
        }
    }

    public void onEnable() {
        ClickInventory.plugin = this;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int found = 0;
        for (ClickInventory cInv : new ArrayList<ClickInventory>(inventories)) {
            if (cInv.getPlayer() != event.getWhoClicked()) continue;
            cInv.onInventoryClick(event);
            if (found++ != 1) continue;
            break;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        int found = 0;
        for (ClickInventory inv : new ArrayList<ClickInventory>(inventories)) {
            if (inv.getPlayer() != event.getWhoClicked()) continue;
            inv.onInventoryDrag(event);
            if (found++ != 1) continue;
            break;
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        int found = 0;
        for (ClickInventory inv : new ArrayList<ClickInventory>(inventories)) {
            if (inv.getPlayer() != event.getPlayer()) continue;
            if (inv.isInventoryInUse()) {
                inv.closeInventory(false);
            }
            if (found++ != 1) continue;
            break;
        }
    }
}

