/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.inventory;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import me.libraryaddict.inventory.AnvilInventory;
import me.libraryaddict.inventory.InventoryApi;
import me.libraryaddict.inventory.NamedInventory;
import me.libraryaddict.inventory.PageInventory;
import me.libraryaddict.inventory.events.NamedCloseEvent;
import me.libraryaddict.inventory.events.PageCloseEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class ClickInventory<E> {
    protected static JavaPlugin plugin;
    protected Inventory currentInventory;
    protected boolean inventoryInUse;
    private boolean modifiable;
    private Player player;
    private boolean playerInventoryUsed;
    private ItemStack[] previousContents;
    private String inventoryName;
    private HashMap savedData = new HashMap();

    protected void saveContents() {
        this.previousContents = (ItemStack[])this.getPlayer().getInventory().getContents().clone();
    }

    public Object getData(Object key) {
        return this.savedData.get(key);
    }

    public ClickInventory setData(Object key, Object obj) {
        if (obj == null) {
            this.savedData.remove(key);
        } else {
            this.savedData.put(key, obj);
        }
        return this;
    }

    public ClickInventory(String inventoryName, Player player) {
        this.player = player;
        if (inventoryName == null) {
            inventoryName = this.getClass().getSimpleName();
        }
        this.inventoryName = inventoryName;
    }

    public String getName() {
        return this.inventoryName;
    }

    public ClickInventory setPlayerInventory() {
        if (!this.isInventoryInUse()) {
            this.playerInventoryUsed = true;
        }
        return this;
    }

    public void closeInventory() {
        this.closeInventory(true);
    }

    protected void onInventoryDrag(InventoryDragEvent event) {
        if (!this.isModifiable()) {
            Iterator i$ = event.getRawSlots().iterator();
            while (i$.hasNext()) {
                int slot = (Integer)i$.next();
                if (!this.checkInMenu(slot)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    protected boolean checkInMenu(int rawSlot) {
        if (this.isPlayerInventory()) {
            if (this.getPlayer().getOpenInventory().getTopInventory().getHolder() != this.getPlayer()) {
                rawSlot -= this.getPlayer().getOpenInventory().getTopInventory().getSize();
            }
            return rawSlot >= 0 && rawSlot < this.currentInventory.getSize();
        }
        return rawSlot < this.currentInventory.getSize();
    }

    public boolean isPlayerInventory() {
        return this.playerInventoryUsed;
    }

    protected abstract void onInventoryClick(InventoryClickEvent var1);

    private void closeInventory(boolean forceClose, boolean restoreInventory) {
        Object[] invs;
        InventoryApi.unregisterInventory(this);
        this.inventoryInUse = false;
        if (this.getPlayer().hasMetadata(this.getClass().getSimpleName()) && (invs = (Object[])((MetadataValue)this.getPlayer().getMetadata(this.getClass().getSimpleName()).get(0)).value())[this.isPlayerInventory() ? 1 : 0] == this) {
            invs[this.isPlayerInventory() ? 1 : 0] = null;
        }
        if (this instanceof NamedInventory) {
            Bukkit.getPluginManager().callEvent((Event)new NamedCloseEvent((NamedInventory)this));
        }
        if (this instanceof PageInventory) {
            Bukkit.getPluginManager().callEvent((Event)new PageCloseEvent((PageInventory)this));
        }
        if (forceClose && (!this.isPlayerInventory() || this.getPlayer().getOpenInventory().getTopInventory().equals(this.currentInventory))) {
            this.getPlayer().closeInventory();
        }
        if (this.isPlayerInventory() && restoreInventory) {
            this.getPlayer().getInventory().clear();
            this.getPlayer().getInventory().setContents(this.previousContents);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    ClickInventory.this.getPlayer().updateInventory();
                }
            });
        }
    }

    public void closeInventory(boolean forceClose) {
        this.closeInventory(forceClose, true);
    }

    public ItemStack getItem(int slot) {
        if (this.isPlayerInventory() && (slot += 9) >= 36) {
            slot -= 36;
        }
        if (this.currentInventory != null && this.currentInventory.getSize() > slot) {
            return this.currentInventory.getItem(slot);
        }
        return null;
    }

    protected void setItems(ItemStack[] items) {
        if (this.isPlayerInventory()) {
            for (int i = 0; i < items.length; ++i) {
                this.setItem(i, items[i]);
            }
        } else {
            this.currentInventory.setContents(items);
        }
    }

    protected void setItem(int slot, ItemStack item) {
        if (this.isPlayerInventory() && (slot += 9) >= 36) {
            slot -= 36;
        }
        this.currentInventory.setItem(slot, item);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isInventoryInUse() {
        return this.inventoryInUse;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    protected void openInv() {
        boolean isSwitchingInventory = this.isInventoryInUse();
        ItemStack heldItem = null;
        ClickInventory[] invs = new ClickInventory[2];
        for (String inv : new String[]{"PageInventory", "NamedInventory", "AnvilInventory"}) {
            Object[] invss;
            if (!this.getPlayer().hasMetadata(inv) || (invss = (Object[])(this.getPlayer().hasMetadata(inv) ? ((MetadataValue)this.getPlayer().getMetadata(inv).get(0)).value() : null)) == null) continue;
            for (int i = 0; i < 2; ++i) {
                if (invss[i] == null) continue;
                invs[i] = (ClickInventory)invss[i];
            }
        }
        if (!this.isPlayerInventory()) {
            this.inventoryInUse = false;
            boolean previous = false;
            if (invs[1] != null) {
                previous = invs[1].inventoryInUse;
                invs[1].inventoryInUse = false;
            }
            if (isSwitchingInventory) {
                heldItem = this.getPlayer().getItemOnCursor();
                this.getPlayer().setItemOnCursor(new ItemStack(Material.AIR));
            }
            try {
                Object player = this.getPlayer().getClass().getDeclaredMethod("getHandle", new Class[0]).invoke((Object)this.getPlayer(), new Object[0]);
                Class<?> c = Class.forName(player.getClass().getName().replace("Player", "Human"));
                Object defaultContainer = c.getField("defaultContainer").get(player);
                Field activeContainer = c.getField("activeContainer");
                if (activeContainer.get(player) == defaultContainer) {
                    if (!(this instanceof AnvilInventory)) {
                        this.getPlayer().openInventory(this.currentInventory);
                    }
                } else {
                    Class.forName("org.bukkit.craftbukkit." + c.getName().split("\\.")[3] + ".event.CraftEventFactory").getMethod("handleInventoryCloseEvent", c).invoke(null, player);
                    activeContainer.set(player, defaultContainer);
                    if (!(this instanceof AnvilInventory)) {
                        this.getPlayer().openInventory(this.currentInventory);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (invs[1] != null) {
                invs[1].inventoryInUse = previous;
            }
        } else {
            this.getPlayer().updateInventory();
            if (!isSwitchingInventory && this.getPlayer().getOpenInventory().getTopInventory().getHolder() == this.getPlayer()) {
                this.getPlayer().openInventory(Bukkit.createInventory(null, (int)0, (String)this.getTitle()));
            }
        }
        if (!isSwitchingInventory) {
            int slot;
            InventoryApi.registerInventory(this);
            int n = slot = this.isPlayerInventory() ? 1 : 0;
            if (invs[slot] != null) {
                if (invs[slot].inventoryInUse) {
                    invs[slot].closeInventory(false, false);
                }
                if (this.isPlayerInventory()) {
                    this.previousContents = invs[1].previousContents;
                }
            }
            Object[] inv = this.getPlayer().hasMetadata(this.getClass().getSimpleName()) ? ((MetadataValue)this.getPlayer().getMetadata(this.getClass().getSimpleName()).get(0)).value() : (Object[])Array.newInstance(this.getClass(), 2);
            inv[slot] = this;
            this.getPlayer().setMetadata(this.getClass().getSimpleName(), (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)inv));
        } else if (heldItem != null && heldItem.getType() != Material.AIR) {
            this.getPlayer().setItemOnCursor(heldItem);
            this.getPlayer().updateInventory();
        }
        this.inventoryInUse = true;
    }

    public abstract String getTitle();

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public abstract void setTitle(String var1);
}

