/*
 * Decompiled with CFR 0.152.
 */
package es.pollitoyeye.InventoriesPerWorld;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventoriesPerWorld
extends JavaPlugin
implements Listener {
    HashMap<String, String> worldGroup = new HashMap();
    FileConfiguration playersConfig;
    File configFile;

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        for (String key : this.getConfig().getKeys(false)) {
            for (String world : this.getConfig().getStringList(key)) {
                this.worldGroup.put(world, key);
                System.out.println("[worldInventories] " + key + ">> " + world);
            }
        }
        this.configFile = new File("PlayerInventories.yml");
        this.playersConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (!this.configFile.exists()) {
            try {
                this.playersConfig.save(this.configFile);
            }
            catch (IOException e) {
                System.out.println("[worldInventories] Error loading configuration");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void teleport(PlayerTeleportEvent event) {
        String worldGroupTo;
        String worldGroupFrom;
        if (!event.isCancelled() && !(worldGroupFrom = this.worldGroup.get(event.getFrom().getWorld().getName())).equals(worldGroupTo = this.worldGroup.get(event.getTo().getWorld().getName()))) {
            Player p = event.getPlayer();
            PlayerInventory pinv = p.getInventory();
            event.setCancelled(true);
            try {
                Inventory inv = Bukkit.createInventory(null, (int)54);
                inv.setContents(pinv.getContents());
                inv.setItem(50, pinv.getHelmet());
                inv.setItem(51, pinv.getChestplate());
                inv.setItem(52, pinv.getLeggings());
                inv.setItem(53, pinv.getBoots());
                this.saveInventory(p, worldGroupFrom, inv);
            }
            catch (IOException e1) {
                p.sendMessage(ChatColor.RED + "Error teleporting (Saving inventory)");
                e1.printStackTrace();
                return;
            }
            try {
                this.setInventory(p, worldGroupTo);
            }
            catch (IOException e) {
                p.sendMessage(ChatColor.RED + "Error teleporting (Reading Inventory)");
                e.printStackTrace();
                return;
            }
            event.setCancelled(false);
        }
    }

    public static String toBase64(Inventory inventory) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            int i = 0;
            while (i < inventory.getSize()) {
                dataOutput.writeObject((Object)inventory.getItem(i));
                ++i;
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static Inventory fromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            int i = 0;
            while (i < inventory.getSize()) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
                ++i;
            }
            dataInput.close();
            return inventory;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public void saveInventory(Player p, String worldGroup, Inventory inv) throws IOException {
        this.playersConfig.set(String.valueOf(p.getUniqueId().toString()) + "." + worldGroup, (Object)InventoriesPerWorld.toBase64(inv));
        this.playersConfig.save(this.configFile);
    }

    public void setInventory(Player p, String worldGroup) throws IOException {
        String path = String.valueOf(p.getUniqueId().toString()) + "." + worldGroup;
        if (this.playersConfig.contains(path)) {
            String toRead = this.playersConfig.get(path).toString();
            Inventory inv = InventoriesPerWorld.fromBase64(toRead);
            p.getInventory().clear();
            ItemStack[] contents = new ItemStack[36];
            int i = 0;
            while (i < 36) {
                contents[i] = inv.getItem(i);
                ++i;
            }
            p.getInventory().setContents(contents);
            p.getInventory().setHelmet(inv.getItem(50));
            p.getInventory().setChestplate(inv.getItem(51));
            p.getInventory().setLeggings(inv.getItem(52));
            p.getInventory().setBoots(inv.getItem(53));
            p.updateInventory();
        } else {
            p.getInventory().clear();
            p.getInventory().setChestplate(new ItemStack(Material.AIR));
            p.getInventory().setLeggings(new ItemStack(Material.AIR));
            p.getInventory().setBoots(new ItemStack(Material.AIR));
            p.getInventory().setHelmet(new ItemStack(Material.AIR));
            p.updateInventory();
        }
    }
}

