/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.objectholders.Condition;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SyncUtils {
    public static <T> T executeSync(Callable<T> task, long timeout, T def) {
        if (Bukkit.isPrimaryThread()) {
            try {
                return task.call();
            }
            catch (Exception e) {
                return def;
            }
        }
        if (InteractionVisualizer.plugin.isEnabled()) {
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)InteractionVisualizer.plugin, task);
            try {
                return (T)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return def;
            }
        }
        return def;
    }

    public static void runAsyncWithSyncCondition(Condition syncCondition, long timeout, Runnable asyncTask) {
        if (SyncUtils.executeSync(() -> syncCondition.check(), timeout, false).booleanValue() && InteractionVisualizer.plugin.isEnabled()) {
            InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(asyncTask);
        }
    }
}

