/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import java.lang.reflect.AccessibleObject;
import org.bukkit.Bukkit;

public class NMSUtils {
    public static Class<?> getNMSClass(String path, String ... paths) throws ClassNotFoundException {
        String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        ClassNotFoundException error = null;
        try {
            return Class.forName(path.replace("%s", version));
        }
        catch (ClassNotFoundException e) {
            error = e;
            for (String classpath : paths) {
                try {
                    return Class.forName(classpath.replace("%s", version));
                }
                catch (ClassNotFoundException e2) {
                    error = e2;
                }
            }
            throw error;
        }
    }

    @SafeVarargs
    public static <T extends AccessibleObject> T reflectiveLookup(Class<T> lookupType, ReflectionLookupSupplier<T> methodLookup, ReflectionLookupSupplier<T> ... methodLookups) throws ReflectiveOperationException {
        ReflectiveOperationException error = null;
        try {
            return (T)((AccessibleObject)methodLookup.lookup());
        }
        catch (ReflectiveOperationException e) {
            error = e;
            for (ReflectionLookupSupplier<T> supplier : methodLookups) {
                try {
                    return (T)((AccessibleObject)supplier.lookup());
                }
                catch (ReflectiveOperationException e2) {
                    error = e2;
                }
            }
            throw error;
        }
    }

    @FunctionalInterface
    public static interface ReflectionLookupSupplier<T> {
        public T lookup() throws ReflectiveOperationException;
    }
}

