/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.objectholders.BlockPosition;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.utils.BoundingBoxUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class LineOfSightUtils {
    public static boolean hasLineOfSight(Location from, Location to) {
        return LineOfSightUtils.hasLineOfSight(from, to, 0.01);
    }

    public static boolean hasLineOfSight(Location from, Location to, double accuracy) {
        if (!from.getWorld().equals(to.getWorld())) {
            return false;
        }
        Vector direction = to.toVector().subtract(from.toVector()).normalize();
        double distance = from.distance(to);
        LinkedHashMap<BlockPosition, ArrayList<Location>> blocks = new LinkedHashMap<BlockPosition, ArrayList<Location>>();
        for (double d = 0.0; d <= distance; d += accuracy) {
            Location pos = from.clone().add(direction.clone().multiply(d));
            BlockPosition blockPos = new BlockPosition(pos);
            ArrayList<Location> list = (ArrayList<Location>)blocks.get(blockPos);
            if (list == null) {
                list = new ArrayList<Location>();
                blocks.put(blockPos, list);
            }
            list.add(pos);
        }
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPosition blockPos = (BlockPosition)entry.getKey();
            List pos = (List)entry.getValue();
            if (!blockPos.getWorld().isChunkLoaded(blockPos.getX() >> 4, blockPos.getZ() >> 4)) continue;
            List<BoundingBox> box = BoundingBoxUtils.getBoundingBoxes(blockPos);
            Material type = blockPos.getBlock().getType();
            if (type.isTransparent() || type.toString().contains("GLASS") || InteractionVisualizer.exemptBlocks.contains(type.toString())) continue;
            for (Location point : pos) {
                if (!box.stream().anyMatch(each -> each.contains(point.getX(), point.getY(), point.getZ()))) continue;
                return false;
            }
        }
        return true;
    }
}

