/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventoryUtils {
    public static boolean compareContents(Inventory first, Inventory second) {
        int size = Math.max(first.getSize(), second.getSize());
        for (int i = 0; i < size; ++i) {
            ItemStack secondItem;
            ItemStack firstItem = i < first.getSize() ? first.getItem(i) : null;
            ItemStack itemStack = secondItem = i < second.getSize() ? second.getItem(i) : null;
            if (firstItem != null && firstItem.getType().equals((Object)Material.AIR)) {
                firstItem = null;
            }
            if (secondItem != null && secondItem.getType().equals((Object)Material.AIR)) {
                secondItem = null;
            }
            if (firstItem == null && secondItem != null) {
                return false;
            }
            if (secondItem == null && firstItem != null) {
                return false;
            }
            if (firstItem == null || secondItem == null || firstItem.isSimilar(secondItem) && firstItem.getAmount() == secondItem.getAmount()) continue;
            return false;
        }
        return true;
    }

    public static boolean stillHaveSpace(Inventory inv, Material material) {
        int size = inv.getSize();
        if (inv instanceof PlayerInventory) {
            size = 36;
        }
        for (int i = 0; i < size; ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null) {
                return true;
            }
            if (item.getType().equals((Object)Material.AIR)) {
                return true;
            }
            if (!item.getType().equals((Object)material) || item.getAmount() >= item.getType().getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public static String toBase64(Inventory inventory) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                dataOutput.writeObject((Object)inventory.getItem(i));
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static Inventory fromBase64(String data, String title) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = null;
            inventory = title.equals("") ? Bukkit.getServer().createInventory(null, dataInput.readInt()) : Bukkit.getServer().createInventory(null, dataInput.readInt(), title);
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
            }
            dataInput.close();
            return inventory;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }
}

