/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.protocol;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.utils.LanguageUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Entity;

public class WatchableCollection {
    private static final MCVersion version = InteractionVisualizer.version;
    private static final Integer metaversion = InteractionVisualizer.metaversion;
    private static WrappedDataWatcher.Serializer booleanSerializer;
    private static WrappedDataWatcher.Serializer stringSerializer;
    private static WrappedDataWatcher.Serializer byteSerializer;
    private static WrappedDataWatcher.Serializer intSerializer;
    private static WrappedDataWatcher.Serializer itemSerializer;
    private static WrappedDataWatcher.Serializer optChatSerializer;
    private static WrappedDataWatcher.Serializer vectorSerializer;

    public static void setup() {
        booleanSerializer = WrappedDataWatcher.Registry.get(Boolean.class);
        stringSerializer = WrappedDataWatcher.Registry.get(String.class);
        byteSerializer = WrappedDataWatcher.Registry.get(Byte.class);
        intSerializer = WrappedDataWatcher.Registry.get(Integer.class);
        itemSerializer = WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false);
        if (!version.isLegacy()) {
            optChatSerializer = WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true);
        }
        vectorSerializer = WrappedDataWatcher.Registry.getVectorSerializer();
    }

    public static WrappedDataWatcher getWatchableCollection(ArmorStand stand, WrappedDataWatcher watcher) {
        if (watcher == null) {
            watcher = new WrappedDataWatcher();
        }
        byte bitmask = 0;
        bitmask = !stand.isVisible() ? (byte)(bitmask | 0x20) : bitmask;
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, byteSerializer), (Object)bitmask);
        switch (metaversion) {
            case 0: {
                if (stand.getCustomName() != null && !PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals("")) {
                    watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)LegacyComponentSerializer.legacySection().serialize(LanguageUtils.convert(stand.getCustomName(), InteractionVisualizer.language)));
                    break;
                }
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)"");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (stand.getCustomName() != null && !PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals("")) {
                    watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, optChatSerializer), Optional.of(WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(stand.getCustomName()))).getHandle()));
                    break;
                }
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, optChatSerializer), Optional.empty());
            }
        }
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, booleanSerializer), (Object)stand.isCustomNameVisible());
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(4, booleanSerializer), (Object)stand.isSilent());
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(5, booleanSerializer), (Object)(!stand.hasGravity() ? 1 : 0));
        byte standbitmask = 0;
        standbitmask = stand.isSmall() ? (byte)(standbitmask | 1) : standbitmask;
        standbitmask = stand.hasArms() ? (byte)(standbitmask | 4) : standbitmask;
        standbitmask = !stand.hasBasePlate() ? (byte)(standbitmask | 8) : standbitmask;
        standbitmask = stand.isMarker() ? (byte)(standbitmask | 0x10) : standbitmask;
        switch (metaversion) {
            case 0: 
            case 1: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(11, byteSerializer), (Object)standbitmask);
                break;
            }
            case 2: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(13, byteSerializer), (Object)standbitmask);
                break;
            }
            case 3: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(14, byteSerializer), (Object)standbitmask);
                break;
            }
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, byteSerializer), (Object)standbitmask);
            }
        }
        Vector3F headrotation = new Vector3F();
        headrotation.setX((float)Math.toDegrees(stand.getHeadPose().getX()));
        headrotation.setY((float)Math.toDegrees(stand.getHeadPose().getY()));
        headrotation.setZ((float)Math.toDegrees(stand.getHeadPose().getZ()));
        switch (metaversion) {
            case 0: 
            case 1: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(12, vectorSerializer), (Object)headrotation);
                break;
            }
            case 2: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(14, vectorSerializer), (Object)headrotation);
                break;
            }
            case 3: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, vectorSerializer), (Object)headrotation);
                break;
            }
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(16, vectorSerializer), (Object)headrotation);
            }
        }
        Vector3F rightarmrotation = new Vector3F();
        rightarmrotation.setX((float)Math.toDegrees(stand.getRightArmPose().getX()));
        rightarmrotation.setY((float)Math.toDegrees(stand.getRightArmPose().getY()));
        rightarmrotation.setZ((float)Math.toDegrees(stand.getRightArmPose().getZ()));
        switch (metaversion) {
            case 0: 
            case 1: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, vectorSerializer), (Object)rightarmrotation);
                break;
            }
            case 2: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(17, vectorSerializer), (Object)rightarmrotation);
                break;
            }
            case 3: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(18, vectorSerializer), (Object)rightarmrotation);
                break;
            }
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(19, vectorSerializer), (Object)rightarmrotation);
            }
        }
        return watcher;
    }

    public static WrappedDataWatcher getWatchableCollection(Item item, WrappedDataWatcher watcher) {
        if (watcher == null) {
            watcher = new WrappedDataWatcher();
        }
        byte bitmask = 0;
        bitmask = item.isGlowing() ? (byte)(bitmask | 0x40) : bitmask;
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, byteSerializer), (Object)bitmask);
        switch (metaversion) {
            case 0: {
                if (item.getCustomName() != null && !PlainTextComponentSerializer.plainText().serialize(item.getCustomName()).equals("")) {
                    watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)LegacyComponentSerializer.legacySection().serialize(LanguageUtils.convert(item.getCustomName(), InteractionVisualizer.language)));
                    break;
                }
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)"");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (item.getCustomName() != null && !PlainTextComponentSerializer.plainText().serialize(item.getCustomName()).equals("")) {
                    watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, optChatSerializer), Optional.of(WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(item.getCustomName()))).getHandle()));
                    break;
                }
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, optChatSerializer), Optional.empty());
            }
        }
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, booleanSerializer), (Object)item.isCustomNameVisible());
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(5, booleanSerializer), (Object)(!item.hasGravity() ? 1 : 0));
        switch (metaversion) {
            case 0: 
            case 1: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(6, itemSerializer), (Object)item.getItemStack());
                break;
            }
            case 2: 
            case 3: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(7, itemSerializer), (Object)item.getItemStack());
                break;
            }
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, itemSerializer), (Object)item.getItemStack());
            }
        }
        return watcher;
    }

    public static WrappedDataWatcher getWatchableCollection(ItemFrame frame, WrappedDataWatcher watcher) {
        if (watcher == null) {
            watcher = new WrappedDataWatcher();
        }
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(4, booleanSerializer), (Object)frame.isSilent());
        switch (metaversion) {
            case 0: 
            case 1: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(6, itemSerializer), (Object)frame.getItem());
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(7, intSerializer), (Object)frame.getFrameRotation());
                break;
            }
            case 2: 
            case 3: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(7, itemSerializer), (Object)frame.getItem());
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, intSerializer), (Object)frame.getFrameRotation());
                break;
            }
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, itemSerializer), (Object)frame.getItem());
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(9, intSerializer), (Object)frame.getFrameRotation());
            }
        }
        return watcher;
    }

    public static WrappedDataWatcher createCustomNameWatchableCollection(Component name, WrappedDataWatcher watcher) {
        boolean visible;
        if (watcher == null) {
            watcher = new WrappedDataWatcher();
        }
        try {
            visible = name != null && !PlainTextComponentSerializer.plainText().serialize(name).equals("");
        }
        catch (Exception e) {
            visible = false;
        }
        switch (metaversion) {
            case 0: {
                if (visible) {
                    watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)LegacyComponentSerializer.legacySection().serialize(LanguageUtils.convert(name, InteractionVisualizer.language)));
                    break;
                }
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, stringSerializer), (Object)"");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, optChatSerializer), Optional.of(WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(name))).getHandle()));
            }
        }
        watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, booleanSerializer), (Object)visible);
        return watcher;
    }

    public static WrappedDataWatcher resetCustomNameWatchableCollection(Entity entity, WrappedDataWatcher watcher) {
        WrappedDataWatcher entityWatcher = WrappedDataWatcher.getEntityWatcher((Entity)entity);
        if (watcher == null) {
            watcher = new WrappedDataWatcher();
        }
        WrappedWatchableObject name = entityWatcher.getWatchableObject(2);
        watcher.setObject(name.getWatcherObject(), name.getValue());
        WrappedWatchableObject visible = entityWatcher.getWatchableObject(3);
        watcher.setObject(visible.getWatcherObject(), visible.getValue());
        return watcher;
    }

    public static WrappedDataWatcher fromDataValueList(List<WrappedDataValue> dataValues) {
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        for (WrappedDataValue dataValue : dataValues) {
            watcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(dataValue.getIndex(), dataValue.getSerializer()), dataValue.getRawValue());
        }
        return watcher;
    }

    public static List<WrappedDataValue> toDataValueList(WrappedDataWatcher wrappedDataWatcher) {
        List watchableObjectList = wrappedDataWatcher.getWatchableObjects();
        ArrayList<WrappedDataValue> wrappedDataValues = new ArrayList<WrappedDataValue>(watchableObjectList.size());
        for (WrappedWatchableObject wrappedWatchableObject : wrappedDataWatcher.getWatchableObjects()) {
            WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject = wrappedWatchableObject.getWatcherObject();
            wrappedDataValues.add(new WrappedDataValue(wrappedDataWatcherObject.getIndex(), wrappedDataWatcherObject.getSerializer(), wrappedWatchableObject.getRawValue()));
        }
        return wrappedDataValues;
    }

    public static WrappedDataWatcher fromMetadataPacket(PacketContainer packet) {
        if (InteractionVisualizer.version.isNewerOrEqualTo(MCVersion.V1_19_3)) {
            List data = (List)packet.getDataValueCollectionModifier().read(0);
            return WatchableCollection.fromDataValueList(data);
        }
        List data = (List)packet.getWatchableCollectionModifier().read(0);
        return new WrappedDataWatcher(data);
    }

    public static void writeMetadataPacket(PacketContainer packet, WrappedDataWatcher watcher) {
        if (InteractionVisualizer.version.isNewerOrEqualTo(MCVersion.V1_19_3)) {
            packet.getDataValueCollectionModifier().write(0, WatchableCollection.toDataValueList(watcher));
        } else {
            WatchableCollection.writeMetadataPacket(packet, watcher);
        }
    }
}

