/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SynchronizedFilteredCollection<E>
implements Collection<E> {
    private final Collection<E> backingCollection;
    private final Predicate<E> predicate;
    private final Object lock;

    public static <E> SynchronizedFilteredCollection<E> filterSynchronized(Collection<E> backingCollection, Predicate<E> predicate) {
        return new SynchronizedFilteredCollection<E>(backingCollection, predicate);
    }

    private SynchronizedFilteredCollection(Collection<E> backingCollection, Predicate<E> predicate) {
        this.backingCollection = backingCollection;
        this.predicate = predicate;
        this.lock = this.aquireLock();
    }

    private Object aquireLock() {
        if (this.backingCollection instanceof SynchronizedFilteredCollection) {
            return ((SynchronizedFilteredCollection)this.backingCollection).aquireLock();
        }
        return this.backingCollection;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return (int)Math.min(this.backingCollection.stream().filter(this.predicate).count(), Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).count() <= 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).anyMatch(each -> Objects.equals(each, o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new Iterator<E>(){
                private final Iterator<E> itr;
                private E currentElement;
                {
                    this.itr = SynchronizedFilteredCollection.this.backingCollection.stream().filter(SynchronizedFilteredCollection.this.predicate).collect(Collectors.toList()).iterator();
                    this.currentElement = null;
                }

                @Override
                public boolean hasNext() {
                    return this.itr.hasNext();
                }

                @Override
                public E next() {
                    this.currentElement = this.itr.next();
                    return this.currentElement;
                }

                @Override
                public void remove() {
                    if (this.currentElement == null) {
                        throw new IllegalStateException("Call itr.next() first");
                    }
                    SynchronizedFilteredCollection.this.backingCollection.remove(this.currentElement);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).toArray((int size) -> a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size));
        }
    }

    @Override
    public boolean add(E e) {
        if (this.predicate.test(e)) {
            return this.backingCollection.add(e);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.backingCollection.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.lock;
        synchronized (object) {
            Collection list = this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList());
            for (Object o : c) {
                if (list.contains(o)) continue;
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean flag = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backingCollection.removeAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Predicate<E> test = this.predicate.and(filter);
        boolean flag = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator<E> itr = this.backingCollection.iterator();
            while (itr.hasNext()) {
                E e = itr.next();
                if (!test.test(e)) continue;
                itr.remove();
                flag = true;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean flag = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator<E> itr = this.backingCollection.iterator();
            while (itr.hasNext()) {
                E e = itr.next();
                if (!this.predicate.test(e) || c.contains(e)) continue;
                itr.remove();
                flag = true;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<E> itr = this.backingCollection.iterator();
            while (itr.hasNext()) {
                E e = itr.next();
                if (!this.predicate.test(e)) continue;
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> spliterator() {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList()).spliterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> stream() {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.stream().filter(this.predicate).collect(Collectors.toList()).stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> parallelStream() {
        Object object = this.lock;
        synchronized (object) {
            return this.backingCollection.parallelStream().filter(this.predicate).collect(Collectors.toList()).parallelStream();
        }
    }
}

