/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import com.loohp.interactionvisualizer.objectholders.TileEntity;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NMSTileEntitySet<K, V>
implements Set<TileEntity> {
    private final Map<K, V> nmsTileEntities;
    private final Function<Map.Entry<K, V>, TileEntity> converter;

    public NMSTileEntitySet(Map<K, V> nmsTileEntities, Function<Map.Entry<K, V>, TileEntity> converter) {
        this.nmsTileEntities = nmsTileEntities;
        this.converter = converter;
    }

    @Override
    public Iterator<TileEntity> iterator() {
        return new Iterator<TileEntity>(){
            private final Iterator<Map.Entry<K, V>> itr;
            {
                this.itr = NMSTileEntitySet.this.nmsTileEntities.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public TileEntity next() {
                return (TileEntity)NMSTileEntitySet.this.converter.apply(this.itr.next());
            }
        };
    }

    public Map<K, V> getHandle() {
        return this.nmsTileEntities;
    }

    public Function<Map.Entry<K, V>, TileEntity> getConverter() {
        return this.converter;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.nmsTileEntities.entrySet().stream().map(this.converter).toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        a = a.length < this.nmsTileEntities.size() ? (Object[])Array.newInstance(a.getClass().getComponentType(), this.nmsTileEntities.size()) : a;
        int i = 0;
        for (Map.Entry<K, V> entry : this.nmsTileEntities.entrySet()) {
            a[i++] = this.converter.apply(entry);
        }
        return a;
    }

    @Override
    public boolean add(TileEntity tileEntity) {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        Set set = this.nmsTileEntities.entrySet().stream().map(this.converter).collect(Collectors.toSet());
        return set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends TileEntity> c) {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("NMSTileEntitySet is read only!");
    }

    @Override
    public int size() {
        return this.nmsTileEntities.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nmsTileEntities.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nmsTileEntities.entrySet().stream().map(this.converter).anyMatch(each -> each.equals(o));
    }
}

