/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import com.loohp.interactionvisualizer.objectholders.LightType;
import com.loohp.interactionvisualizer.utils.LocationUtils;
import org.bukkit.Location;

public class LightData {
    private final Location location;
    private final int lightLevel;
    private final LightType lightType;

    public static LightData of(Location location) {
        return LightData.of(location, 0, null);
    }

    public static LightData of(Location location, LightType lightType) {
        return LightData.of(location, 0, lightType);
    }

    public static LightData of(Location location, int lightlevel, LightType lightType) {
        return new LightData(location, lightlevel, lightType);
    }

    private LightData(Location location, int lightlevel, LightType lightType) {
        this.location = location;
        this.lightType = lightType;
        this.lightLevel = lightlevel;
    }

    public Location getLocation() {
        return this.location;
    }

    public LightType getLightType() {
        return this.lightType;
    }

    public boolean hasLightType() {
        return this.lightType != null;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public boolean isLocationLoaded() {
        return LocationUtils.isLoaded(this.location);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lightLevel;
        result = 31 * result + (this.lightType == null ? 0 : this.lightType.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightData other = (LightData)obj;
        if (this.lightLevel != other.lightLevel) {
            return false;
        }
        if (this.lightType != other.lightType) {
            return false;
        }
        if (this.location == null) {
            return other.location == null;
        }
        return this.location.equals((Object)other.location);
    }
}

