/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;

public class EntryKey {
    public static final Pattern VALIDATE = Pattern.compile("^[a-z0-9_]*$");
    public static final String NATIVE = "interactionvisualizer";
    private final String namespace;
    private final String key;

    public EntryKey(String namespacedKey) {
        int index = namespacedKey.indexOf(":");
        if (index >= 0) {
            this.namespace = namespacedKey.substring(0, index);
            this.key = namespacedKey.substring(index + 1);
        } else {
            this.namespace = NATIVE;
            this.key = namespacedKey;
        }
        if (!VALIDATE.matcher(this.namespace).matches() || !VALIDATE.matcher(this.key).matches()) {
            throw new IllegalArgumentException("Invalid EntryKey, an EntryKey may only contain " + VALIDATE.pattern());
        }
    }

    public EntryKey(String namespace, String key) {
        this.namespace = namespace;
        this.key = key;
        if (!VALIDATE.matcher(namespace).matches() || !VALIDATE.matcher(key).matches()) {
            throw new IllegalArgumentException("Invalid EntryKey, an EntryKey may only contain " + VALIDATE.pattern());
        }
    }

    public EntryKey(Plugin plugin, String key) {
        this.namespace = plugin.getName().toLowerCase();
        this.key = key;
        if (!VALIDATE.matcher(this.namespace).matches() || !VALIDATE.matcher(key).matches()) {
            throw new IllegalArgumentException("Invalid EntryKey, an EntryKey can only contain " + VALIDATE.pattern());
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isNative() {
        return this.namespace.equals(NATIVE);
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public String toSimpleString() {
        return this.isNative() ? this.key : this.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.namespace.hashCode();
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntryKey other = (EntryKey)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }
}

