/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.blocks.EnchantmentTableDisplay;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import com.loohp.interactionvisualizer.utils.CustomStringUtils;
import com.loohp.interactionvisualizer.utils.RomanNumberUtils;
import com.loohp.interactionvisualizer.utils.TranslationUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EnchantmentTableAnimation {
    public static final EntryKey KEY = new EntryKey("enchantment_table");
    public static final int SET_ITEM = 0;
    public static final int PLAY_ENCHANTMENT = 1;
    public static final int PLAY_PICKUP = 2;
    public static final int CLOSE_TABLE = 3;
    private static final Map<Block, EnchantmentTableAnimation> tables = new ConcurrentHashMap<Block, EnchantmentTableAnimation>();
    private final Plugin plugin = InteractionVisualizer.plugin;
    private final Block block;
    private final Location location;
    private final Player enchanter;
    private final Queue<Supplier<CompletableFuture<Integer>>> taskQueue;
    private final AtomicBoolean enchanting;
    private Optional<Item> item;

    public static EnchantmentTableAnimation getTableAnimation(Block block, Player player) {
        EnchantmentTableAnimation animation = tables.get(block);
        if (animation == null) {
            animation = new EnchantmentTableAnimation(block, player);
            tables.put(block, animation);
            return animation;
        }
        if (animation.getEnchanter().equals(player)) {
            return animation;
        }
        return null;
    }

    private EnchantmentTableAnimation(Block block, Player enchanter) {
        this.block = block;
        this.enchanter = enchanter;
        this.location = block.getLocation().clone();
        this.item = Optional.empty();
        this.enchanting = new AtomicBoolean(false);
        this.taskQueue = new ConcurrentLinkedQueue<Supplier<CompletableFuture<Integer>>>();
        this.tick();
    }

    private void tick() {
        InteractionVisualizer.asyncExecutorManager.runTaskLaterAsynchronously(() -> this.run(), 1L);
    }

    private void run() {
        Supplier<CompletableFuture<Integer>> task = this.taskQueue.poll();
        if (task != null) {
            int result = -1;
            try {
                CompletableFuture<Integer> future = task.get();
                if (future == null) {
                    this.run();
                    return;
                }
                result = future.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result != 3) {
                this.tick();
            } else {
                tables.remove(this.block);
            }
        } else {
            this.tick();
        }
    }

    private CompletableFuture<Integer> playEnchantAnimation(Map<Enchantment, Integer> enchantsToAdd, Integer expCost, ItemStack itemstack) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        if (this.item.isPresent() && this.item.get().isLocked()) {
            future.complete(1);
            return future;
        }
        this.enchanting.set(true);
        if (!this.item.isPresent()) {
            this.item = Optional.of(new Item(this.location.clone().add(0.5, 1.3, 0.5)));
            PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), this.item.get());
        }
        Item item = this.item.get();
        item.setItemStack(itemstack);
        item.setGravity(false);
        item.setLocked(true);
        item.setVelocity(new Vector(0.0, 0.05, 0.0));
        PacketManager.updateItem(item);
        for (Player each : InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY)) {
            each.spawnParticle(Particle.PORTAL, this.location.clone().add(0.5, 2.6, 0.5), 200);
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            item.teleport(this.location.clone().add(0.5, 2.3, 0.5));
            item.setVelocity(new Vector(0, 0, 0));
            PacketManager.updateItem(item);
        }, 20L);
        LinkedList stands = new LinkedList();
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            Location standloc = item.getLocation().add(0.0, 0.5, 0.0);
            for (Map.Entry entry : enchantsToAdd.entrySet()) {
                boolean isTranslatable;
                Enchantment ench = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                String str = TranslationUtils.getEnchantment(ench);
                if (!EnchantmentTableDisplay.getTranslatableEnchantments().contains(str)) {
                    Map<String, String> definedNames = EnchantmentTableDisplay.getCustomDefinedEnchantmentNames();
                    str = definedNames.get(EnchantmentTableDisplay.getEnchantmentIdOrKey(ench));
                    isTranslatable = false;
                } else {
                    isTranslatable = true;
                }
                Component enchantmentName = isTranslatable ? Component.translatable(str) : ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(str == null || str.equals("") ? CustomStringUtils.capitalize(ench.getName().toLowerCase().replace("_", " ")) : str));
                ArmorStand stand = new ArmorStand(standloc);
                if (ench.getMaxLevel() != 1 || level != 1) {
                    enchantmentName = enchantmentName.append(ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(" " + ChatColor.AQUA + RomanNumberUtils.toRoman((Integer)entry.getValue()))));
                }
                enchantmentName = ench.isCursed() ? enchantmentName.color(NamedTextColor.RED) : enchantmentName.color(NamedTextColor.AQUA);
                stand.setCustomName(enchantmentName);
                stand.setCustomNameVisible(true);
                this.setStand(stand);
                PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), stand);
                stands.add(stand);
                standloc.add(0.0, 0.3, 0.0);
            }
            ArmorStand stand = new ArmorStand(standloc);
            TranslatableComponent levelTrans = Component.translatable(TranslationUtils.getLevel(expCost));
            if (expCost != 1) {
                levelTrans = levelTrans.args(Component.text(expCost));
            }
            levelTrans = (TranslatableComponent)levelTrans.color(NamedTextColor.GREEN);
            stand.setCustomName(levelTrans);
            stand.setCustomNameVisible(true);
            this.setStand(stand);
            PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), stand);
            stands.add(stand);
            PacketManager.updateItem(item);
        }, 50L);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            while (!stands.isEmpty()) {
                ArmorStand stand = (ArmorStand)stands.remove(0);
                PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
            }
            item.setGravity(true);
            PacketManager.updateItem(item);
        }, 90L);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            item.teleport(this.location.clone().add(0.5, 1.3, 0.5));
            item.setGravity(false);
            PacketManager.updateItem(item);
            item.setLocked(false);
            future.complete(1);
            this.enchanting.set(false);
        }, 98L);
        return future;
    }

    private CompletableFuture<Integer> playPickUpAnimation(ItemStack itemstack) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        if (!this.item.isPresent()) {
            future.complete(2);
            return future;
        }
        Item item = this.item.get();
        item.setLocked(true);
        item.setItemStack(itemstack);
        if (itemstack == null || itemstack.getType().equals((Object)Material.AIR)) {
            future.complete(2);
            return future;
        }
        Vector lift = new Vector(0.0, 0.15, 0.0);
        Vector pickup = this.enchanter.getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector().subtract(this.location.clone().add(0.5, 1.2, 0.5).toVector()).multiply(0.15).add(lift);
        item.setVelocity(pickup);
        item.setGravity(true);
        item.setPickupDelay(Short.MAX_VALUE);
        PacketManager.updateItem(item);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            SoundManager.playItemPickup(item.getLocation(), InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY));
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
            this.item = Optional.empty();
            future.complete(2);
        }, 8L);
        return future;
    }

    private CompletableFuture<Integer> close() {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            if (this.item.isPresent()) {
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), this.item.get());
            }
            future.complete(3);
        });
        return future;
    }

    private CompletableFuture<Integer> setItemStack(ItemStack itemstack) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            if (itemstack == null || itemstack.getType().equals((Object)Material.AIR)) {
                this.clearItemStack();
                future.complete(0);
                return;
            }
            if (this.item.isPresent()) {
                this.item.get().setItemStack(itemstack);
                PacketManager.updateItem(this.item.get());
            } else {
                this.item = Optional.of(new Item(this.location.clone().add(0.5, 1.3, 0.5)));
                this.item.get().setItemStack(itemstack);
                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), this.item.get());
                PacketManager.updateItem(this.item.get());
            }
            future.complete(0);
        });
        return future;
    }

    private void clearItemStack() {
        if (this.item.isPresent()) {
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), this.item.get());
            this.item = Optional.empty();
        }
    }

    private void setStand(ArmorStand stand) {
        stand.setMarker(true);
        stand.setSmall(true);
        stand.setVisible(true);
        stand.setInvulnerable(true);
        stand.setBasePlate(false);
        stand.setVisible(false);
    }

    public ItemStack getItemStack() {
        return this.item.isPresent() ? this.item.get().getItemStack() : null;
    }

    public Player getEnchanter() {
        return this.enchanter;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isEnchanting() {
        return this.enchanting.get();
    }

    public void queueSetItem(ItemStack itemstack, Predicate<EnchantmentTableAnimation> condition) {
        this.taskQueue.add(() -> {
            if (condition.test(this)) {
                return this.setItemStack(itemstack == null ? null : itemstack.clone());
            }
            return null;
        });
    }

    public void queueEnchant(Map<Enchantment, Integer> enchantsToAdd, int expCost, ItemStack itemstack, Predicate<EnchantmentTableAnimation> condition) {
        this.taskQueue.add(() -> {
            if (condition.test(this)) {
                return this.playEnchantAnimation(enchantsToAdd, expCost, itemstack == null ? null : itemstack.clone());
            }
            return null;
        });
    }

    public void queuePickupAnimation(ItemStack itemstack, Predicate<EnchantmentTableAnimation> condition) {
        this.taskQueue.add(() -> {
            if (condition.test(this)) {
                return this.playPickUpAnimation(itemstack == null ? null : itemstack.clone());
            }
            return null;
        });
    }

    public void queueClose(Predicate<EnchantmentTableAnimation> condition) {
        this.taskQueue.add(() -> {
            if (condition.test(this)) {
                return this.close();
            }
            return null;
        });
    }
}

