/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockPosition {
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public BlockPosition(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPosition(Location location) {
        this(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockPosition(Block block) {
        this(block.getWorld(), block.getX(), block.getY(), block.getZ());
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    public Location getLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPosition other = (BlockPosition)obj;
        if (this.world == null ? other.world != null : !this.world.equals(other.world)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

