/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R1.Block;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.EntityItem;
import net.minecraft.server.v1_16_R1.EnumItemSlot;
import net.minecraft.server.v1_16_R1.IBlockAccess;
import net.minecraft.server.v1_16_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R1.VoxelShape;
import net.minecraft.server.v1_16_R1.World;
import net.minecraft.server.v1_16_R1.WorldServer;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class V1_16
extends NMS {
    @Override
    public List<BoundingBox> getBoundingBoxes(com.loohp.interactionvisualizer.objectholders.BlockPosition pos) {
        BlockPosition blockpos = new BlockPosition(pos.getX(), pos.getY(), pos.getZ());
        WorldServer world = ((CraftWorld)pos.getWorld()).getHandle();
        VoxelShape shape = world.getType(blockpos).getShape((IBlockAccess)world, blockpos);
        return shape.d().stream().map(each -> new BoundingBox(each.minX + (double)pos.getX(), each.minY + (double)pos.getY(), each.minZ + (double)pos.getZ(), each.maxX + (double)pos.getX(), each.maxY + (double)pos.getY(), each.maxZ + (double)pos.getZ())).collect(Collectors.toList());
    }

    @Override
    public NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition chunk, boolean load) {
        if (!chunk.isLoaded() && !load) {
            return null;
        }
        org.bukkit.World world = chunk.getWorld();
        return new NMSTileEntitySet(((CraftChunk)chunk.getChunk()).getHandle().tileEntities, entry -> {
            BlockPosition pos = (BlockPosition)entry.getKey();
            Material type = CraftMagicNumbers.getMaterial((Block)((net.minecraft.server.v1_16_R1.TileEntity)entry.getValue()).getBlock().getBlock());
            TileEntity.TileEntityType tileEntityType = TileEntity.getTileEntityType(type);
            if (tileEntityType != null) {
                return new TileEntity(world, pos.getX(), pos.getY(), pos.getZ(), tileEntityType);
            }
            return null;
        });
    }

    @Override
    public PacketContainer[] createEntityEquipmentPacket(int entityId, List<ValuePairs<EquipmentSlot, ItemStack>> equipments) {
        ArrayList<Pair> nmsList = new ArrayList<Pair>();
        for (ValuePairs<EquipmentSlot, ItemStack> pair : equipments) {
            EnumItemSlot nmsSlot;
            switch (pair.getFirst()) {
                case CHEST: {
                    nmsSlot = EnumItemSlot.CHEST;
                    break;
                }
                case FEET: {
                    nmsSlot = EnumItemSlot.FEET;
                    break;
                }
                case HEAD: {
                    nmsSlot = EnumItemSlot.HEAD;
                    break;
                }
                case LEGS: {
                    nmsSlot = EnumItemSlot.LEGS;
                    break;
                }
                case OFF_HAND: {
                    nmsSlot = EnumItemSlot.OFFHAND;
                    break;
                }
                default: {
                    nmsSlot = EnumItemSlot.MAINHAND;
                }
            }
            net.minecraft.server.v1_16_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)pair.getSecond());
            nmsList.add(new Pair((Object)nmsSlot, (Object)nmsItem));
        }
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(entityId, nmsList);
        return new PacketContainer[]{PacketContainer.fromPacket((Object)packet)};
    }

    @Override
    public int getItemDespawnRate(Item item) {
        int despawnRate;
        try {
            Object spigotWorldConfig = World.class.getField("spigotConfig").get(((CraftWorld)item.getWorld()).getHandle());
            despawnRate = spigotWorldConfig.getClass().getField("itemDespawnRate").getInt(spigotWorldConfig);
            try {
                despawnRate = (Integer)EntityItem.class.getMethod("getDespawnRate", new Class[0]).invoke((Object)((CraftItem)item).getHandle(), new Object[0]);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            despawnRate = 6000;
        }
        return despawnRate;
    }

    @Override
    public String getBannerCustomName(org.bukkit.block.Block block) {
        return ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ())).b().getString("CustomName");
    }

    @Override
    public WrappedIterable<?, Entity> getEntities(org.bukkit.World world) {
        return new WrappedIterable<net.minecraft.server.v1_16_R1.Entity, Entity>((Iterable<net.minecraft.server.v1_16_R1.Entity>)((CraftWorld)world).getHandle().entitiesById.values(), entry -> entry.getBukkitEntity());
    }
}

