/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.v1_13_R1.Block;
import net.minecraft.server.v1_13_R1.BlockPosition;
import net.minecraft.server.v1_13_R1.EntityItem;
import net.minecraft.server.v1_13_R1.IBlockAccess;
import net.minecraft.server.v1_13_R1.VoxelShape;
import net.minecraft.server.v1_13_R1.World;
import net.minecraft.server.v1_13_R1.WorldServer;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_13_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_13_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_13_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class V1_13
extends NMS {
    @Override
    public List<BoundingBox> getBoundingBoxes(com.loohp.interactionvisualizer.objectholders.BlockPosition pos) {
        BlockPosition blockpos = new BlockPosition(pos.getX(), pos.getY(), pos.getZ());
        WorldServer world = ((CraftWorld)pos.getWorld()).getHandle();
        VoxelShape shape = world.getType(blockpos).g((IBlockAccess)world, blockpos);
        return shape.d().stream().map(each -> new BoundingBox(each.a + (double)pos.getX(), each.b + (double)pos.getY(), each.c + (double)pos.getZ(), each.d + (double)pos.getX(), each.e + (double)pos.getY(), each.f + (double)pos.getZ())).collect(Collectors.toList());
    }

    @Override
    public NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition chunk, boolean load) {
        if (!chunk.isLoaded() && !load) {
            return null;
        }
        org.bukkit.World world = chunk.getWorld();
        return new NMSTileEntitySet(((CraftChunk)chunk.getChunk()).getHandle().tileEntities, entry -> {
            BlockPosition pos = (BlockPosition)entry.getKey();
            Material type = CraftMagicNumbers.getMaterial((Block)((net.minecraft.server.v1_13_R1.TileEntity)entry.getValue()).getBlock().getBlock());
            TileEntity.TileEntityType tileEntityType = TileEntity.getTileEntityType(type);
            if (tileEntityType != null) {
                return new TileEntity(world, pos.getX(), pos.getY(), pos.getZ(), tileEntityType);
            }
            return null;
        });
    }

    @Override
    public PacketContainer[] createEntityEquipmentPacket(int entityId, List<ValuePairs<EquipmentSlot, ItemStack>> equipments) {
        PacketContainer[] packets = new PacketContainer[equipments.size()];
        for (int i = 0; i < equipments.size(); ++i) {
            EnumWrappers.ItemSlot libSlot;
            ValuePairs<EquipmentSlot, ItemStack> pair = equipments.get(i);
            PacketContainer packet = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
            packet.getIntegers().write(0, (Object)entityId);
            switch (pair.getFirst()) {
                case CHEST: {
                    libSlot = EnumWrappers.ItemSlot.CHEST;
                    break;
                }
                case FEET: {
                    libSlot = EnumWrappers.ItemSlot.FEET;
                    break;
                }
                case HEAD: {
                    libSlot = EnumWrappers.ItemSlot.HEAD;
                    break;
                }
                case LEGS: {
                    libSlot = EnumWrappers.ItemSlot.LEGS;
                    break;
                }
                case OFF_HAND: {
                    libSlot = EnumWrappers.ItemSlot.OFFHAND;
                    break;
                }
                default: {
                    libSlot = EnumWrappers.ItemSlot.MAINHAND;
                }
            }
            packet.getItemSlots().write(0, (Object)libSlot);
            packet.getItemModifier().write(0, (Object)pair.getSecond());
            packets[i] = packet;
        }
        return packets;
    }

    @Override
    public int getItemDespawnRate(Item item) {
        int despawnRate;
        try {
            Object spigotWorldConfig = World.class.getField("spigotConfig").get(((CraftWorld)item.getWorld()).getHandle());
            despawnRate = spigotWorldConfig.getClass().getField("itemDespawnRate").getInt(spigotWorldConfig);
            try {
                despawnRate = (Integer)EntityItem.class.getMethod("getDespawnRate", new Class[0]).invoke((Object)((CraftItem)item).getHandle(), new Object[0]);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            despawnRate = 6000;
        }
        return despawnRate;
    }

    @Override
    public String getBannerCustomName(org.bukkit.block.Block block) {
        return ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ())).aa_().getString("CustomName");
    }

    @Override
    public WrappedIterable<?, Entity> getEntities(org.bukkit.World world) {
        return new WrappedIterable<net.minecraft.server.v1_13_R1.Entity, Entity>(((CraftWorld)world).getHandle().entityList, entry -> entry.getBukkitEntity());
    }
}

