/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.objectholders.ILightManager;
import com.loohp.interactionvisualizer.objectholders.LightData;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import ru.beykerykt.lightapi.LightAPI;
import ru.beykerykt.lightapi.LightType;
import ru.beykerykt.lightapi.chunks.ChunkInfo;

public class LightManager
implements ILightManager {
    private final InteractionVisualizer plugin;
    private Set<LightData> addqueue;
    private Set<LightData> deletequeue;

    private static LightType convert(com.loohp.interactionvisualizer.objectholders.LightType lightType) {
        if (lightType == null) {
            return null;
        }
        switch (lightType) {
            case BLOCK: {
                return LightType.BLOCK;
            }
            case SKY: {
                return LightType.SKY;
            }
        }
        return null;
    }

    public LightManager(InteractionVisualizer plugin) {
        this.plugin = plugin;
        this.addqueue = new HashSet<LightData>();
        this.deletequeue = new HashSet<LightData>();
    }

    @Override
    public void createLight(Location location, int lightlevel, com.loohp.interactionvisualizer.objectholders.LightType lightType) {
        this.addqueue.add(LightData.of(location, lightlevel, lightType));
    }

    @Override
    public void deleteLight(Location location) {
        this.addqueue.remove(LightData.of(location, com.loohp.interactionvisualizer.objectholders.LightType.BLOCK));
        this.addqueue.remove(LightData.of(location, com.loohp.interactionvisualizer.objectholders.LightType.SKY));
        this.deletequeue.add(LightData.of(location));
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            boolean changed = false;
            LinkedList<LightData> updateQueue = new LinkedList<LightData>();
            Set<LightData> addqueue = this.addqueue;
            Set<LightData> deletequeue = this.deletequeue;
            this.addqueue = new HashSet<LightData>();
            this.deletequeue = new HashSet<LightData>();
            if (!deletequeue.isEmpty()) {
                changed = true;
            }
            Iterator<LightData> itr0 = deletequeue.iterator();
            while (itr0.hasNext()) {
                LightData lightdata = itr0.next();
                if (lightdata.isLocationLoaded()) {
                    Location location = lightdata.getLocation();
                    if (LightAPI.isSupported((World)location.getWorld(), (LightType)LightType.SKY)) {
                        LightAPI.deleteLight((Location)location, (LightType)LightType.SKY, (boolean)false);
                    }
                    LightAPI.deleteLight((Location)location, (LightType)LightType.BLOCK, (boolean)false);
                    updateQueue.add(LightData.of(location, 14, com.loohp.interactionvisualizer.objectholders.LightType.SKY));
                    updateQueue.add(LightData.of(location, 14, com.loohp.interactionvisualizer.objectholders.LightType.BLOCK));
                }
                itr0.remove();
            }
            if (!addqueue.isEmpty()) {
                changed = true;
            }
            Iterator<LightData> itr1 = addqueue.iterator();
            while (itr1.hasNext()) {
                LightData lightdata = itr1.next();
                if (lightdata.isLocationLoaded()) {
                    Location location = lightdata.getLocation();
                    int lightlevel = lightdata.getLightLevel();
                    if (LightAPI.isSupported((World)location.getWorld(), (LightType)LightManager.convert(lightdata.getLightType()))) {
                        LightAPI.createLight((Location)location, (LightType)LightManager.convert(lightdata.getLightType()), (int)lightlevel, (boolean)false);
                        updateQueue.add(lightdata);
                    }
                }
                itr1.remove();
            }
            if (changed) {
                HashSet blockinfos = new HashSet();
                HashSet skyinfos = new HashSet();
                while (!updateQueue.isEmpty()) {
                    LightData lightdata = (LightData)updateQueue.poll();
                    LightType lightType = LightManager.convert(lightdata.getLightType());
                    switch (lightType) {
                        case BLOCK: {
                            blockinfos.addAll(LightAPI.collectChunks((Location)lightdata.getLocation(), (LightType)lightType, (int)lightdata.getLightLevel()));
                            break;
                        }
                        case SKY: {
                            skyinfos.addAll(LightAPI.collectChunks((Location)lightdata.getLocation(), (LightType)lightType, (int)lightdata.getLightLevel()));
                        }
                    }
                }
                for (ChunkInfo info : skyinfos) {
                    LightAPI.updateChunk((ChunkInfo)info, (LightType)LightType.SKY);
                }
                for (ChunkInfo info : blockinfos) {
                    LightAPI.updateChunk((ChunkInfo)info, (LightType)LightType.BLOCK);
                }
            }
        }, 0L, (long)InteractionVisualizer.lightUpdatePeriod.intValue()).getTaskId();
    }
}

