/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FixerUtils {
    public static final Pattern QUOTE_PATTERN = Pattern.compile("^( *(?:(?:- +)|(?:[^:]*: +)))([^ ].*)$");
    public static final Pattern QUOTE_STRING_PATTERN = Pattern.compile("^(.*?)( #.*)?$");

    public static File fixYaml(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(FixerUtils.fixYaml(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            for (String line : lines) {
                pw.println(line);
            }
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static InputStream fixYaml(InputStream input) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(FixerUtils.fixYaml(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
            for (String line : lines) {
                pw.println(line);
            }
            pw.flush();
        }
        return new ByteArrayInputStream(output.toByteArray());
    }

    public static String fixYaml(String str) {
        Matcher matcher = QUOTE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String part1 = matcher.group(1);
            String part2 = matcher.group(2);
            if (!(part2.startsWith("\"") || part2.startsWith("'") || part2.startsWith("["))) {
                part2 = FixerUtils.quoteString(part2);
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(part1 + part2));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String quoteString(String str) {
        Matcher matcher = QUOTE_STRING_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String part1 = "\"" + matcher.group(1).replaceAll("[\\\\\\'\\\"](?!(?:u[0-9a-fA-F]{4})|(?:[ertpafv0]))", "\\\\$0") + "\"";
            String part2 = matcher.group(2);
            if (part2 == null) {
                part2 = "";
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(part1 + part2));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

