/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public interface YamlSequence
extends YamlNode,
Iterable<YamlNode> {
    public Collection<YamlNode> values();

    @Override
    default public Iterator<YamlNode> iterator() {
        return this.values().iterator();
    }

    default public int size() {
        return this.values().size();
    }

    default public YamlMapping yamlMapping(int index) {
        YamlMapping mapping = null;
        int count = 0;
        for (YamlNode node : this.values()) {
            if (count == index && node instanceof YamlMapping) {
                mapping = (YamlMapping)node;
            }
            ++count;
        }
        return mapping;
    }

    default public YamlSequence yamlSequence(int index) {
        YamlSequence sequence = null;
        int count = 0;
        for (YamlNode node : this.values()) {
            if (count == index && node instanceof YamlSequence) {
                sequence = (YamlSequence)node;
            }
            ++count;
        }
        return sequence;
    }

    default public String string(int index) {
        String value = null;
        int count = 0;
        for (YamlNode node : this.values()) {
            if (count == index && node instanceof Scalar) {
                value = ((Scalar)node).value();
                break;
            }
            ++count;
        }
        return value;
    }

    default public String foldedBlockScalar(int index) {
        String value = null;
        int count = 0;
        for (YamlNode node : this.values()) {
            if (count == index && node instanceof Scalar) {
                value = ((Scalar)node).value();
                break;
            }
            ++count;
        }
        return value;
    }

    default public Collection<String> literalBlockScalar(int index) {
        List<String> value = null;
        int count = 0;
        for (YamlNode node : this.values()) {
            if (count == index && node instanceof Scalar) {
                value = Arrays.asList(((Scalar)node).value().split(System.lineSeparator()));
                break;
            }
            ++count;
        }
        return value;
    }

    default public int integer(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    default public float floatNumber(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return Float.parseFloat(value);
        }
        return -1.0f;
    }

    default public double doubleNumber(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return Double.parseDouble(value);
        }
        return -1.0;
    }

    default public long longNumber(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return Long.parseLong(value);
        }
        return -1L;
    }

    default public LocalDate date(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return LocalDate.parse(value);
        }
        return null;
    }

    default public LocalDateTime dateTime(int index) {
        String value = this.string(index);
        if (value != null && !value.isEmpty()) {
            return LocalDateTime.parse(value);
        }
        return null;
    }
}

