/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public interface YamlMapping
extends YamlNode {
    public Set<YamlNode> keys();

    public YamlNode value(YamlNode var1);

    default public Collection<YamlNode> values() {
        LinkedList<YamlNode> values = new LinkedList<YamlNode>();
        for (YamlNode key : this.keys()) {
            values.add(this.value(key));
        }
        return values;
    }

    default public YamlMapping yamlMapping(String key) {
        return this.yamlMapping(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public YamlMapping yamlMapping(YamlNode key) {
        YamlNode value = this.value(key);
        YamlMapping found = value instanceof YamlMapping ? (YamlMapping)value : null;
        return found;
    }

    default public YamlSequence yamlSequence(String key) {
        return this.yamlSequence(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public YamlSequence yamlSequence(YamlNode key) {
        YamlNode value = this.value(key);
        YamlSequence found = value instanceof YamlSequence ? (YamlSequence)value : null;
        return found;
    }

    default public String string(String key) {
        return this.string(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public String string(YamlNode key) {
        YamlNode value = this.value(key);
        String found = value instanceof Scalar ? ((Scalar)value).value() : null;
        return found;
    }

    default public String foldedBlockScalar(String key) {
        return this.foldedBlockScalar(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public String foldedBlockScalar(YamlNode key) {
        YamlNode value = this.value(key);
        String found = value instanceof Scalar ? ((Scalar)value).value() : null;
        return found;
    }

    default public Collection<String> literalBlockScalar(String key) {
        return this.literalBlockScalar(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public Collection<String> literalBlockScalar(YamlNode key) {
        YamlNode value = this.value(key);
        List<String> found = value instanceof Scalar ? Arrays.asList(((Scalar)value).value().split(System.lineSeparator())) : null;
        return found;
    }

    default public YamlNode value(String key) {
        return this.value(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public int integer(String key) {
        return this.integer(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public int integer(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return Integer.parseInt(((Scalar)value).value());
        }
        return -1;
    }

    default public float floatNumber(String key) {
        return this.floatNumber(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public float floatNumber(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return Float.parseFloat(((Scalar)value).value());
        }
        return -1.0f;
    }

    default public double doubleNumber(String key) {
        return this.doubleNumber(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public double doubleNumber(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return Double.parseDouble(((Scalar)value).value());
        }
        return -1.0;
    }

    default public long longNumber(String key) {
        return this.longNumber(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public long longNumber(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return Long.parseLong(((Scalar)value).value());
        }
        return -1L;
    }

    default public LocalDate date(String key) {
        return this.date(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public LocalDate date(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return LocalDate.parse(((Scalar)value).value());
        }
        return null;
    }

    default public LocalDateTime dateTime(String key) {
        return this.dateTime(Yaml.createYamlScalarBuilder().addLine(key).buildPlainScalar());
    }

    default public LocalDateTime dateTime(YamlNode key) {
        YamlNode value = this.value(key);
        if (value instanceof Scalar) {
            return LocalDateTime.parse(((Scalar)value).value());
        }
        return null;
    }
}

