/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.cryptomorin.xseries.particles;

import com.loohp.interactionvisualizer.libs.com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final boolean SUPPORTS_DUST_TRANSITION = XParticle.getParticle("DUST_COLOR_TRANSITION") != null;
    private static final Axis[] DEFAULT_ROTATION_ORDER = new Axis[]{Axis.X, Axis.Y, Axis.Z};
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    public int count = 1;
    public double extra;
    public boolean force;
    @Nonnull
    private Particle particle = DEFAULT_PARTICLE;
    @Nullable
    private Location location;
    @Nullable
    private Callable<Location> locationCaller;
    @Nullable
    private Vector rotation;
    @Nullable
    private Vector offset = new Vector();
    @Nonnull
    private Axis[] rotationOrder = DEFAULT_ROTATION_ORDER;
    @Nullable
    private Object data;
    @Nullable
    private Predicate<Location> onSpawn;

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int r, int g, int b, float size) {
        return ParticleDisplay.simple(location, Particle.REDSTONE).withColor(r, g, b, size);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float size) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        ParticleDisplay display = new ParticleDisplay();
        display.particle = particle;
        display.location = location;
        return display;
    }

    @Nonnull
    public static ParticleDisplay of(@Nonnull Particle particle) {
        return ParticleDisplay.simple(null, particle);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay display = ParticleDisplay.simple(location, particle);
        display.spawn();
        return display;
    }

    public static ParticleDisplay fromConfig(@Nonnull ConfigurationSection config) {
        return ParticleDisplay.edit(new ParticleDisplay(), config);
    }

    private static int toInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static double toDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    private static List<String> split(@Nonnull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(5);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay display, @Nonnull ConfigurationSection config) {
        Material material;
        float size;
        String rotationOrder;
        List<String> rotations;
        String rotation;
        String offset;
        Particle particle;
        Objects.requireNonNull(display, "Cannot edit a null particle display");
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        String particleName = config.getString("particle");
        Particle particle2 = particle = particleName == null ? null : XParticle.getParticle(particleName);
        if (particle != null) {
            display.particle = particle;
        }
        if (config.isSet("count")) {
            display.withCount(config.getInt("count"));
        }
        if (config.isSet("extra")) {
            display.withExtra(config.getDouble("extra"));
        }
        if (config.isSet("force")) {
            display.forceSpawn(config.getBoolean("force"));
        }
        if ((offset = config.getString("offset")) != null) {
            List<String> offsets = ParticleDisplay.split(offset.replace(" ", ""), ',');
            if (offsets.size() >= 3) {
                double offsetx = ParticleDisplay.toDouble(offsets.get(0));
                double offsety = ParticleDisplay.toDouble(offsets.get(1));
                double offsetz = ParticleDisplay.toDouble(offsets.get(2));
                display.offset(offsetx, offsety, offsetz);
            } else {
                double masterOffset = ParticleDisplay.toDouble(offsets.get(0));
                display.offset(masterOffset);
            }
        }
        if ((rotation = config.getString("rotation")) != null && (rotations = ParticleDisplay.split(rotation.replace(" ", ""), ',')).size() >= 3) {
            double x = Math.toRadians(ParticleDisplay.toDouble(rotations.get(0)));
            double y = Math.toRadians(ParticleDisplay.toDouble(rotations.get(1)));
            double z = Math.toRadians(ParticleDisplay.toDouble(rotations.get(2)));
            display.rotation = new Vector(x, y, z);
        }
        if ((rotationOrder = config.getString("rotation-order")) != null) {
            rotationOrder = rotationOrder.replace(" ", "").toUpperCase(Locale.ENGLISH);
            display.rotationOrder(Axis.valueOf(String.valueOf(rotationOrder.charAt(0))), Axis.valueOf(String.valueOf(rotationOrder.charAt(1))), Axis.valueOf(String.valueOf(rotationOrder.charAt(2))));
        }
        String color = config.getString("color");
        String blockdata = config.getString("blockdata");
        String item = config.getString("itemstack");
        String materialdata = config.getString("materialdata");
        if (config.isSet("size")) {
            float[] datas;
            size = (float)config.getDouble("size");
            if (display.data instanceof float[] && (datas = (float[])display.data).length > 3) {
                datas[3] = size;
            }
        } else {
            size = 1.0f;
        }
        if (color != null) {
            List<String> colors = ParticleDisplay.split(color.replace(" ", ""), ',');
            if (colors.size() <= 3 || colors.size() == 6) {
                Color parsedColor1 = Color.white;
                Color parsedColor2 = null;
                if (colors.size() <= 2) {
                    try {
                        parsedColor1 = Color.decode(colors.get(0));
                        if (colors.size() == 2) {
                            parsedColor2 = Color.decode(colors.get(1));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    parsedColor1 = new Color(ParticleDisplay.toInt(colors.get(0)), ParticleDisplay.toInt(colors.get(1)), ParticleDisplay.toInt(colors.get(2)));
                    if (colors.size() == 6) {
                        parsedColor2 = new Color(ParticleDisplay.toInt(colors.get(3)), ParticleDisplay.toInt(colors.get(4)), ParticleDisplay.toInt(colors.get(5)));
                    }
                }
                display.data = parsedColor2 != null ? (Object)new float[]{parsedColor1.getRed(), parsedColor1.getGreen(), parsedColor1.getBlue(), size, parsedColor2.getRed(), parsedColor2.getGreen(), parsedColor2.getBlue()} : (Object)new float[]{parsedColor1.getRed(), parsedColor1.getGreen(), parsedColor1.getBlue(), size};
            }
        } else if (blockdata != null) {
            material = Material.getMaterial((String)blockdata);
            if (material != null && material.isBlock()) {
                display.data = material.createBlockData();
            }
        } else if (item != null) {
            material = Material.getMaterial((String)item);
            if (material != null && material.isItem()) {
                display.data = new ItemStack(material, 1);
            }
        } else if (materialdata != null && (material = Material.getMaterial((String)materialdata)) != null && material.isBlock()) {
            display.data = material.getData();
        }
        return display;
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, @Nonnull Vector rotation) {
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        Objects.requireNonNull(rotation, "Rotation vector cannot be null");
        switch (axis) {
            case X: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getX());
            }
            case Y: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getY());
            }
            case Z: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getZ());
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public static Vector rotateAround(@Nonnull Vector location, double x, double y, double z) {
        ParticleDisplay.rotateAround(location, Axis.X, x);
        ParticleDisplay.rotateAround(location, Axis.Y, y);
        ParticleDisplay.rotateAround(location, Axis.Z, z);
        return location;
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, double angle) {
        Objects.requireNonNull(location, "Cannot rotate a null location");
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        if (angle == 0.0) {
            return location;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        switch (axis) {
            case X: {
                double y = location.getY() * cos - location.getZ() * sin;
                double z = location.getY() * sin + location.getZ() * cos;
                return location.setY(y).setZ(z);
            }
            case Y: {
                double x = location.getX() * cos + location.getZ() * sin;
                double z = location.getX() * -sin + location.getZ() * cos;
                return location.setX(x).setZ(z);
            }
            case Z: {
                double x = location.getX() * cos - location.getY() * sin;
                double y = location.getX() * sin + location.getY() * cos;
                return location.setX(x).setY(y);
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public ParticleDisplay onSpawn(@Nullable Predicate<Location> onSpawn) {
        this.onSpawn = onSpawn;
        return this;
    }

    public void withParticle(@Nonnull Particle particle) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
    }

    @Nonnull
    public Location rotate(@Nonnull Location location, double x, double y, double z) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.rotation == null) {
            return ParticleDisplay.cloneLocation(location).add(x, y, z);
        }
        Vector rotate = new Vector(x, y, z);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[0], this.rotation);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[1], this.rotation);
        ParticleDisplay.rotateAround(rotate, this.rotationOrder[2], this.rotation);
        return ParticleDisplay.cloneLocation(location).add(rotate);
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public String toString() {
        Location location = this.getLocation();
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offset.getX() + ", " + this.offset.getY() + ", " + this.offset.getZ() + "}, " + (location != null ? "Location:{" + location.getWorld().getName() + location.getX() + ", " + location.getY() + ", " + location.getZ() + "} " + '(' + (this.locationCaller == null ? "Static" : "Dynamic") + "), " : "") + (this.rotation != null ? "Rotation:{" + Math.toDegrees(this.rotation.getX()) + ", " + Math.toRadians(this.rotation.getY()) + ", " + Math.toDegrees(this.rotation.getZ()) + "}, " : "") + (this.rotationOrder != DEFAULT_ROTATION_ORDER ? "RotationOrder:" + Arrays.toString((Object[])this.rotationOrder) + ", " : "") + "Extra=" + this.extra + ", Force=" + this.force + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public ParticleDisplay forceSpawn(boolean force) {
        this.force = force;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float size) {
        return this.withColor(color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public ParticleDisplay withTransitionColor(@Nonnull Color color1, float size, @Nonnull Color color2) {
        return this.withTransitionColor(color1.getRed(), color1.getGreen(), color1.getBlue(), size, color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    @Nonnull
    public ParticleDisplay withColor(float red, float green, float blue, float size) {
        this.data = new float[]{red, green, blue, size};
        return this;
    }

    @Nonnull
    public ParticleDisplay withTransitionColor(float red1, float green1, float blue1, float size, float red2, float green2, float blue2) {
        this.data = new float[]{red1, green1, blue1, size, red2, green2, blue2};
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = blockData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = materialData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack item) {
        this.data = item;
        return this;
    }

    @Nullable
    public Vector getOffset() {
        return this.offset;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> locationCaller) {
        this.locationCaller = locationCaller;
        return this;
    }

    public ParticleDisplay rotationOrder(@Nonnull Axis first, @Nonnull Axis second, @Nonnull Axis third) {
        Objects.requireNonNull(first, "First rotation order axis is null");
        Objects.requireNonNull(second, "Second rotation order axis is null");
        Objects.requireNonNull(third, "Third rotation order axis is null");
        this.rotationOrder = new Axis[]{first, second, third};
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.location;
        }
    }

    public ParticleDisplay withLocation(@Nullable Location location) {
        this.location = location;
        return this;
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Entity entity) {
        return this.face(Objects.requireNonNull(entity, "Cannot face null entity").getLocation());
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Location location) {
        Objects.requireNonNull(location, "Cannot face null location");
        this.rotation = new Vector(Math.toRadians(location.getPitch() + 90.0f), Math.toRadians(-location.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(x, y, z);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay display = ParticleDisplay.of(this.particle).withLocationCaller(this.locationCaller).withCount(this.count).offset(this.offset.clone()).forceSpawn(this.force).onSpawn(this.onSpawn);
        if (this.location != null) {
            display.location = ParticleDisplay.cloneLocation(this.location);
        }
        if (this.rotation != null) {
            display.rotation = this.rotation.clone();
        }
        display.rotationOrder = this.rotationOrder;
        display.data = this.data;
        return display;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double x, double y, double z) {
        return this.rotate(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(double x, double y, double z) {
        return this.offset(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(@Nonnull Vector offset) {
        this.offset = Objects.requireNonNull(offset, "Particle offset cannot be null");
        return this;
    }

    @Nullable
    public Vector getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Vector rotation) {
        this.rotation = rotation;
    }

    @Nonnull
    public ParticleDisplay offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector location) {
        Objects.requireNonNull(location, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(location.getX(), location.getY(), location.getZ());
    }

    @Nonnull
    public Location spawn(double x, double y, double z) {
        return this.spawn(this.rotate(this.getLocation(), x, y, z));
    }

    @Nonnull
    public Location spawn(@Nonnull Location loc) {
        return this.spawn(loc, null);
    }

    @Nonnull
    public Location spawn(Location loc, Player ... players) {
        if (loc == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.onSpawn != null && !this.onSpawn.test(loc)) {
            return loc;
        }
        World world = loc.getWorld();
        double offsetx = this.offset.getX();
        double offsety = this.offset.getY();
        double offsetz = this.offset.getZ();
        if (this.data != null && this.data instanceof float[]) {
            float[] datas = (float[])this.data;
            if (ISFLAT && this.particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dust = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), datas[3]);
                if (players == null) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust, this.force);
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust);
                    }
                }
            } else if (SUPPORTS_DUST_TRANSITION && this.particle.getDataType() == Particle.DustTransition.class) {
                Particle.DustTransition dust = new Particle.DustTransition(org.bukkit.Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), org.bukkit.Color.fromRGB((int)((int)datas[4]), (int)((int)datas[5]), (int)((int)datas[6])), datas[3]);
                if (players == null) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust, this.force);
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, (Object)dust);
                    }
                }
            } else if (this.isDirectional()) {
                float[] rgb = new float[]{datas[0] / 255.0f, datas[1] / 255.0f, datas[2] / 255.0f};
                if (players == null) {
                    if (ISFLAT) {
                        world.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null, this.force);
                    } else {
                        world.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null);
                    }
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3]);
                    }
                }
            } else if (players == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, null, this.force);
                } else {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, null);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra);
                }
            }
        } else {
            Object datas;
            Object object = datas = this.particle.getDataType().isInstance(this.data) ? this.data : null;
            if (players == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas, this.force);
                } else {
                    world.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, offsetx, offsety, offsetz, this.extra, datas);
                }
            }
        }
        return loc;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

