/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.cryptomorin.xseries;

import com.google.common.base.Strings;
import com.loohp.interactionvisualizer.libs.com.cryptomorin.xseries.XSound;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Note;
import org.bukkit.entity.Player;

public final class NoteBlockMusic {
    private static final Map<String, Instrument> INSTRUMENTS = new HashMap<String, Instrument>(50);
    private static final Map<Instrument, XSound> INSTRUMENT_TO_SOUND = new EnumMap<Instrument, XSound>(Instrument.class);

    private NoteBlockMusic() {
    }

    @Nonnull
    public static XSound getSoundFromInstrument(@Nonnull Instrument instrument) {
        return INSTRUMENT_TO_SOUND.get(instrument);
    }

    @Nullable
    public static Note.Tone getNoteTone(char ch) {
        switch (ch) {
            case 'A': {
                return Note.Tone.A;
            }
            case 'B': {
                return Note.Tone.B;
            }
            case 'C': {
                return Note.Tone.C;
            }
            case 'D': {
                return Note.Tone.D;
            }
            case 'E': {
                return Note.Tone.E;
            }
            case 'F': {
                return Note.Tone.F;
            }
            case 'G': {
                return Note.Tone.G;
            }
        }
        return null;
    }

    public static CompletableFuture<Void> testMusic(@Nonnull Player player) {
        return NoteBlockMusic.playMusic(player, () -> ((Player)player).getLocation(), "PIANO,D,2,100 PIANO,B#1 200 PIANO,F 250 PIANO,E 250 PIANO,B 200 PIANO,A 100 PIANO,B 100 PIANO,E");
    }

    public static CompletableFuture<Void> fromFile(@Nonnull Player player, @Nonnull Supplier<Location> location, @Nonnull Path path) {
        return CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    NoteBlockMusic.parseInstructions(line).play(player, location);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static CompletableFuture<Void> playMusic(@Nonnull Player player, @Nonnull Supplier<Location> location, @Nullable String script) {
        return CompletableFuture.runAsync(() -> {
            if (Strings.isNullOrEmpty((String)script)) {
                return;
            }
            Sequence seq = NoteBlockMusic.parseInstructions(script);
            seq.play(player, location);
        }).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static Sequence parseInstructions(@Nonnull CharSequence script) {
        return new InstructionBuilder((CharSequence)script).sequence;
    }

    private static void sleep(long fermata) {
        try {
            Thread.sleep(fermata);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    public static Note parseNote(@Nonnull String note) {
        Note.Tone tone = NoteBlockMusic.getNoteTone((char)(note.charAt(0) & 0x5F));
        if (tone == null) {
            return null;
        }
        int len = note.length();
        char toneType = ' ';
        int octave = 0;
        if (len > 1) {
            char octaveDigit;
            toneType = note.charAt(1);
            if (NoteBlockMusic.isDigit(toneType)) {
                octave = toneType - 48;
            } else if (len > 2 && NoteBlockMusic.isDigit(octaveDigit = note.charAt(2))) {
                octave = octaveDigit - 48;
            }
            if (octave < 0 || octave > 2) {
                octave = 0;
            }
        }
        return toneType == '#' ? Note.sharp((int)octave, (Note.Tone)tone) : (toneType == '_' ? Note.flat((int)octave, (Note.Tone)tone) : Note.natural((int)octave, (Note.Tone)tone));
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static float noteToPitch(@Nonnull Note note) {
        return (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0);
    }

    static {
        INSTRUMENT_TO_SOUND.put(Instrument.PIANO, XSound.BLOCK_NOTE_BLOCK_HARP);
        INSTRUMENT_TO_SOUND.put(Instrument.BASS_DRUM, XSound.BLOCK_NOTE_BLOCK_BASEDRUM);
        INSTRUMENT_TO_SOUND.put(Instrument.SNARE_DRUM, XSound.BLOCK_NOTE_BLOCK_SNARE);
        INSTRUMENT_TO_SOUND.put(Instrument.STICKS, XSound.BLOCK_NOTE_BLOCK_HAT);
        INSTRUMENT_TO_SOUND.put(Instrument.BASS_GUITAR, XSound.BLOCK_NOTE_BLOCK_BASS);
        INSTRUMENT_TO_SOUND.put(Instrument.FLUTE, XSound.BLOCK_NOTE_BLOCK_FLUTE);
        INSTRUMENT_TO_SOUND.put(Instrument.BELL, XSound.BLOCK_NOTE_BLOCK_BELL);
        INSTRUMENT_TO_SOUND.put(Instrument.GUITAR, XSound.BLOCK_NOTE_BLOCK_GUITAR);
        INSTRUMENT_TO_SOUND.put(Instrument.CHIME, XSound.BLOCK_NOTE_BLOCK_CHIME);
        INSTRUMENT_TO_SOUND.put(Instrument.XYLOPHONE, XSound.BLOCK_NOTE_BLOCK_XYLOPHONE);
        INSTRUMENT_TO_SOUND.put(Instrument.IRON_XYLOPHONE, XSound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE);
        INSTRUMENT_TO_SOUND.put(Instrument.COW_BELL, XSound.BLOCK_NOTE_BLOCK_COW_BELL);
        INSTRUMENT_TO_SOUND.put(Instrument.DIDGERIDOO, XSound.BLOCK_NOTE_BLOCK_DIDGERIDOO);
        INSTRUMENT_TO_SOUND.put(Instrument.BIT, XSound.BLOCK_NOTE_BLOCK_BIT);
        INSTRUMENT_TO_SOUND.put(Instrument.BANJO, XSound.BLOCK_NOTE_BLOCK_BANJO);
        INSTRUMENT_TO_SOUND.put(Instrument.PLING, XSound.BLOCK_NOTE_BLOCK_PLING);
        INSTRUMENTS.put("HARP", Instrument.PIANO);
        INSTRUMENTS.put("BASEDRUM", Instrument.BASS_DRUM);
        INSTRUMENTS.put("BASE_DRUM", Instrument.BASS_DRUM);
        INSTRUMENTS.put("SNARE", Instrument.SNARE_DRUM);
        INSTRUMENTS.put("BASS", Instrument.BASS_GUITAR);
        INSTRUMENTS.put("COWBELL", Instrument.COW_BELL);
        block0: for (Instrument instrument : Instrument.values()) {
            String name = instrument.name();
            INSTRUMENTS.put(name, instrument);
            StringBuilder alias = new StringBuilder(String.valueOf(name.charAt(0)));
            int index = name.indexOf(95);
            if (index != -1) {
                alias.append(name.charAt(index + 1));
            }
            if (INSTRUMENTS.putIfAbsent(alias.toString(), instrument) == null) continue;
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch == '_') {
                    ++i;
                    continue;
                }
                alias.append(ch);
                if (INSTRUMENTS.putIfAbsent(alias.toString(), instrument) == null) continue block0;
            }
        }
    }

    private static final class InstructionBuilder {
        @Nonnull
        final CharSequence script;
        final int len;
        final StringBuilder instrumentBuilder = new StringBuilder(10);
        final StringBuilder pitchBuiler = new StringBuilder(3);
        final StringBuilder volumeBuilder = new StringBuilder(3);
        final StringBuilder restatementBuilder = new StringBuilder(10);
        final StringBuilder restatementDelayBuilder = new StringBuilder(10);
        final StringBuilder fermataBuilder = new StringBuilder(10);
        int i;
        boolean isSequence;
        boolean isBuilding;
        Sequence sequence = new Sequence();
        InstructionParserPhase phase = InstructionParserPhase.NEUTRAL;
        StringBuilder currentBuilder;

        public InstructionBuilder(@Nonnull CharSequence script) {
            this.script = script;
            this.len = script.length();
            while (this.i < this.len) {
                char ch = script.charAt(this.i);
                switch (ch) {
                    case '(': {
                        Sequence parent = new Sequence();
                        parent.parent = this.sequence;
                        this.sequence = parent;
                        break;
                    }
                    case ')': {
                        if (this.sequence.parent == null) {
                            this.err("Cannot find start of the sequence for sequence at: " + this.i);
                        }
                        this.buildAndAddInstruction();
                        this.sequence = this.sequence.parent;
                        this.prepareHandlers();
                        this.phase = InstructionParserPhase.END_SEQ;
                        this.isSequence = true;
                        break;
                    }
                    case ' ': {
                        if (!this.isBuilding) break;
                        this.isBuilding = false;
                        switch (this.phase) {
                            case FERMATA: {
                                this.buildAndAddInstruction();
                                this.prepareHandlers();
                                break;
                            }
                            case NOTE: 
                            case RESTATEMENT_DELAY: {
                                this.phase = InstructionParserPhase.FERMATA;
                                this.currentBuilder = this.fermataBuilder;
                            }
                        }
                        break;
                    }
                    case ':': {
                        if (this.phase == InstructionParserPhase.NOTE) {
                            this.currentBuilder = this.volumeBuilder;
                            break;
                        }
                        this.err("Unexpected ':' pitch-volume separator at " + this.i + " with current phase: " + (Object)((Object)this.phase));
                        break;
                    }
                    case ',': {
                        switch (this.phase) {
                            case INSTRUMENT: {
                                this.currentBuilder = this.pitchBuiler;
                                break;
                            }
                            case NOTE: 
                            case END_SEQ: {
                                this.currentBuilder = this.restatementBuilder;
                                break;
                            }
                            case RESTATEMENT: {
                                this.currentBuilder = this.restatementDelayBuilder;
                                break;
                            }
                            default: {
                                this.err("Unexpected phase '" + (Object)((Object)this.phase) + "' at index: " + this.i);
                            }
                        }
                        this.isBuilding = false;
                        this.phase = this.phase.next();
                        break;
                    }
                    default: {
                        if (this.phase == InstructionParserPhase.NEUTRAL || this.canBuildInstructionInPhase() && InstructionParserPhase.INSTRUMENT.checkup(ch) != '\u0000') {
                            this.currentBuilder = this.instrumentBuilder;
                            if (this.phase == InstructionParserPhase.FERMATA) {
                                this.buildAndAddInstruction();
                                this.prepareHandlers();
                            }
                            this.phase = InstructionParserPhase.INSTRUMENT;
                        }
                        this.isBuilding = true;
                        if ((ch = this.phase.checkup(ch)) == '\u0000') {
                            this.err("Unexpected char at index " + this.i + " with phase " + (Object)((Object)this.phase) + ": " + script.charAt(this.i));
                        }
                        this.currentBuilder.append(ch);
                    }
                }
                ++this.i;
            }
            this.buildAndAddInstruction();
            this.sequence = this.getRoot();
        }

        private Instruction buildInstruction() {
            Instruction instruction;
            int restatementFermata;
            int fermata = this.fermataBuilder.length() == 0 ? 0 : Integer.parseInt(this.fermataBuilder.toString());
            int restatement = this.restatementBuilder.length() == 0 ? 1 : Integer.parseInt(this.restatementBuilder.toString());
            int n = restatementFermata = this.restatementDelayBuilder.length() == 0 ? 0 : Integer.parseInt(this.restatementDelayBuilder.toString());
            if (this.isSequence) {
                instruction = new Sequence(restatement, restatementFermata, fermata);
            } else {
                String instrumentStr = this.instrumentBuilder.toString();
                Instrument instrument = (Instrument)INSTRUMENTS.get(instrumentStr);
                XSound sound = instrument == null ? (XSound)XSound.matchXSound(instrumentStr).orElse(null) : NoteBlockMusic.getSoundFromInstrument(instrument);
                String pitchStr = this.pitchBuiler.toString();
                Note note = NoteBlockMusic.parseNote(pitchStr);
                float pitch = note == null ? Float.parseFloat(pitchStr) : NoteBlockMusic.noteToPitch(note);
                float volume = 5.0f;
                if (this.volumeBuilder.length() != 0) {
                    volume = Float.parseFloat(this.volumeBuilder.toString());
                }
                instruction = new Sound(sound, pitch, volume, restatement, restatementFermata, fermata);
            }
            return instruction;
        }

        private void prepareHandlers() {
            this.instrumentBuilder.setLength(0);
            this.pitchBuiler.setLength(0);
            this.volumeBuilder.setLength(0);
            this.restatementBuilder.setLength(0);
            this.restatementDelayBuilder.setLength(0);
            this.fermataBuilder.setLength(0);
            this.phase = InstructionParserPhase.NEUTRAL;
            this.isBuilding = false;
            this.isSequence = false;
        }

        private boolean canBuildInstructionInPhase() {
            switch (this.phase) {
                case FERMATA: 
                case RESTATEMENT_DELAY: 
                case RESTATEMENT: {
                    return true;
                }
            }
            return false;
        }

        private void buildAndAddInstruction() {
            this.sequence.addInstruction(this.buildInstruction());
        }

        private Sequence getRoot() {
            Sequence sequence = this.sequence;
            while (sequence.parent != null) {
                sequence = sequence.parent;
            }
            return sequence;
        }

        private String illustrateError() {
            return '\n' + this.script.toString() + '\n' + Strings.repeat((String)" ", (int)this.i) + '^';
        }

        private void err(String str) {
            throw new IllegalStateException(str + this.illustrateError());
        }
    }

    public static class Sequence
    extends Instruction {
        public Collection<Instruction> instructions = new ArrayList<Instruction>(16);

        public Sequence() {
            super(1, 0, 0);
        }

        public Sequence(Instruction first) {
            super(1, 0, 0);
            this.instructions.add(first);
        }

        public Sequence(int restatement, int restatementFermata, int fermata) {
            super(restatement, restatementFermata, fermata);
        }

        @Override
        public void play(Player player, Supplier<Location> location) {
            for (int repeat = this.restatement; repeat > 0; --repeat) {
                for (Instruction instruction : this.instructions) {
                    instruction.play(player, location);
                }
                if (this.restatementFermata <= 0) continue;
                NoteBlockMusic.sleep(this.restatementFermata);
            }
            if (this.fermata > 0) {
                NoteBlockMusic.sleep(this.fermata);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(200 + this.instructions.size() * 100);
            builder.append("Sequence:{restatement=").append(this.restatement).append(", restatementFermata=").append(this.restatementFermata).append(", fermata=").append(this.fermata).append(", instructions[");
            int i = 0;
            int size = this.instructions.size();
            for (Instruction instruction : this.instructions) {
                builder.append(instruction);
                if (++i >= size) continue;
                builder.append(", ");
            }
            builder.append("]}");
            return builder.toString();
        }

        public void addInstruction(Instruction instruction) {
            instruction.parent = this;
            this.instructions.add(instruction);
        }

        @Override
        public long getEstimatedLength() {
            long result = (long)this.restatement * (long)this.restatementFermata;
            for (Instruction instruction : this.instructions) {
                result += instruction.getEstimatedLength();
            }
            return result;
        }
    }

    public static abstract class Instruction {
        @Nullable
        public Sequence parent;
        public int restatement;
        public int restatementFermata;
        public int fermata;

        public Instruction(int restatement, int restatementFermata, int fermata) {
            this.restatement = restatement;
            this.restatementFermata = restatementFermata;
            this.fermata = fermata;
        }

        public abstract void play(Player var1, Supplier<Location> var2);

        public long getEstimatedLength() {
            return (long)this.restatement * (long)this.restatementFermata;
        }
    }

    public static class Sound
    extends Instruction {
        public XSound sound;
        public float volume;
        public float pitch;

        public Sound(Instrument instrument, Note note, float volume, int restatement, int restatementFermata, int fermata) {
            super(restatement, restatementFermata, fermata);
            this.sound = NoteBlockMusic.getSoundFromInstrument(instrument);
            this.pitch = NoteBlockMusic.noteToPitch(note);
            this.volume = volume;
        }

        public Sound(XSound sound, float pitch, float volume, int restatement, int restatementFermata, int fermata) {
            super(restatement, restatementFermata, fermata);
            this.sound = sound;
            this.pitch = pitch;
            this.volume = volume;
        }

        public void setSound(Instrument instrument) {
            this.sound = NoteBlockMusic.getSoundFromInstrument(instrument);
        }

        public void setPitch(Note note) {
            this.pitch = NoteBlockMusic.noteToPitch(note);
        }

        @Override
        public void play(Player player, Supplier<Location> location) {
            for (int repeat = this.restatement; repeat > 0; --repeat) {
                player.getWorld().playSound(location.get(), this.sound.parseSound(), this.volume, this.pitch);
                if (this.restatementFermata <= 0) continue;
                NoteBlockMusic.sleep(this.restatementFermata);
            }
            if (this.fermata > 0) {
                NoteBlockMusic.sleep(this.fermata);
            }
        }

        public String toString() {
            return "Sound:{sound=" + (Object)((Object)this.sound) + ", pitch=" + this.pitch + ", volume=" + this.volume + ", restatement=" + this.restatement + ", restatementFermata=" + this.restatementFermata + ", fermata=" + this.fermata + '}';
        }
    }

    private static enum InstructionParserPhase {
        NEUTRAL{

            @Override
            protected InstructionParserPhase next() {
                return INSTRUMENT;
            }

            @Override
            protected char checkup(char ch) {
                throw new AssertionError((Object)"Checkup should not be performed on NEUTRAL instruction parser phase");
            }
        }
        ,
        INSTRUMENT{

            @Override
            protected InstructionParserPhase next() {
                return NOTE;
            }

            @Override
            protected char checkup(char ch) {
                if (ch >= 'a' && ch <= 'z') {
                    return (char)(ch & 0x5F);
                }
                return ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '-' ? ch : (char)'\u0000';
            }
        }
        ,
        NOTE{

            @Override
            protected InstructionParserPhase next() {
                return RESTATEMENT;
            }

            @Override
            protected char checkup(char ch) {
                if (ch >= 'a' && ch <= 'z') {
                    return (char)(ch & 0x5F);
                }
                return ch >= 'A' && ch <= 'Z' || NoteBlockMusic.isDigit(ch) || ch == '.' || ch == '_' || ch == '#' ? ch : (char)'\u0000';
            }
        }
        ,
        END_SEQ{

            @Override
            protected InstructionParserPhase next() {
                return RESTATEMENT;
            }

            @Override
            protected char checkup(char ch) {
                return '\u0000';
            }
        }
        ,
        RESTATEMENT{

            @Override
            protected InstructionParserPhase next() {
                return RESTATEMENT_DELAY;
            }

            @Override
            protected char checkup(char ch) {
                return NoteBlockMusic.isDigit(ch) ? ch : (char)'\u0000';
            }
        }
        ,
        RESTATEMENT_DELAY{

            @Override
            protected InstructionParserPhase next() {
                return FERMATA;
            }

            @Override
            protected char checkup(char ch) {
                return NoteBlockMusic.isDigit(ch) ? ch : (char)'\u0000';
            }
        }
        ,
        FERMATA{

            @Override
            protected InstructionParserPhase next() {
                return NEUTRAL;
            }

            @Override
            protected char checkup(char ch) {
                return NoteBlockMusic.isDigit(ch) ? ch : (char)'\u0000';
            }
        };


        protected abstract InstructionParserPhase next();

        protected abstract char checkup(char var1);
    }
}

