/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entityholders;

import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.protocol.WatchableCollection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class ItemFrame
extends VisualizerEntity {
    private ItemStack item = new ItemStack(Material.AIR);
    private BlockFace facing = BlockFace.SOUTH;
    private int framerotation = 0;

    public ItemFrame(Location location) {
        super(location);
    }

    @Override
    public int cacheCode() {
        int prime = 17;
        int result = super.cacheCode();
        result = prime * result + (this.item == null ? 0 : this.item.hashCode());
        result = prime * result + (this.facing == null ? 0 : this.facing.hashCode());
        result = prime * result + this.framerotation;
        return result;
    }

    @Override
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }

    public BlockFace getAttachedFace() {
        return this.facing;
    }

    public float getYaw() {
        switch (this.facing) {
            case DOWN: {
                return 0.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case UP: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public float getPitch() {
        switch (this.facing) {
            case DOWN: {
                return 90.0f;
            }
            case EAST: {
                return 0.0f;
            }
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case UP: {
                return -90.0f;
            }
            case WEST: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item.clone();
    }

    public BlockFace getFacingDirection() {
        return this.facing;
    }

    public void setFacingDirection(BlockFace facing) {
        this.facing = facing;
    }

    public int getFrameRotation() {
        return this.framerotation;
    }

    public void setFrameRotation(int rotation) {
        if (rotation >= 0 && rotation < 8) {
            this.framerotation = rotation;
        } else {
            Bukkit.getLogger().severe("Item Frame Rotation must be between 0 and 7");
        }
    }

    @Override
    public WrappedDataWatcher updateAndGetWrappedDataWatcher() {
        this.dataWatcher = WatchableCollection.getWatchableCollection(this, this.dataWatcher);
        return this.dataWatcher;
    }

    @Override
    public double getHeight() {
        return 0.75;
    }
}

