/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entityholders;

import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.protocol.WatchableCollection;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStand
extends VisualizerEntity {
    private boolean hasArms = false;
    private boolean hasBasePlate = true;
    private boolean isMarker = false;
    private boolean hasGravity = true;
    private boolean isSmall = false;
    private boolean isInvulnerable = false;
    private boolean isVisible = true;
    private EulerAngle rightArmPose = new EulerAngle(0.0, 0.0, 0.0);
    private EulerAngle headPose = new EulerAngle(0.0, 0.0, 0.0);
    private ItemStack helmet = new ItemStack(Material.AIR);
    private ItemStack mainhand = new ItemStack(Material.AIR);
    private Component customName = null;
    private boolean customNameVisible = false;
    private Vector velocity = new Vector(0.0, 0.0, 0.0);

    public ArmorStand(Location location) {
        super(location);
    }

    @Override
    public EntityType getType() {
        return EntityType.ARMOR_STAND;
    }

    @Override
    public int cacheCode() {
        int prime = 17;
        int result = super.cacheCode();
        result = prime * result + (this.hasArms ? 5351 : 8923);
        result = prime * result + (this.hasBasePlate ? 2861 : 6607);
        result = prime * result + (this.isMarker ? 9199 : 3163);
        result = prime * result + (this.hasGravity ? 6719 : 2753);
        result = prime * result + (this.isSmall ? 1373 : 3037);
        result = prime * result + (this.isInvulnerable ? 2111 : 2251);
        result = prime * result + (this.isVisible ? 6779 : 6679);
        result = prime * result + (this.rightArmPose == null ? 0 : this.rightArmPose.hashCode());
        result = prime * result + (this.headPose == null ? 0 : this.headPose.hashCode());
        result = prime * result + (this.helmet == null ? 0 : this.helmet.hashCode());
        result = prime * result + (this.mainhand == null ? 0 : this.mainhand.hashCode());
        result = prime * result + (this.customName == null ? 0 : this.customName.hashCode());
        result = prime * result + (this.customNameVisible ? 6199 : 8647);
        result = prime * result + (this.velocity == null ? 0 : this.velocity.hashCode());
        return result;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName == null ? null : ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(customName));
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public void setCustomNameVisible(boolean bool) {
        this.customNameVisible = bool;
    }

    public void setArms(boolean bool) {
        this.hasArms = bool;
    }

    public boolean hasArms() {
        return this.hasArms;
    }

    public void setBasePlate(boolean bool) {
        this.hasBasePlate = bool;
    }

    public boolean hasBasePlate() {
        return this.hasBasePlate;
    }

    public boolean isMarker() {
        return this.isMarker;
    }

    public void setMarker(boolean bool) {
        this.isMarker = bool;
    }

    public void setGravity(boolean bool) {
        this.hasGravity = bool;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public void setSmall(boolean bool) {
        this.isSmall = bool;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public void setInvulnerable(boolean bool) {
        this.isInvulnerable = bool;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bool) {
        this.isVisible = bool;
    }

    public EulerAngle getRightArmPose() {
        return this.rightArmPose;
    }

    public void setRightArmPose(EulerAngle angle) {
        if (this.lock) {
            return;
        }
        this.rightArmPose = angle;
    }

    public EulerAngle getHeadPose() {
        return this.headPose;
    }

    public void setHeadPose(EulerAngle angle) {
        if (this.lock) {
            return;
        }
        this.headPose = angle;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack item) {
        if (this.lock) {
            return;
        }
        this.helmet = item.clone();
    }

    public ItemStack getItemInMainHand() {
        return this.mainhand;
    }

    public void setItemInMainHand(ItemStack item) {
        if (this.lock) {
            return;
        }
        this.mainhand = item.clone();
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector vector) {
        this.velocity = vector.clone();
    }

    @Override
    public WrappedDataWatcher updateAndGetWrappedDataWatcher() {
        this.dataWatcher = WatchableCollection.getWatchableCollection(this, this.dataWatcher);
        return this.dataWatcher;
    }

    @Override
    public double getHeight() {
        return this.isSmall ? 0.5 : 1.975;
    }
}

