/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.database;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.ArrayUtils;
import com.loohp.interactionvisualizer.utils.BitSetUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class Database {
    public static final String EMPTY_BITSET = "0";
    public static final Pattern VALID_BITSET = Pattern.compile("^[0-9]*$");
    private static final String preferenceTable = "USER_PERFERENCES";
    private static final String indexMappingTable = "INDEX_MAPPING";
    private static final String statusLockTable = "USE_LOCK";
    private static final Object syncdb = new Object();
    public static boolean isMYSQL = false;
    private static Connection connection;
    private static String host;
    private static String database;
    private static String username;
    private static String password;
    private static int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup() {
        String type = InteractionVisualizer.plugin.getConfiguration().getString("Database.Type");
        isMYSQL = type.equalsIgnoreCase("MYSQL");
        Object object = syncdb;
        synchronized (object) {
            if (isMYSQL) {
                Database.mysqlSetup(true);
                Database.createTable();
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                Database.sqliteSetup(true);
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void open() {
        if (isMYSQL) {
            Database.mysqlSetup(false);
        } else {
            Database.sqliteSetup(false);
        }
    }

    public static void mysqlSetup(boolean echo) {
        host = InteractionVisualizer.plugin.getConfiguration().getString("Database.MYSQL.Host");
        port = InteractionVisualizer.plugin.getConfiguration().getInt("Database.MYSQL.Port");
        database = InteractionVisualizer.plugin.getConfiguration().getString("Database.MYSQL.Database");
        username = InteractionVisualizer.plugin.getConfiguration().getString("Database.MYSQL.Username");
        password = InteractionVisualizer.plugin.getConfiguration().getString("Database.MYSQL.Password");
        try {
            if (Database.getConnection() != null && !Database.getConnection().isClosed()) {
                return;
            }
            Class.forName("com.mysql.jdbc.Driver");
            Database.setConnection(DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password));
            if (echo) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[InteractionVisualizer] MYSQL CONNECTED");
            }
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[InteractionVisualizer] MYSQL Failed to connect! (SQLException)");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[InteractionVisualizer] MYSQL Failed to connect! (ClassNotFoundException)");
            e.printStackTrace();
        }
    }

    private static void sqliteSetup(boolean echo) {
        try {
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:plugins/InteractionVisualizer/database.db");
            if (echo) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[InteractionVisualizer] Opened Sqlite database successfully");
            }
            Statement stmt0 = connection.createStatement();
            String sql0 = "CREATE TABLE IF NOT EXISTS USER_PERFERENCES (UUID TEXT PRIMARY KEY, NAME TEXT NOT NULL, ITEMSTAND TEXT, ITEMDROP TEXT, HOLOGRAM TEXT);";
            stmt0.executeUpdate(sql0);
            stmt0.close();
            Statement stmt1 = connection.createStatement();
            String sql1 = "CREATE TABLE IF NOT EXISTS INDEX_MAPPING (ENTRY TEXT PRIMARY KEY, BITMASK_INDEX INTEGER);";
            stmt1.executeUpdate(sql1);
            stmt1.close();
            Statement stmt2 = connection.createStatement();
            String sql2 = "CREATE TABLE IF NOT EXISTS USE_LOCK (STATUS_LOCK BOOLEAN PRIMARY KEY);";
            stmt2.executeUpdate(sql2);
            stmt2.close();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[InteractionVisualizer] Unable to connect to sqlite database!!!");
            e.printStackTrace();
            InteractionVisualizer.plugin.getPluginLoader().disablePlugin((Plugin)InteractionVisualizer.plugin);
        }
    }

    public static Connection getConnection() {
        return connection;
    }

    public static void setConnection(Connection connection) {
        Database.connection = connection;
    }

    private static void createTable() {
        Database.open();
        try {
            PreparedStatement statement0 = Database.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS USER_PERFERENCES (UUID Text, NAME Text, ITEMSTAND Text, ITEMDROP Text, HOLOGRAM Text)");
            statement0.execute();
            PreparedStatement statement1 = Database.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS INDEX_MAPPING (ENTRY Text, BITMASK_INDEX INT)");
            statement1.execute();
            PreparedStatement statement2 = Database.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS USE_LOCK (STATUS_LOCK BOOLEAN)");
            statement2.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked() {
        Object object = syncdb;
        synchronized (object) {
            boolean value = false;
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM USE_LOCK");
                ResultSet results = statement.executeQuery();
                value = results.next() ? results.getBoolean("STATUS_LOCK") : false;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocked(boolean value) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM USE_LOCK");
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    PreparedStatement statement1 = Database.getConnection().prepareStatement("UPDATE USE_LOCK SET STATUS_LOCK=?");
                    statement1.setBoolean(1, value);
                    statement1.executeUpdate();
                } else {
                    PreparedStatement insert = Database.getConnection().prepareStatement("INSERT INTO USE_LOCK (STATUS_LOCK) VALUES (?)");
                    insert.setBoolean(1, value);
                    insert.executeUpdate();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, EntryKey> getBitIndex() {
        HashMap<Integer, EntryKey> index = new HashMap<Integer, EntryKey>();
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM INDEX_MAPPING");
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    index.put(results.getInt("BITMASK_INDEX"), new EntryKey(results.getString("ENTRY")));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBitIndex(Map<Integer, EntryKey> index) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                for (Map.Entry<Integer, EntryKey> entry : index.entrySet()) {
                    PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM INDEX_MAPPING WHERE ENTRY=?");
                    statement.setString(1, entry.getValue().toString());
                    ResultSet results = statement.executeQuery();
                    if (results.next()) {
                        PreparedStatement statement1 = Database.getConnection().prepareStatement("UPDATE INDEX_MAPPING SET BITMASK_INDEX=? WHERE ENTRY=?");
                        statement1.setInt(1, entry.getKey());
                        statement1.setString(2, entry.getValue().toString());
                        statement1.executeUpdate();
                        continue;
                    }
                    PreparedStatement insert = Database.getConnection().prepareStatement("INSERT INTO INDEX_MAPPING (BITMASK_INDEX,ENTRY) VALUES (?,?)");
                    insert.setInt(1, entry.getKey());
                    insert.setString(2, entry.getValue().toString());
                    insert.executeUpdate();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean playerExists(UUID uuid) {
        Object object = syncdb;
        synchronized (object) {
            boolean exist = false;
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM USER_PERFERENCES WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    exist = true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return exist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPlayer(UUID uuid, String name) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement insert = Database.getConnection().prepareStatement("INSERT INTO USER_PERFERENCES (UUID,NAME,ITEMSTAND,ITEMDROP,HOLOGRAM) VALUES (?,?,?,?,?)");
                insert.setString(1, uuid.toString());
                insert.setString(2, name);
                insert.setString(3, EMPTY_BITSET);
                insert.setString(4, EMPTY_BITSET);
                insert.setString(5, EMPTY_BITSET);
                insert.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setItemStand(UUID uuid, BitSet bitset) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("UPDATE USER_PERFERENCES SET ITEMSTAND=? WHERE UUID=?");
                statement.setString(1, BitSetUtils.toNumberString(bitset));
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setItemDrop(UUID uuid, BitSet bitset) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("UPDATE USER_PERFERENCES SET ITEMDROP=? WHERE UUID=?");
                statement.setString(1, BitSetUtils.toNumberString(bitset));
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHologram(UUID uuid, BitSet bitset) {
        Object object = syncdb;
        synchronized (object) {
            Database.open();
            try {
                PreparedStatement statement = Database.getConnection().prepareStatement("UPDATE USER_PERFERENCES SET HOLOGRAM=? WHERE UUID=?");
                statement.setString(1, BitSetUtils.toNumberString(bitset));
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<InteractionVisualizerAPI.Modules, BitSet> getPlayerInfo(UUID uuid) {
        HashMap<InteractionVisualizerAPI.Modules, BitSet> map = new HashMap<InteractionVisualizerAPI.Modules, BitSet>();
        Object object = syncdb;
        synchronized (object) {
            block14: {
                Database.open();
                try {
                    PreparedStatement statement = Database.getConnection().prepareStatement("SELECT * FROM USER_PERFERENCES WHERE UUID=?");
                    statement.setString(1, uuid.toString());
                    ResultSet results = statement.executeQuery();
                    results.next();
                    String itemstand = results.getString("ITEMSTAND");
                    String itemdrop = results.getString("ITEMDROP");
                    String hologram = results.getString("HOLOGRAM");
                    try {
                        if (VALID_BITSET.matcher(itemstand).matches()) {
                            map.put(InteractionVisualizerAPI.Modules.ITEMSTAND, BitSetUtils.fromNumberString(itemstand));
                        } else {
                            map.put(InteractionVisualizerAPI.Modules.ITEMSTAND, BitSet.valueOf(ArrayUtils.fromBase64String(itemstand)));
                        }
                        if (VALID_BITSET.matcher(itemdrop).matches()) {
                            map.put(InteractionVisualizerAPI.Modules.ITEMDROP, BitSetUtils.fromNumberString(itemdrop));
                        } else {
                            map.put(InteractionVisualizerAPI.Modules.ITEMDROP, BitSet.valueOf(ArrayUtils.fromBase64String(itemdrop)));
                        }
                        if (VALID_BITSET.matcher(hologram).matches()) {
                            map.put(InteractionVisualizerAPI.Modules.HOLOGRAM, BitSetUtils.fromNumberString(hologram));
                            break block14;
                        }
                        map.put(InteractionVisualizerAPI.Modules.HOLOGRAM, BitSet.valueOf(ArrayUtils.fromBase64String(hologram)));
                    }
                    catch (Throwable e) {
                        new RuntimeException("Unable to load player preference (" + uuid + ")", e).printStackTrace();
                        map.put(InteractionVisualizerAPI.Modules.ITEMSTAND, new BitSet());
                        map.put(InteractionVisualizerAPI.Modules.ITEMDROP, new BitSet());
                        map.put(InteractionVisualizerAPI.Modules.HOLOGRAM, new BitSet());
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

