/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.config;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactionvisualizer.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private static final Map<String, Config> CONFIGS = new HashMap<String, Config>();
    private File file;
    private YamlConfiguration defConfig;
    private YamlConfiguration config;

    public static Config getConfig(String id) {
        return CONFIGS.get(id);
    }

    public static void reloadConfigs() {
        for (Config config : CONFIGS.values()) {
            config.reload();
        }
    }

    public static void saveConfigs() {
        for (Config config : CONFIGS.values()) {
            config.save();
        }
    }

    public static Config loadConfig(String id, File file, InputStream ifNotFound, InputStream def, boolean refreshComments) throws IOException {
        if (CONFIGS.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate config id");
        }
        if (!file.exists()) {
            FileUtils.copy(ifNotFound, file);
        }
        Config config = new Config(file, def, refreshComments);
        CONFIGS.put(id, config);
        return config;
    }

    public static Config loadConfig(String id, File file) throws IOException {
        if (Config.getConfig(id) != null) {
            throw new IllegalArgumentException("Duplicate config id");
        }
        if (!file.exists()) {
            try (PrintWriter pw = new PrintWriter(file);){
                pw.println();
                pw.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        Config config = new Config(file);
        CONFIGS.put(id, config);
        return config;
    }

    public static boolean unloadConfig(String id, boolean save) {
        Config config = CONFIGS.remove(id);
        if (config != null) {
            if (save) {
                config.save();
            }
            return true;
        }
        return false;
    }

    private Config(File file, InputStream def, boolean refreshComments) throws IOException {
        this.file = file;
        this.defConfig = new YamlConfiguration(def);
        this.config = new YamlConfiguration(file);
        for (String path : this.defConfig.getValues(true).keySet()) {
            if (this.config.contains(path)) {
                if (!refreshComments) continue;
                this.config.setAboveComment(path, this.defConfig.getAboveComment(path));
                continue;
            }
            if (this.defConfig.isConfigurationSection(path)) continue;
            this.config.set(path, this.defConfig.get(path));
            this.config.setAboveComment(path, this.defConfig.getAboveComment(path));
        }
        this.save();
    }

    private Config(File file) throws IOException {
        this.config = new YamlConfiguration(file);
        this.save();
    }

    public File getFile() {
        return this.file;
    }

    public void save() {
        this.save(this.file);
    }

    public void save(File file) {
        this.config.save(file);
    }

    public void reload() {
        this.config.reload();
    }

    public YamlConfiguration getConfiguration() {
        return this.config;
    }
}

