/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.DynamicVisualizerEntity;
import com.loohp.interactionvisualizer.entityholders.SurroundingPlaneArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;

public class SpawnerDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("spawner");
    public ConcurrentHashMap<Block, Map<String, Object>> spawnerMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String progressBarCharacter = "";
    private String emptyColor = "&7";
    private String filledColor = "&e";
    private int progressBarLength = 10;
    private String spawnRange = "";
    private DynamicVisualizerEntity.PathType pathType = DynamicVisualizerEntity.PathType.FACE;

    public SpawnerDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Spawner.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.progressBarCharacter = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Spawner.Options.ProgressBarCharacter"));
        this.emptyColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Spawner.Options.EmptyColor"));
        this.filledColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Spawner.Options.FilledColor"));
        this.progressBarLength = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Spawner.Options.ProgressBarLength");
        this.spawnRange = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Spawner.Options.SpawnRange"));
        this.pathType = DynamicVisualizerEntity.PathType.valueOf(InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Spawner.PathType"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.spawnerMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.spawnerMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.spawnerMap.remove(block);
                        return;
                    }
                    if (!this.isSpawner(block.getType())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.spawnerMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbySpawner();
                for (Block block : list) {
                    if (this.spawnerMap.get(block) != null || !this.isActive(block.getLocation()) || !this.isSpawner(block.getType())) continue;
                    HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
                    map.putAll(this.spawnArmorStands(block));
                    this.spawnerMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.spawnerMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.spawnerMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!this.isSpawner(block.getType())) {
                        return;
                    }
                    CreatureSpawner spawner = (CreatureSpawner)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        ArmorStand stand = (ArmorStand)((Map)entry.getValue()).get("1");
                        int activeRange = spawner.getRequiredPlayerRange();
                        if (PlayerLocationManager.hasPlayerNearby(spawner.getLocation(), activeRange, false, player -> !player.getGameMode().equals((Object)GameMode.SPECTATOR))) {
                            int max = spawner.getMaxSpawnDelay();
                            int time = max - spawner.getDelay();
                            String symbol = "";
                            double percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            double i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            symbol = symbol + this.spawnRange.replace("{SpawnRange}", spawner.getSpawnRange() + "");
                            if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals(symbol) || !stand.isCustomNameVisible()) {
                                stand.setCustomNameVisible(true);
                                stand.setCustomName(symbol);
                                PacketManager.updateArmorStandOnlyMeta(stand);
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals("") || stand.isCustomNameVisible()) {
                            stand.setCustomNameVisible(false);
                            stand.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand);
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakSpawner(TileEntityRemovedEvent event) {
        Block block = event.getBlock();
        if (!this.spawnerMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.spawnerMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.spawnerMap.remove(block);
    }

    public Set<Block> nearbySpawner() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.SPAWNER);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation();
        Location loc = origin.clone().add(0.5, 0.2, 0.5);
        SurroundingPlaneArmorStand slot1 = new SurroundingPlaneArmorStand(loc.clone(), 0.7, this.pathType);
        this.setStand(slot1);
        map.put("1", slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot1);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public boolean isSpawner(String material) {
        if (material.equalsIgnoreCase("SPAWNER")) {
            return true;
        }
        return material.equalsIgnoreCase("MOB_SPAWNER");
    }

    public boolean isSpawner(Material material) {
        return this.isSpawner(material.toString());
    }
}

