/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class LecternDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("lectern");
    public ConcurrentHashMap<Block, Map<String, Object>> lecternMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String format1 = "";
    private String format2 = "";

    public LecternDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Lectern.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.format1 = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Lectern.Options.Line1"));
        this.format2 = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Lectern.Options.Line2"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.lecternMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.lecternMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.lecternMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.LECTERN)) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.lecternMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyLectern();
                for (Block block : list) {
                    if (this.lecternMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.LECTERN)) continue;
                    HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
                    map.putAll(this.spawnArmorStands(block));
                    this.lecternMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.lecternMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.lecternMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.LECTERN)) {
                        return;
                    }
                    Lectern lectern = (Lectern)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        Inventory inv = lectern.getInventory();
                        ItemStack itemstack = inv.getItem(0);
                        if (itemstack != null && itemstack.getType().equals((Object)Material.AIR)) {
                            itemstack = null;
                        }
                        ArmorStand stand1 = (ArmorStand)((Map)entry.getValue()).get("1");
                        ArmorStand stand2 = (ArmorStand)((Map)entry.getValue()).get("2");
                        if (itemstack != null && itemstack.getType().equals((Object)Material.WRITTEN_BOOK) && itemstack.hasItemMeta() && itemstack.getItemMeta() != null && itemstack.getItemMeta() instanceof BookMeta) {
                            String line2;
                            String line1;
                            BookMeta meta = (BookMeta)itemstack.getItemMeta();
                            if (InteractionVisualizer.version.isNewerOrEqualTo(MCVersion.V1_15)) {
                                line1 = this.format1.replace("{Title}", meta.getTitle() == null ? "" : NBTEditor.getString(itemstack, "title")).replace("{Author}", meta.getAuthor() == null ? "" : NBTEditor.getString(itemstack, "author")).replace("{Page}", lectern.getPage() + "");
                                line2 = this.format2.replace("{Title}", meta.getTitle() == null ? "" : meta.getTitle()).replace("{Author}", meta.getAuthor() == null ? "" : meta.getAuthor()).replace("{Page}", lectern.getPage() + "");
                            } else {
                                line1 = this.format1.replace("{Title}", meta.getTitle() == null ? "" : meta.getTitle()).replace("{Author}", meta.getAuthor() == null ? "" : meta.getAuthor()).replace("{Page}", lectern.getPage() + "");
                                line2 = this.format2.replace("{Title}", meta.getTitle() == null ? "" : meta.getTitle()).replace("{Author}", meta.getAuthor() == null ? "" : meta.getAuthor()).replace("{Page}", lectern.getPage() + "");
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand1.getCustomName()).equals(line1) || !stand1.isCustomNameVisible()) {
                                stand1.setCustomNameVisible(true);
                                stand1.setCustomName(line1);
                                PacketManager.updateArmorStandOnlyMeta(stand1);
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand2.getCustomName()).equals(line2) || !stand2.isCustomNameVisible()) {
                                stand2.setCustomNameVisible(true);
                                stand2.setCustomName(line2);
                                PacketManager.updateArmorStandOnlyMeta(stand2);
                            }
                        } else {
                            if (!PlainTextComponentSerializer.plainText().serialize(stand1.getCustomName()).equals("") || stand1.isCustomNameVisible()) {
                                stand1.setCustomNameVisible(false);
                                stand1.setCustomName("");
                                PacketManager.updateArmorStandOnlyMeta(stand1);
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand2.getCustomName()).equals("") || stand2.isCustomNameVisible()) {
                                stand2.setCustomNameVisible(false);
                                stand2.setCustomName("");
                                PacketManager.updateArmorStandOnlyMeta(stand2);
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakLectern(TileEntityRemovedEvent event) {
        ArmorStand stand;
        Block block = event.getBlock();
        if (!this.lecternMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.lecternMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("2") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("2");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.lecternMap.remove(block);
    }

    public Set<Block> nearbyLectern() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.LECTERN);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation();
        BlockData blockData = block.getState().getBlockData();
        BlockFace facing = ((Directional)blockData).getFacing();
        Location target = block.getRelative(facing).getLocation();
        Vector direction = target.toVector().subtract(origin.toVector()).multiply(0.2);
        Location loc = origin.clone().add(direction).add(0.5, 1.301, 0.5);
        ArmorStand slot1 = new ArmorStand(loc.clone());
        this.setStand(slot1);
        ArmorStand slot2 = new ArmorStand(loc.clone().add(0.0, -0.3, 0.0));
        this.setStand(slot2);
        map.put("1", slot1);
        map.put("2", slot2);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot2);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }
}

