/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ColorUtils;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import com.loohp.interactionvisualizer.utils.LegacyRecordsUtils;
import com.loohp.interactionvisualizer.utils.TranslationUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class JukeBoxDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("jukebox");
    public ConcurrentHashMap<Block, Map<String, Object>> jukeboxMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private boolean showDiscName = true;

    public JukeBoxDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.JukeBox.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.showDiscName = InteractionVisualizer.plugin.getConfiguration().getBoolean("Blocks.JukeBox.Options.ShowDiscName");
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.jukeboxMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.jukeboxMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        this.jukeboxMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.JUKEBOX)) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        this.jukeboxMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyJukeBox();
                for (Block block : list) {
                    if (this.jukeboxMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.JUKEBOX)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("Item", "N/A");
                    this.jukeboxMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.jukeboxMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.jukeboxMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.JUKEBOX)) {
                        return;
                    }
                    Jukebox jukebox = (Jukebox)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        ItemStack itemstack;
                        Object object = InteractionVisualizer.version.isLegacy() ? (jukebox.getPlaying() == null ? null : (jukebox.getPlaying().equals((Object)Material.AIR) ? null : new ItemStack(jukebox.getPlaying(), 1))) : (jukebox.getRecord() == null ? null : (itemstack = jukebox.getRecord().getType().equals((Object)Material.AIR) ? null : jukebox.getRecord().clone()));
                        if (((Map)entry.getValue()).get("Item") instanceof String) {
                            if (itemstack != null) {
                                String disc;
                                Item item = new Item(jukebox.getLocation().clone().add(0.5, 1.0, 0.5));
                                String string = disc = InteractionVisualizer.version.isLegacy() ? LegacyRecordsUtils.translateFromLegacy(jukebox.getPlaying().toString()) : jukebox.getPlaying().toString();
                                if (this.showDiscName) {
                                    Component text;
                                    if (itemstack.getItemMeta().hasDisplayName()) {
                                        text = ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(this.getColor(disc) + itemstack.getItemMeta().getDisplayName()));
                                    } else {
                                        text = Component.translatable(TranslationUtils.getRecord(disc));
                                        text = text.color(ColorUtils.toTextColor(this.getColor(disc)));
                                    }
                                    item.setCustomName(text);
                                    item.setCustomNameVisible(true);
                                } else {
                                    item.setCustomName("");
                                    item.setCustomNameVisible(false);
                                }
                                item.setItemStack(itemstack);
                                item.setVelocity(new Vector(0, 0, 0));
                                item.setPickupDelay(Short.MAX_VALUE);
                                item.setGravity(false);
                                ((Map)entry.getValue()).put("Item", item);
                                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                                PacketManager.updateItem(item);
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                            }
                        } else {
                            Item item = (Item)((Map)entry.getValue()).get("Item");
                            if (itemstack != null) {
                                if (!item.getItemStack().equals((Object)itemstack)) {
                                    String disc;
                                    item.setItemStack(itemstack);
                                    String string = disc = InteractionVisualizer.version.isLegacy() ? LegacyRecordsUtils.translateFromLegacy(jukebox.getPlaying().toString()) : jukebox.getPlaying().toString();
                                    if (this.showDiscName) {
                                        Component text;
                                        if (itemstack.getItemMeta().hasDisplayName()) {
                                            text = ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(this.getColor(disc) + itemstack.getItemMeta().getDisplayName()));
                                        } else {
                                            text = Component.translatable(TranslationUtils.getRecord(disc));
                                            text = text.color(ColorUtils.toTextColor(this.getColor(disc)));
                                        }
                                        item.setCustomName(text);
                                        item.setCustomNameVisible(true);
                                    } else {
                                        item.setCustomName("");
                                        item.setCustomNameVisible(false);
                                    }
                                    PacketManager.updateItem(item);
                                }
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakJukeBox(TileEntityRemovedEvent event) {
        Block block = event.getBlock();
        if (!this.jukeboxMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.jukeboxMap.get(block);
        if (map.get("Item") instanceof Item) {
            Item item = (Item)map.get("Item");
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
        }
        this.jukeboxMap.remove(block);
    }

    public Set<Block> nearbyJukeBox() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.JUKEBOX);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public ChatColor getColor(String material) {
        switch (material) {
            case "MUSIC_DISC_11": {
                return ChatColor.WHITE;
            }
            case "MUSIC_DISC_13": {
                return ChatColor.GOLD;
            }
            case "MUSIC_DISC_BLOCKS": {
                return ChatColor.RED;
            }
            case "MUSIC_DISC_CAT": {
                return ChatColor.GREEN;
            }
            case "MUSIC_DISC_CHIRP": {
                return ChatColor.DARK_RED;
            }
            case "MUSIC_DISC_FAR": {
                return ChatColor.GREEN;
            }
            case "MUSIC_DISC_MALL": {
                return ChatColor.BLUE;
            }
            case "MUSIC_DISC_MELLOHI": {
                return ChatColor.LIGHT_PURPLE;
            }
            case "MUSIC_DISC_STAL": {
                return ChatColor.WHITE;
            }
            case "MUSIC_DISC_STRAD": {
                return ChatColor.WHITE;
            }
            case "MUSIC_DISC_WAIT": {
                return ChatColor.AQUA;
            }
            case "MUSIC_DISC_WARD": {
                return ChatColor.DARK_AQUA;
            }
            case "MUSIC_DISC_PIGSTEP": {
                return ChatColor.GOLD;
            }
            case "MUSIC_DISC_OTHERSIDE": {
                return ChatColor.BLUE;
            }
            case "MUSIC_DISC_5": {
                return ChatColor.DARK_AQUA;
            }
        }
        return ChatColor.WHITE;
    }
}

