/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerDisplay;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.LocationUtils;
import com.loohp.interactionvisualizer.utils.OpenInvUtils;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DropperDisplay
implements Listener,
VisualizerDisplay {
    public static final EntryKey KEY = new EntryKey("dropper");
    public ConcurrentHashMap<Player, List<Item>> link = new ConcurrentHashMap();

    @Override
    public EntryKey key() {
        return KEY;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseDropper(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.isCancelled()) {
            return;
        }
        if (VanishUtils.isVanished(player)) {
            return;
        }
        if (OpenInvUtils.isSlientChest(player)) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getType().equals((Object)InventoryType.DROPPER)) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (!LocationUtils.isLoaded(event.getView().getTopInventory().getLocation())) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getLocation().getBlock().getType().equals((Object)Material.DROPPER)) {
            return;
        }
        if (event.getClick().equals((Object)ClickType.MIDDLE) && !event.getWhoClicked().getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Block block = topInventory.getLocation().getBlock();
        Location loc = block.getLocation();
        boolean isIn = true;
        boolean isMove = false;
        ItemStack itemstack = null;
        if (event.getRawSlot() >= 0 && event.getRawSlot() < topInventory.getSize()) {
            itemstack = event.getCurrentItem();
            if (itemstack != null) {
                if (itemstack.getType().equals((Object)Material.AIR)) {
                    itemstack = null;
                } else {
                    isIn = false;
                    isMove = true;
                }
            }
            if (itemstack == null) {
                itemstack = event.getCursor();
                if (itemstack != null) {
                    if (itemstack.getType().equals((Object)Material.AIR)) {
                        itemstack = null;
                    } else {
                        isMove = true;
                    }
                }
            } else if (event.getCursor() != null && event.getCursor().getType().equals((Object)itemstack.getType())) {
                isIn = true;
            }
            if (itemstack == null && (event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) || event.getAction().equals((Object)InventoryAction.HOTBAR_SWAP)) && (itemstack = event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) != null) {
                if (itemstack.getType().equals((Object)Material.AIR)) {
                    itemstack = null;
                } else {
                    isMove = true;
                }
            }
        }
        if (itemstack == null && event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && (itemstack = event.getCurrentItem()) != null) {
            if (itemstack.getType().equals((Object)Material.AIR)) {
                itemstack = null;
            } else {
                isMove = true;
            }
        }
        if (event.isShiftClick() && event.getView().getItem(event.getRawSlot()) != null && (isIn ? !InventoryUtils.stillHaveSpace(event.getView().getTopInventory(), event.getView().getItem(event.getRawSlot()).getType()) : !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(event.getRawSlot()).getType()))) {
            return;
        }
        if (event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCurrentItem() != null && !event.getCurrentItem().getType().equals((Object)Material.AIR) && event.getCurrentItem().getType().equals((Object)event.getCursor().getType()) && event.getCurrentItem().getAmount() >= event.getCurrentItem().getType().getMaxStackSize()) {
            return;
        }
        if (isMove) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
            if (itemstack != null) {
                Item item = new Item(loc.clone().add(0.5, 0.5, 0.5).add(event.getWhoClicked().getLocation().getDirection().multiply(-0.8)));
                Vector offset = new Vector(0.0, 0.15, 0.0);
                Vector vector = loc.clone().add(0.5, 0.5, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).add(0.0, -0.5, 0.0).toVector()).multiply(-0.13).add(offset);
                item.setVelocity(vector);
                if (isIn) {
                    item.teleport(event.getWhoClicked().getEyeLocation().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
                    vector = loc.clone().add(0.5, 0.5, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector()).multiply(0.13).add(offset);
                    item.setVelocity(vector);
                }
                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                item.setItemStack(itemstack);
                item.setPickupDelay(Short.MAX_VALUE);
                item.setGravity(true);
                PacketManager.updateItem(item);
                if (!this.link.containsKey(player)) {
                    this.link.put(player, new ArrayList());
                }
                List<Item> list = this.link.get(player);
                list.add(item);
                boolean finalIsIn = isIn;
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    if (finalIsIn) {
                        item.teleport(loc.clone().add(0.5, 0.5, 0.5));
                    } else {
                        item.teleport(event.getWhoClicked().getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
                    }
                    item.setVelocity(new Vector(0.0, 0.0, 0.0));
                    item.setGravity(false);
                    PacketManager.updateItem(item);
                }, 8L);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                    list.remove(item);
                }, 20L);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragDropper(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (!LocationUtils.isLoaded(event.getView().getTopInventory().getLocation())) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getLocation().getBlock().getType().equals((Object)Material.DROPPER)) {
            return;
        }
        boolean ok = false;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            ItemStack item = event.getView().getItem(((Integer)entry.getKey()).intValue());
            if (item == null) {
                ok = true;
                break;
            }
            if (item.getType().equals((Object)Material.AIR)) {
                ok = true;
                break;
            }
            if (!item.getType().equals((Object)((ItemStack)entry.getValue()).getType()) || item.getAmount() >= item.getType().getMaxStackSize()) continue;
            ok = true;
            break;
        }
        if (!ok) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Block block = topInventory.getLocation().getBlock();
        Location loc = block.getLocation();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= topInventory.getSize()) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
            ItemStack itemstack = event.getOldCursor();
            if (itemstack != null && itemstack.getType().equals((Object)Material.AIR)) {
                itemstack = null;
            }
            if (itemstack == null) break;
            Item item = new Item(event.getWhoClicked().getEyeLocation().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
            Vector offset = new Vector(0.0, 0.15, 0.0);
            Vector vector = loc.clone().add(0.5, 0.5, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector()).multiply(0.13).add(offset);
            item.setVelocity(vector);
            PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
            item.setItemStack(itemstack);
            item.setCustomName(System.currentTimeMillis() + "");
            item.setPickupDelay(Short.MAX_VALUE);
            item.setGravity(true);
            PacketManager.updateItem(item);
            if (!this.link.containsKey(player)) {
                this.link.put(player, new ArrayList());
            }
            List<Item> list = this.link.get(player);
            list.add(item);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                item.teleport(loc.clone().add(0.5, 0.5, 0.5));
                item.setVelocity(new Vector(0.0, 0.0, 0.0));
                item.setGravity(false);
                PacketManager.updateItem(item);
            }, 8L);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                list.remove(item);
            }, 20L);
            break;
        }
    }

    @EventHandler
    public void onCloseDropper(InventoryCloseEvent event) {
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (!LocationUtils.isLoaded(event.getView().getTopInventory().getLocation())) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!this.link.containsKey((Player)event.getPlayer())) {
            return;
        }
        List<Item> list = this.link.get((Player)event.getPlayer());
        for (Item item : list) {
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
        }
        this.link.remove((Player)event.getPlayer());
    }
}

